package ru.yandex.canvas.service.video.overlay;

import ru.yandex.canvas.service.TankerKeySet;

public class OverlayValidationException extends RuntimeException {
    private static final TankerKeySet KEYSET = TankerKeySet.OVERLAY_VALIDATION_MESSAGES;

    private Object[] args = new Object[0];

    OverlayValidationException(String message) {
        super(message);
    }

    OverlayValidationException(String message, Object... args) {
        super(message);
        this.args = args;
    }

    @Override
    public String getLocalizedMessage() {
        String message = getMessage();
        if (message.startsWith("{") && message.endsWith("}")) {
            String key = message.substring(1, message.length() - 1);
            return String.format(KEYSET.key(key), args);
        } else {
            return message;
        }
    }
}
