package ru.yandex.canvas.service.video.presets;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import ru.yandex.canvas.service.video.presets.configs.BaseConfig;
import ru.yandex.canvas.service.video.presets.configs.ConfigType;

public class Config {
    private Map<ConfigType, BaseConfig> configs;
    private Supplier<Map<ConfigType, BaseConfig>> configsSupplier;

    public Config(PresetDescription description) {
        init(description);
    }

    protected void init(PresetDescription description) {
        configs = Arrays.stream(ConfigType.values())
                .map(v -> v.getFactory().create(description))
                .filter(Objects::nonNull)
                .collect(Collectors.toMap(
                        BaseConfig::getConfigType, Function.identity()));

    }

    public Map<ConfigType, BaseConfig> getConfigsBeforeFeatures() {
        return configs;
    }

    public Map<ConfigType, BaseConfig> getConfigs() {
        return configsSupplier != null ? configsSupplier.get() : configs;
    }

    public void setConfigsSupplier(Long presetId, Supplier<Map<ConfigType, BaseConfig>> configsSupplier) {
        if (this.configsSupplier != null) {
            throw new IllegalArgumentException("Preset " + presetId + " has multiple configs suppliers!");
        }
        this.configsSupplier = configsSupplier;
    }
}
