package ru.yandex.canvas.service.video.presets;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.canvas.model.validation.ValidColor;
import ru.yandex.canvas.service.video.Geometry;

import static ru.yandex.direct.utils.CommonUtils.nvl;

/**
 * Pojo для чтения src/main/java/ru/yandex/canvas/service/video/presets/preset*.json
 */
public class PresetDescription {
    @JsonProperty("preset_name")
    private String presetName;

    @JsonProperty("preset_id")
    private Long presetId;

    @JsonProperty("theme_name")
    private PresetTheme presetTheme;

    @JsonProperty("ratio_from")
    private String ratioFrom;

    @JsonProperty("ratio_to")
    private String ratioTo;

    @JsonProperty("geometry")
    private Geometry geometry;

    private String thumbnail;

    @ValidColor
    @JsonProperty("body_text_color")
    private String bodyTextColor;

    @ValidColor
    @JsonProperty("body_background_color")
    private String bodyBackgroundColor;

    @ValidColor
    @JsonProperty("domain_color")
    private String domainColor;

    @JsonProperty("title_bg_from_video")
    private Boolean titleBackgroundFromVideo;

    @ValidColor
    @JsonProperty("title_background_color")
    private String titleBackgoundColor;

    @JsonProperty("skip_offset")
    private Long skipOffset;

    @JsonProperty("button_text_present")
    private Boolean buttonTextPresent;

    @JsonProperty("button_present")
    private Boolean buttonPresent;

    @ValidColor
    @JsonProperty("button_limited_color")
    private Boolean buttonLimitedColor;

    @JsonProperty("title_present")
    private Boolean titlePresent;

    @JsonProperty("title_editable")
    private Boolean titleEditable;

    @JsonProperty("body_present")
    private Boolean bodyPresent;

    @JsonProperty("body_editable")
    private Boolean bodyEditable;

    @JsonProperty("domain_present")
    private Boolean domainPresent;

    @JsonProperty("domain_editable")
    private Boolean domainEditable;

    @JsonProperty("disclaimer_present")
    private Boolean disclaimerPresent;

    @JsonProperty("age_present")
    private Boolean agePresent;

    @JsonProperty("age_selectable")
    private Boolean ageSelectable;

    @JsonProperty("age_required")
    private Boolean ageRequired;

    @JsonProperty("legal_present")
    private Boolean legalPresent;

    @JsonProperty("allow_stock_video")
    private Boolean allowStockVideo;

    @JsonProperty("add_tracking_urls")
    private Boolean addTrackingUrl;

    @JsonProperty("add_impression_pixel")
    private Boolean addImpressionPixel;

    @JsonProperty("packshot_present")
    private Boolean packshotPresent;

    @JsonProperty("cpm_audio")
    private Boolean cpmAudio;

    @JsonProperty("is_overlay")
    private Boolean overlay;

    @JsonProperty("custom_preview_template_name")
    private String customPreviewTemplateName;

    @JsonProperty("skip_vpaid")
    private Boolean skipVpaid;

    @JsonProperty("interactive_vpaid")
    private Boolean interactiveVpaid;

    @JsonProperty("allow_recent_video")
    private Boolean allowRecentVideoSource;

    @JsonProperty("show_controls")
    private Boolean controlsAllowed;

    @JsonProperty("custom_positions")
    private List<String> customPositions;

    @JsonProperty("custom_labels")
    private Boolean customLabels;

    @JsonProperty("order")
    private Long order;

    @JsonProperty("use_vpaid_impressions")
    private Boolean useVpaidImpressions;

    @JsonProperty("use_default_body_and_title")
    private Boolean useDefaultBodyAndTitle;

    @JsonProperty("use_tracking_events")
    private Boolean useTrackingEvents;

    @JsonProperty("is_hidden_from_list")
    private Boolean isHiddenFromList;

    @JsonProperty("subtitles_present")
    private Boolean subtitlesPresent;

    private List<PresetTag> tags;

    public Boolean getHiddenFromList() {
        return isHiddenFromList;
    }

    public void setHiddenFromList(Boolean hiddenFromList) {
        isHiddenFromList = hiddenFromList;
    }

    public Long getOrder() {
        return order;
    }

    public void setOrder(Long order) {
        this.order = order;
    }

    public Boolean getAddImpressionPixel() {
        return addImpressionPixel;
    }

    public PresetDescription setAddImpressionPixel(Boolean addImpressionPixel) {
        this.addImpressionPixel = addImpressionPixel;
        return this;
    }

    public Boolean getAddTrackingUrl() {
        return addTrackingUrl;
    }

    public PresetDescription setAddTrackingUrl(Boolean addTrackingUrl) {
        this.addTrackingUrl = addTrackingUrl;
        return this;
    }

    public PresetDescription() {
    }

    public PresetDescription(Long presetId) {
        this.presetId = presetId;
    }

    public String getPresetName() {
        return presetName;
    }

    public void setPresetName(String presetName) {
        this.presetName = presetName;
    }

    public Long getPresetId() {
        return presetId;
    }

    public void setPresetId(Long presetId) {
        this.presetId = presetId;
    }

    public PresetTheme getPresetTheme() {
        return presetTheme;
    }

    public void setPresetTheme(PresetTheme presetTheme) {
        this.presetTheme = presetTheme;
    }

    public String getRatioFrom() {
        return ratioFrom;
    }

    public PresetDescription setRatioFrom(String ratioFrom) {
        this.ratioFrom = ratioFrom;
        return this;
    }

    public String getRatioTo() {
        return ratioTo;
    }

    public PresetDescription setRatioTo(String ratioTo) {
        this.ratioTo = ratioTo;
        return this;
    }

    public Geometry getGeometry() {
        return nvl(geometry, Geometry.WIDE);
    }

    public PresetDescription setGeometry(Geometry geometry) {
        this.geometry = geometry;
        return this;
    }

    public String getThumbnail() {
        return thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public String getBodyTextColor() {
        return bodyTextColor;
    }

    public void setBodyTextColor(String bodyTextColor) {
        this.bodyTextColor = bodyTextColor;
    }

    public String getBodyBackgroundColor() {
        return bodyBackgroundColor;
    }

    public void setBodyBackgroundColor(String bodyBackgroundColor) {
        this.bodyBackgroundColor = bodyBackgroundColor;
    }

    public String getDomainColor() {
        return domainColor;
    }

    public void setDomainColor(String domainColor) {
        this.domainColor = domainColor;
    }

    public Boolean getTitleBackgroundFromVideo() {
        return titleBackgroundFromVideo != null && titleBackgroundFromVideo;
    }

    public void setTitleBackgroundFromVideo(Boolean titleBackgroundFromVideo) {
        this.titleBackgroundFromVideo = titleBackgroundFromVideo;
    }

    public String getTitleBackgoundColor() {
        return titleBackgoundColor;
    }

    public void setTitleBackgoundColor(String titleBackgoundColor) {
        this.titleBackgoundColor = titleBackgoundColor;
    }

    public Long getSkipOffset() {
        return skipOffset;
    }

    public void setSkipOffset(Long skipOffset) {
        this.skipOffset = skipOffset;
    }

    public boolean getButtonTextPresent() {
        return buttonTextPresent != null && buttonTextPresent;
    }

    public void setButtonTextPresent(Boolean buttonTextPresent) {
        this.buttonTextPresent = buttonTextPresent;
    }

    public Boolean getButtonLimitedColor() {
        return buttonLimitedColor != null && buttonLimitedColor;
    }

    public void setButtonLimitedColor(Boolean buttonLimitedColor) {
        this.buttonLimitedColor = buttonLimitedColor;
    }

    public Boolean getButtonPresent() {
        return buttonPresent != null && buttonPresent;
    }

    public void setButtonPresent(Boolean buttonPresent) {
        this.buttonPresent = buttonPresent;
    }

    public Boolean getTitlePresent() {
        return titlePresent;
    }

    public void setTitlePresent(Boolean titlePresent) {
        this.titlePresent = titlePresent;
    }

    public Boolean getTitleEditable() {
        return titleEditable;
    }

    public void setTitleEditable(Boolean titleEditable) {
        this.titleEditable = titleEditable;
    }

    public Boolean getBodyPresent() {
        return bodyPresent;
    }

    public void setBodyPresent(Boolean bodyPresent) {
        this.bodyPresent = bodyPresent;
    }

    public Boolean getBodyEditable() {
        return bodyEditable;
    }

    public boolean isBodyEditable() {
        return bodyEditable != null && bodyEditable;
    }

    public boolean isTitleEditable() {
        return titleEditable != null && titleEditable;
    }

    public boolean isDomainEditable() {
        return domainEditable != null && domainEditable;
    }

    public void setBodyEditable(Boolean bodyEditable) {
        this.bodyEditable = bodyEditable;
    }

    public Boolean getDomainPresent() {
        return domainPresent;
    }

    public void setDomainPresent(Boolean domainPresent) {
        this.domainPresent = domainPresent;
    }

    public Boolean getDomainEditable() {
        return domainEditable != null && domainEditable;
    }

    public void setDomainEditable(Boolean domainEditable) {
        this.domainEditable = domainEditable;
    }

    public Boolean getDisclaimerPresent() {
        return disclaimerPresent;
    }

    public void setDisclaimerPresent(Boolean disclaimerPresent) {
        this.disclaimerPresent = disclaimerPresent;
    }

    public Boolean getAgePresent() {
        return agePresent;
    }

    public void setAgePresent(Boolean agePresent) {
        this.agePresent = agePresent;
    }

    public Boolean getAgeSelectable() {
        return ageSelectable != null && ageSelectable;
    }

    public void setAgeSelectable(Boolean ageSelectable) {
        this.ageSelectable = ageSelectable;
    }

    public Boolean getAgeRequired() {
        return ageRequired != null && ageRequired;
    }

    public void setAgeRequired(Boolean ageRequired) {
        this.ageRequired = ageRequired;
    }

    public Boolean getLegalPresent() {
        return legalPresent;
    }

    public void setLegalPresent(Boolean legalPresent) {
        this.legalPresent = legalPresent;
    }

    public Boolean getAllowStockVideo() {
        return allowStockVideo != null && allowStockVideo;
    }

    public void setAllowStockVideo(Boolean allowStockVideo) {
        this.allowStockVideo = allowStockVideo;
    }

    public Boolean getPackshotPresent() {
        return packshotPresent != null && packshotPresent;
    }

    public void setPackshotPresent(Boolean packshotPresent) {
        this.packshotPresent = packshotPresent;
    }

    public Boolean getCpmAudio() {
        return cpmAudio != null && cpmAudio;
    }

    public void setCpmAudio(Boolean cpmAudio) {
        this.cpmAudio = cpmAudio;
    }

    public Boolean isOverlay() {
        return overlay != null && overlay;
    }

    public void setOverlay(Boolean overlay) {
        this.overlay = overlay;
    }

    public String getCustomPreviewTemplateName() {
        return customPreviewTemplateName;
    }

    public PresetDescription setCustomPreviewTemplateName(String customPreviewTemplateName) {
        this.customPreviewTemplateName = customPreviewTemplateName;
        return this;
    }

    public Boolean getSkipVpaid() {
        return skipVpaid != null && skipVpaid;
    }

    public PresetDescription setSkipVpaid(Boolean skipVpaid) {
        this.skipVpaid = skipVpaid;
        return this;
    }

    public Boolean getInteractiveVpaid() {
        return interactiveVpaid != null && interactiveVpaid;
    }

    public PresetDescription setInteractiveVpaid(Boolean interactiveVpaid) {
        this.interactiveVpaid = interactiveVpaid;
        return this;
    }

    public List<PresetTag> getTags() {
        return tags;
    }

    public void setTags(List<PresetTag> tags) {
        this.tags = tags;
    }

    public Boolean getAllowRecentVideoSource() {
        return allowRecentVideoSource != null && allowRecentVideoSource;
    }

    public PresetDescription setAllowRecentVideoSource(Boolean allowRecentVideoSource) {
        this.allowRecentVideoSource = allowRecentVideoSource;
        return this;
    }

    public Boolean getControlsAllowed() {
        return controlsAllowed != null && controlsAllowed;
    }

    public PresetDescription setControlsAllowed(Boolean controlsAllowed) {
        this.controlsAllowed = controlsAllowed;
        return this;
    }

    public Boolean getCustomLabels() {
        return customLabels != null && customLabels;
    }

    public List<String> getCustomPositions() {
        return customPositions;
    }

    public void setCustomPositions(List<String> customPositions) {
        this.customPositions = customPositions;
    }

    public Boolean getUseVpaidImpressions() {
        return useVpaidImpressions;
    }

    public PresetDescription setUseVpaidImpressions(Boolean useVpaidImpressions) {
        this.useVpaidImpressions = useVpaidImpressions;
        return this;
    }

    public Boolean getUseDefaultBodyAndTitle() {
        return useDefaultBodyAndTitle;
    }

    public void setUseDefaultBodyAndTitle(Boolean useDefaultBodyAndTitle) {
        this.useDefaultBodyAndTitle = useDefaultBodyAndTitle;
    }

    public Boolean getUseTrackingEvents() {
        return useTrackingEvents;
    }

    public void setUseTrackingEvents(Boolean useTrackingEvents) {
        this.useTrackingEvents = useTrackingEvents;
    }

    public Boolean getSubtitlesPresent() {
        return subtitlesPresent != null && subtitlesPresent;
    }

    public void setSubtitlesPresent(Boolean subtitlesPresent) {
        this.subtitlesPresent = subtitlesPresent;
    }
}
