package ru.yandex.canvas.service.video.presets;

import java.util.Locale;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum PresetTag {
    COMMON,
    CPC,
    CPM,
    NON_SKIPPABLE_CPM,
    PRICE_CAMPS_NON_SKIPPABLE_CPM,
    PRICE_CAMPS_YNDX_FRONTPAGE_VIDEO,
    PRICE_CAMPS_CPM,
    CPM_OUTDOOR,
    CPM_INDOOR,
    CPM_AUDIO,
    MOBILE_CONTENT,
    MOBILE_CONTENT_VIDEO,
    OVERLAY;

    @JsonValue
    public String getValue() {
        return toString().toLowerCase();
    }

    @JsonCreator
    public static PresetTag fromString(String name) {
        return PresetTag.valueOf(name.toUpperCase(Locale.ROOT));
    }
}
