package ru.yandex.canvas.service.video.presets;

import java.util.Locale;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum PresetTheme {
    CAUCASUS(),
    MOROZ(),
    LAKE(),
    EMPTY();

    @JsonValue
    public String getValue() {
        return toString().toLowerCase();
    }

    @JsonCreator
    public static PresetTheme fromString(String name) {
        return Optional
                .ofNullable(PresetTheme.valueOf(name.toUpperCase(Locale.ROOT)))
                .orElseThrow(() -> new IllegalArgumentException(name));
    }

}
