package ru.yandex.canvas.service.video.presets.configs;

import java.util.Collections;
import java.util.List;

import com.google.common.collect.ImmutableList;

import ru.yandex.canvas.model.video.addition.options.OptionName;
import ru.yandex.canvas.service.video.presets.PresetDescription;
import ru.yandex.canvas.service.video.presets.configs.options.FileOptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.OptionConfig;

public class AdditionConfig extends BaseConfig {

    private List<OptionConfig> options;

    @Override
    public ConfigType getConfigType() {
        return ConfigType.ADDITION;
    }

    @Override
    public List<OptionConfig> getOptionConfigs() {
        return options;
    }

    public AdditionConfig(PresetDescription description) {
        super(description);

        setTitle("");
        setIsHidden(null);

        List<SourceTypes> audioSources = description.getCpmAudio() ?
                ImmutableList.of(SourceTypes.UPLOAD, SourceTypes.RECENT, SourceTypes.LINK) :
                ImmutableList.of(SourceTypes.STOCK, SourceTypes.RECENT, SourceTypes.RESET);
        List<SourceTypes> packshotSources = description.getCpmAudio() ?
                ImmutableList.of(SourceTypes.UPLOAD, SourceTypes.LINK, SourceTypes.RESET) :
                ImmutableList.of(SourceTypes.UPLOAD, SourceTypes.RECENT, SourceTypes.LINK, SourceTypes.RESET);
        ImmutableList.Builder<SourceTypes> videoSources = ImmutableList.builder();

        videoSources.add(SourceTypes.UPLOAD, SourceTypes.LINK);

        if (description.getAllowRecentVideoSource()) {
            videoSources.add(SourceTypes.RECENT);
        }

        if (description.getAllowStockVideo()) {
            videoSources.add(SourceTypes.STOCK);
        }

//        VideoCreativeType creativeType = VideoCreativeType.fromPresetId(description.getPresetId());
//        // раскомментировать, когда фича про видеоконструктор раскатится на всех
//        if (!description.getCpmAudio() && creativeType != VideoCreativeType.CPM_OUTDOOR) {
//            videoSources.add(SourceTypes.VIDEO_CONSTRUCTOR);
//        }
//
        ImmutableList.Builder<OptionConfig> builder = ImmutableList.builder();

        if (!description.getCpmAudio()) {
            builder.add(FileOptionConfig.builder()
                    .setTitle("video-title")
                    .setTooltip("video-tooltip")
                    .setName(OptionName.VIDEO_ID)
                    .setRequired(true)
                    .setDefaultValue("video_1")
                    .setResourceType("video")
                    .setMultisource(true)
                    .setEditable(true)
                    .setVisible(true)
                    .setAllowedValues(Collections.emptyList())
                    .setSources(videoSources.build())
                    .build());
        }

        builder.add(FileOptionConfig.builder()
                .setTitle("audio-title")
                .setTooltip(description.getCpmAudio() ? "audio-tooltip" : null)
                .setRequired(description.getCpmAudio())
                .setName(OptionName.AUDIO_ID)
                .setDefaultValue(null)
                .setResourceType("audio")
                .setMultisource(true)
                .setEditable(description.getCpmAudio() || description.getAllowStockVideo())
                .setVisible(description.getCpmAudio() || description.getAllowStockVideo())
                .setAllowedValues(Collections.emptyList())
                .setSources(audioSources)
                .setIsCpmAudio(description.getCpmAudio())
                .build());

        if (description.getPackshotPresent()) {
            builder.add(
                    FileOptionConfig.builder()
                            .setTitle(description.getCpmAudio() ? "audio-image-title" : "packshot-title")
                            .setTooltip(description.getCpmAudio() ? "audio-image-tooltip" : "packshot-tooltip")
                            .setRequired(false)
                            .setName(OptionName.PACKSHOT_ID)
                            .setDefaultValue("")
                            .setResourceType("image")
                            .setMultisource(true)
                            .setEditable(true)
                            .setIsPackshot(true)
                            .setIsCropable(true)
                            .setVisible(true)
                            .setAllowedValues(Collections.emptyList())
                            .setSources(packshotSources)
                            .build());
        }

        options = builder.build();
    }
}
