package ru.yandex.canvas.service.video.presets.configs;

import java.util.Collections;
import java.util.List;

import com.google.common.collect.ImmutableList;

import ru.yandex.canvas.model.video.addition.options.OptionName;
import ru.yandex.canvas.service.video.presets.PresetDescription;
import ru.yandex.canvas.service.video.presets.configs.options.AgeOptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.ColorPickerOptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.OptionConfig;

public class AgeConfig extends BaseConfig {
    private List<OptionConfig> options;

    public AgeConfig(PresetDescription description) {
        super(description);
        setTitle("age-group-title");
        setIsHidden(!description.getAgeRequired());

        options = ImmutableList.of(
                ColorPickerOptionConfig.builder()
                        .setTitle("background-color-title")
                        .setName(OptionName.BACKGROUND_COLOR)
                        .setEditable(false)
                        .setVisible(false)
                        .setRequired(true)
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("#000000")
                        .build(),

                ColorPickerOptionConfig.builder()
                        .setTitle("color-title")
                        .setName(OptionName.TEXT_COLOR)
                        .setEditable(false)
                        .setVisible(false)
                        .setRequired(true)
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("#FFFFFF")
                        .build(),

                AgeOptionConfig.builder()
                        .setTitle("content-title")
                        .setName(OptionName.TEXT)
                        .setRequired(false)
                        .setEditable(description.getAgeSelectable())
                        .setVisible(true)
                        .setDefaultValue("18")
                        .setAllowedValues(AgeOptionConfig.getAllowedAges())
                        .build()
        );

    }

    @Override
    public ConfigType getConfigType() {
        return ConfigType.AGE;
    }

    @Override
    public List<OptionConfig> getOptionConfigs() {
        return options;
    }
}
