package ru.yandex.canvas.service.video.presets.configs;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.canvas.model.video.addition.options.OptionName;
import ru.yandex.canvas.service.video.presets.PresetDescription;
import ru.yandex.canvas.service.video.presets.configs.options.OptionConfig;

/**
 * Конфиг - это описание блока (виджета) на фронте, конфиг описывает какие контролы и как нужно отрисовать на фронте
 * чтобы заполнить данные соответстующего элемента
 * На каждый AdditionElement есть конфиг
 * Конфиг содержит список с описаниями опций (контролов на фронте)
 */
public abstract class BaseConfig {

    @JsonProperty("tooltip")
    private String tooltip = null;

    @JsonProperty("title")
    private String title;

    @JsonProperty("canBeHidden")
    private Boolean isHidden;

    @JsonIgnore
    private Map<String, OptionConfig> optionByName;

    @JsonIgnore
    public abstract ConfigType getConfigType();

    @JsonProperty("options")
    public abstract List<OptionConfig> getOptionConfigs();

    public String getTitle() {
        return title;
    }

    public String getTooltip() {
        return tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    public Boolean getIsHidden() {
        return isHidden;
    }

    protected void setIsHidden(Boolean isHidden) {
        this.isHidden = isHidden;
    }


    public BaseConfig(PresetDescription description) {
    }

    @JsonIgnore
    public OptionConfig getOptionConfigByName(OptionName name) {
        return getOptionConfigByName(name.toValue());
    }

    @JsonIgnore
    public OptionConfig getOptionConfigByName(String optionName) {
        if (optionByName == null) {
            List<OptionConfig> optionConfigs = getOptionConfigs();
            if (optionConfigs == null) {
                throw new IllegalStateException("BaseConfig.getOptionConfigByName can't be called before constructor");
            }

            optionByName = optionConfigs.stream().collect(Collectors.toMap(OptionConfig::getName, Function.identity()));
        }
        return optionByName.get(optionName);
    }
}
