package ru.yandex.canvas.service.video.presets.configs;

import java.util.Collections;
import java.util.List;

import com.google.common.collect.ImmutableList;

import ru.yandex.canvas.model.video.addition.options.OptionName;
import ru.yandex.canvas.service.video.presets.PresetDescription;
import ru.yandex.canvas.service.video.presets.configs.options.ColorPickerOptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.OptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.TextOptionConfig;

public class BodyConfig extends BaseConfig {
    private List<OptionConfig> options;

    public BodyConfig(PresetDescription description) {
        super(description);
        setTitle("body-group-title");
        setIsHidden(null);

        ImmutableList.Builder<OptionConfig> builder = ImmutableList.builder();

        builder.add(
                ColorPickerOptionConfig.builder()
                        .setTitle("background-color-title")
                        .setName(OptionName.BACKGROUND_COLOR)
                        .setRequired(true)
                        .setEditable(false)
                        .setVisible(false)
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("#FFFFFF")
                        .build(),

                ColorPickerOptionConfig.builder()
                        .setTitle("color-title")
                        .setName(OptionName.TEXT_COLOR)
                        .setEditable(false)
                        .setRequired(true)
                        .setVisible(false)
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("#000000")
                        .build(),

                TextOptionConfig.builder()
                        .setTitle(description.isBodyEditable() ? "content-title" : "") //TODO lazy_gettext
                        .setName(OptionName.TEXT)
                        .setRequired(true)
                        .setEditable(description.isBodyEditable())
                        .setLimit(81)
                        .setVisible(true)
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("")
                        .build()
        );

        if (description.isBodyEditable()) { //This condition
            builder.add(TextOptionConfig.builder()
                    .setName(OptionName.PLACEHOLDER)
                    .setEditable(false)
                    .setRequired(false)
                    .setVisible(false)
                    .setAllowedValues(Collections.emptyList())
                    .setDefaultValue("")
                    .build());
        }

        options = builder.build();
    }

    @Override
    public ConfigType getConfigType() {
        return ConfigType.BODY;
    }

    @Override
    public List<OptionConfig> getOptionConfigs() {
        return options;
    }
}
