package ru.yandex.canvas.service.video.presets.configs;

import java.util.Collections;
import java.util.List;

import com.google.common.collect.ImmutableList;

import ru.yandex.canvas.model.video.addition.options.OptionName;
import ru.yandex.canvas.service.video.presets.PresetDescription;
import ru.yandex.canvas.service.video.presets.configs.options.ColorPickerOptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.CustomLabelOptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.OptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.PositionOptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.TextOptionConfig;

import static ru.yandex.canvas.VideoConstants.GOOD_COLORS;

public class ButtonConfig extends BaseConfig {
    private List<OptionConfig> options;

    public ButtonConfig(PresetDescription description) {
        super(description);
        setTitle("button-group-title");
        setTooltip("button-group-tooltip");
        setIsHidden(null);

        ImmutableList.Builder<OptionConfig> listBuilder = ImmutableList.builder();

        listBuilder.add(
                ColorPickerOptionConfig.builder()
                        .setTitle("background-color-title")
                        .setName(OptionName.COLOR)
                        .setRequired(true)
                        .setTooltip("button-background-color-tooltip")
                        .setEditable(true)
                        .setVisible(true)
                        .setAllowedValues(description.getButtonLimitedColor() ? GOOD_COLORS : Collections.emptyList())
                        .setDefaultValue("#000000")
                        .build(),

                ColorPickerOptionConfig.builder()
                        .setTitle("color-title")
                        .setName(OptionName.TEXT_COLOR)
                        .setEditable(true)
                        .setRequired(true)
                        .setVisible(true)
                        .setAllowedValues(ImmutableList.of("#000000", "#ffffff")) // only black and white
                        .setDefaultValue("#000000")
                        .build(),

                ColorPickerOptionConfig.builder()
                        .setTitle("border-color-title")
                        .setName(OptionName.BORDER_COLOR)
                        .setEditable(false)
                        .setVisible(false)
                        .setRequired(false)
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("#000000")
                        .build()
        );

        if (description.getButtonTextPresent()) {
            listBuilder.add(TextOptionConfig.builder()
                    .setTitle("content-title")
                    .setName(OptionName.TEXT)
                    .setEditable(true)
                    .setRequired(true)
                    .setLimit(17)
                    .setVisible(true)
                    .setAllowedValues(Collections.emptyList())
                    .setDefaultValue("")
                    .build());

            listBuilder.add(TextOptionConfig.builder()
                    .setName(OptionName.PLACEHOLDER)
                    .setEditable(false)
                    .setRequired(false)
                    .setVisible(false)
                    .setAllowedValues(Collections.emptyList())
                    .setDefaultValue("")
                    .build());
        }

        if (description.getCustomPositions() != null) {
            listBuilder.add(PositionOptionConfig.builder()
                    .setTitle("position-title")
                    .setName(OptionName.POSITION)
                    .setEditable(true)
                    .setVisible(true)
                    .setAllowedValues(description.getCustomPositions())
                    .setDefaultValue("left-bottom")
                    .build());
        }

        if (description.getCustomLabels()) {
            listBuilder.add(CustomLabelOptionConfig.builder()
                    .setTitle("content-title")
                    .setName(OptionName.CUSTOM_LABEL)
                    .setEditable(true)
                    .setVisible(true)
                    .setAllowedValues(CustomLabelOptionConfig.getAllowedPositions())
                    .setDefaultValue("btn-go-site")
                    .build());
        }

        options = listBuilder.build();
    }

    @Override
    public ConfigType getConfigType() {
        return ConfigType.BUTTON;
    }

    @Override
    public List<OptionConfig> getOptionConfigs() {
        return options;
    }

}
