package ru.yandex.canvas.service.video.presets.configs;

import java.util.Collections;
import java.util.List;

import com.google.common.collect.ImmutableList;

import ru.yandex.canvas.model.video.addition.options.OptionName;
import ru.yandex.canvas.service.video.presets.PresetDescription;
import ru.yandex.canvas.service.video.presets.configs.options.ColorPickerOptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.OptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.TextOptionConfig;

public class DisclaimerConfig extends BaseConfig {
    private List<OptionConfig> options;

    public DisclaimerConfig(PresetDescription description) {
        super(description);
        setTitle("disclaimer-group-title");
        setIsHidden(null);

        options = ImmutableList.of(
                TextOptionConfig.builder()
                        .setTitle("content-title") //TODO lazy_gettext
                        .setName(OptionName.TEXT)
                        .setEditable(false)
                        .setVisible(true)
                        .setRequired(false)
                        .setLimit(null)
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("")
                        .build(),

                ColorPickerOptionConfig.builder()
                        .setTitle("background-color-title")
                        .setName(OptionName.BACKGROUND_COLOR)
                        .setEditable(false)
                        .setVisible(false)
                        .setRequired(true)
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("#000000")
                        .build(),

                ColorPickerOptionConfig.builder()
                        .setTitle("color-title")
                        .setName(OptionName.TEXT_COLOR)
                        .setEditable(false)
                        .setVisible(false)
                        .setRequired(true)
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("#FFFFFF")
                        .build()
        );

    }

    @Override
    public ConfigType getConfigType() {
        return ConfigType.DISCLAIMER;
    }

    @Override
    public List<OptionConfig> getOptionConfigs() {
        return options;
    }
}
