package ru.yandex.canvas.service.video.presets.configs;

import java.util.Collections;
import java.util.List;

import com.google.common.collect.ImmutableList;

import ru.yandex.canvas.model.video.addition.options.OptionName;
import ru.yandex.canvas.service.video.presets.PresetDescription;
import ru.yandex.canvas.service.video.presets.configs.options.ColorPickerOptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.DomainOptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.OptionConfig;

public class DomainConfig extends BaseConfig {
    private List<OptionConfig> options;

    public DomainConfig(PresetDescription description) {
        super(description);

        setTitle("domain-group-title");
        setIsHidden(null);

        ImmutableList.Builder<OptionConfig> listBuilder = ImmutableList.builder();
        listBuilder.add(
                ColorPickerOptionConfig.builder()
                        .setTitle("color-title")
                        .setName(OptionName.TEXT_COLOR)
                        .setRequired(description.getDomainEditable())
                        .setEditable(description.getDomainColor() != null)
                        .setVisible(description.getDomainColor() != null)
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("#857b8c")
                        .build()
        );

        if (description.isDomainEditable()) {
            listBuilder.add(
                    DomainOptionConfig.domainBuilder()
                            .setTitle("content-title") //TODO lazy_gettext
                            .setName(OptionName.TEXT)
                            .setRequired(true)
                            .setEditable(true)
                            .setLimit(50)
                            .setVisible(true)
                            .setAllowedValues(Collections.emptyList())
                            .setDefaultValue("")
                            .build()
            );

        }

        options = listBuilder.build();
    }

    @Override
    public ConfigType getConfigType() {
        return ConfigType.DOMAIN;
    }

    @Override
    public List<OptionConfig> getOptionConfigs() {
        return options;
    }
}
