package ru.yandex.canvas.service.video.presets.configs;

import java.util.Collections;
import java.util.List;

import com.google.common.collect.ImmutableList;

import ru.yandex.canvas.model.video.addition.options.OptionName;
import ru.yandex.canvas.service.video.presets.PresetDescription;
import ru.yandex.canvas.service.video.presets.configs.options.ColorPickerOptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.OptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.TextOptionConfig;

public class LegalConfig extends BaseConfig {
    private List<OptionConfig> options;

    public LegalConfig(PresetDescription description) {
        super(description);
        setTitle("legal-group-title");
        setIsHidden(true);

        options = ImmutableList.of(
                ColorPickerOptionConfig.builder()
                        .setTitle("background-color-title") //TODO lazy_gettext
                        .setName(OptionName.BACKGROUND_COLOR)
                        .setEditable(false)
                        .setRequired(true)
                        .setVisible(false)
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("#000000")
                        .build(),

                TextOptionConfig.builder()
                        .setTitle("content-title")
                        .setName(OptionName.TEXT)
                        .setEditable(true)
                        .setVisible(true)
                        .setRequired(true)
                        .setLimit(700)
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("")
                        .build(),

                ColorPickerOptionConfig.builder()
                        .setTitle("color-title") //TODO lazy_gettext
                        .setName(OptionName.TEXT_COLOR)
                        .setEditable(false)
                        .setRequired(true)
                        .setVisible(false)
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("#FFFFFF")
                        .build()

        );

    }

    @Override
    public ConfigType getConfigType() {
        return ConfigType.LEGAL;
    }

    @Override
    public List<OptionConfig> getOptionConfigs() {
        return options;
    }
}
