package ru.yandex.canvas.service.video.presets.configs;

import java.util.Collections;
import java.util.List;

import com.google.common.collect.ImmutableList;

import ru.yandex.canvas.model.video.addition.options.OptionName;
import ru.yandex.canvas.service.video.presets.PresetDescription;
import ru.yandex.canvas.service.video.presets.configs.options.ColorPickerOptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.OptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.TextAreaOptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.TextOptionConfig;

public class SubtitlesConfig extends BaseConfig {
    private List<OptionConfig> options;

    public SubtitlesConfig(PresetDescription description) {
        super(description);
        setTitle("subtitles-group-title");
        setTooltip("subtitles-group-tooltip");
        //Субтитры необязательно заполнять по дефолту
        setIsHidden(true);

        options = ImmutableList.of(
                ColorPickerOptionConfig.builder()
                        .setTitle("background-color-title")
                        .setName(OptionName.BACKGROUND_COLOR)
                        .setEditable(false)
                        .setVisible(false)
                        .setRequired(true)
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("#000000") //black
                        .build(),

                ColorPickerOptionConfig.builder()
                        .setTitle("color-title")
                        .setName(OptionName.TEXT_COLOR)
                        .setEditable(false)
                        .setRequired(true)
                        .setVisible(false)
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("#FFFFFF") //white
                        .build(),

                TextAreaOptionConfig.builder()
                        .setTitle("content-title")
                        .setName(OptionName.TEXT)
                        .setEditable(true)
                        .setVisible(true)
                        .setRequired(false)
                        .setLimit(10000)
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("")
                        .build(),

                TextOptionConfig.builder()
                        .setName(OptionName.PLACEHOLDER)
                        .setEditable(false)
                        .setRequired(false)
                        .setVisible(false)
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("")
                        .build()
        );
    }

    @Override
    public ConfigType getConfigType() {
        return ConfigType.SUBTITLES;
    }

    @Override
    public List<OptionConfig> getOptionConfigs() {
        return options;
    }
}
