package ru.yandex.canvas.service.video.presets.configs;

import java.util.Collections;
import java.util.List;

import com.google.common.collect.ImmutableList;

import ru.yandex.canvas.model.video.addition.options.OptionName;
import ru.yandex.canvas.service.video.presets.PresetDescription;
import ru.yandex.canvas.service.video.presets.configs.options.ColorPickerOptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.OptionConfig;
import ru.yandex.canvas.service.video.presets.configs.options.TextOptionConfig;

public class TitleConfig extends BaseConfig {
    private List<OptionConfig> optionConfigs;

    @Override
    public ConfigType getConfigType() {
        return ConfigType.TITLE;
    }

    @Override
    public List<OptionConfig> getOptionConfigs() {
        return optionConfigs;
    }

    public TitleConfig(PresetDescription description) {
        super(description);
        setTitle("title-group-title");
        setIsHidden(null);

        ImmutableList.Builder<OptionConfig> builder = ImmutableList.<OptionConfig>builder().add(
                ColorPickerOptionConfig.builder()
                        .setTitle("background-color-title")
                        .setName(OptionName.BACKGROUND_COLOR)
                        .setRequired(true)
                        .setEditable(description.getTitleBackgroundFromVideo())
                        .setVisible(description.getTitleBackgroundFromVideo())
                        .setDependsOnVideoColor(description.getTitleBackgroundFromVideo())
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("Title")
                        .build(),

                ColorPickerOptionConfig.builder()
                        .setTitle("color-title")
                        .setName(OptionName.TEXT_COLOR)
                        .setRequired(true)
                        .setEditable(false)
                        .setVisible(false)
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("#FFFFFF")
                        .build(),

                TextOptionConfig.builder()
                        .setTitle(description.isTitleEditable() ? "content-title" : "")
                        .setName(OptionName.TEXT)
                        .setRequired(description.isTitleEditable())
                        .setEditable(description.isTitleEditable())
                        .setLimit(35)
                        .setVisible(true)
                        .setAllowedValues(Collections.emptyList())
                        .setDefaultValue("")
                        .build()
        );

        if (description.isTitleEditable()) {
            builder.add(TextOptionConfig.builder()
                    .setName(OptionName.PLACEHOLDER)
                    .setEditable(false)
                    .setRequired(false)
                    .setVisible(false)
                    .setAllowedValues(Collections.emptyList())
                    .setDefaultValue("")
                    .build());
        }

        optionConfigs = builder.build();

    }
}
