package ru.yandex.canvas.service.video.presets.configs.options;

import java.util.List;

import com.google.common.collect.ImmutableList;

public class AgeOptionConfig extends OptionConfig {
    private static final List<String> ALLOWED_AGES = ImmutableList.of("0", "6", "12", "16", "18");

    private AgeOptionConfig() {
    }

    protected AgeOptionConfig(AgeOptionConfig ageConfigOption) {
        super(ageConfigOption);
        this.allowedValues = ALLOWED_AGES;
        setType(OptionType.AGE);
    }

    public static AgeOptionConfig.Builder builder() {
        return new AgeOptionConfig().new Builder();
    }

    public class Builder extends OptionConfig.Builder<AgeOptionConfig, AgeOptionConfig.Builder> {
        @Override
        public AgeOptionConfig build() {
            return new AgeOptionConfig(AgeOptionConfig.this);
        }
    }

    public static List<String> getAllowedAges() {
        return ALLOWED_AGES;
    }

}
