package ru.yandex.canvas.service.video.presets.configs.options;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

public class ColorPickerOptionConfig extends ColoredOptionConfig {

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty("dependsOnVideoColor")
    private Boolean dependsOnVideoColor = null;

    private ColorPickerOptionConfig() {
    }

    protected ColorPickerOptionConfig(ColorPickerOptionConfig option) {
        super(option);
        this.dependsOnVideoColor = option.getDependsOnVideoColor();

    }

    public Boolean getDependsOnVideoColor() {
        return dependsOnVideoColor;
    }

    public static Builder builder() {
        return new ColorPickerOptionConfig().new Builder();
    }

    public class Builder extends ColoredOptionConfig.Builder<ColorPickerOptionConfig, ColorPickerOptionConfig.Builder> {

        public Builder setDependsOnVideoColor(Boolean dependsOnVideoColor) {
            ColorPickerOptionConfig.this.dependsOnVideoColor = dependsOnVideoColor;
            return this;
        }

        @Override
        public ColorPickerOptionConfig build() {
            return new ColorPickerOptionConfig(ColorPickerOptionConfig.this);
        }
    }

}
