package ru.yandex.canvas.service.video.presets.configs.options;

import java.util.List;

public class CustomLabelOptionConfig extends OptionConfig {
    private static final List<String> ALLOWED_VALUES =
            List.of("btn-more", "btn-go-site", "btn-watch", "btn-on", "btn-start",
                    "btn-application", "btn-book", "btn-offer", "btn-buy",
                    // -- always at the end
                    "btn-no-text");

    private CustomLabelOptionConfig() {
    }

    protected CustomLabelOptionConfig(CustomLabelOptionConfig ageConfigOption) {
        super(ageConfigOption);
        this.allowedValues = ALLOWED_VALUES;
        setType(OptionType.SELECT);
    }

    public static CustomLabelOptionConfig.Builder builder() {
        return new CustomLabelOptionConfig().new Builder();
    }

    public class Builder extends OptionConfig.Builder<CustomLabelOptionConfig, CustomLabelOptionConfig.Builder> {
        @Override
        public CustomLabelOptionConfig build() {
            return new CustomLabelOptionConfig(CustomLabelOptionConfig.this);
        }
    }

    public static List<String> getAllowedPositions() {
        return ALLOWED_VALUES;
    }

}
