package ru.yandex.canvas.service.video.presets.configs.options;

import java.util.List;
import java.util.function.Supplier;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.canvas.service.video.presets.configs.SourceTypes;

public class FileOptionConfig extends OptionConfig {

    private String resourceType;

    @JsonProperty("isMultisource")
    private Boolean multisource;

    @JsonProperty("isPackshot")
    private Boolean isPackshot = false;

    @JsonProperty("isCpmAudio")
    private Boolean isCpmAudio = false;

    @JsonProperty("isCroppable")
    private Boolean isCroppable = false;

    public Boolean getPackshot() {
        return isPackshot;
    }

    public Boolean getCpmAudio() {
        return isCpmAudio;
    }

    public Boolean getIsCroppable() {
        return isCroppable;
    }

    @JsonIgnore
    private List<SourceTypes> sources;

    @JsonIgnore
    private Supplier<List<SourceTypes>> sourcesSupplier;

    protected FileOptionConfig() {
    }

    protected FileOptionConfig(FileOptionConfig option) {
        super(option);

        this.resourceType = option.getResourceType();
        this.multisource = option.getMultisource();
        this.sources = option.getSources();
        this.isCroppable = option.getIsCroppable();
        this.isPackshot = option.getPackshot();
        this.isCpmAudio = option.getCpmAudio();

        setType(OptionType.FILE);
    }

    public String getResourceType() {
        return resourceType;
    }

    public Boolean getMultisource() {
        return multisource;
    }

    @JsonProperty("sources")
    public List<SourceTypes> getSourcesHacked() {
        return sourcesSupplier != null ? sourcesSupplier.get() : sources;
    }

    public List<SourceTypes> getSources() {
        return sources ;
    }

    public static Builder builder() {
        return new FileOptionConfig().new Builder();
    }

    public class Builder
            extends OptionConfig.Builder<FileOptionConfig, FileOptionConfig.Builder> {
        protected Builder() {
        }

        public FileOptionConfig.Builder setResourceType(String resourceType) {
            FileOptionConfig.this.resourceType = resourceType;
            return this;
        }

        public FileOptionConfig.Builder setMultisource(Boolean multisource) {
            FileOptionConfig.this.multisource = multisource;
            return this;
        }

        public FileOptionConfig.Builder setSources(List<SourceTypes> sources) {
            FileOptionConfig.this.sources = sources;
            return this;
        }

        public FileOptionConfig.Builder setIsPackshot(Boolean isPackshot) {
            FileOptionConfig.this.isPackshot = isPackshot;
            return this;
        }

        public FileOptionConfig.Builder setIsCpmAudio(Boolean isCpmAudio) {
            FileOptionConfig.this.isCpmAudio = isCpmAudio;
            return this;
        }

        public FileOptionConfig.Builder setIsCropable(Boolean isCropable) {
            FileOptionConfig.this.isCroppable = isCropable;
            return this;
        }

        public FileOptionConfig build() {
            return new FileOptionConfig(FileOptionConfig.this);
        }
    }

    public FileOptionConfig setSourcesSupplier(Supplier<List<SourceTypes>> sourcesSupplier) {
        this.sourcesSupplier = sourcesSupplier;
        return this;
    }
}
