package ru.yandex.canvas.service.video.presets.configs.options;

import java.util.Collections;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.canvas.model.video.addition.options.OptionName;

@JsonInclude(JsonInclude.Include.ALWAYS)
public abstract class OptionConfig {

    @JsonProperty("title")
    private String title = "";

    @JsonProperty("name")
    private String name = "";

    @JsonProperty("tooltip")
    private String tooltip = null;

    @JsonProperty("editable")
    private Boolean editable = false;

    @JsonProperty("visible")
    private Boolean visible = false;

    @JsonIgnore
    private Boolean required = false;

    @JsonProperty("defaultValue")
    private String defaultValue = "";

    @JsonProperty("allowedValues")
    protected List<String> allowedValues = Collections.emptyList();

    @JsonIgnore
    private OptionType type;

    protected OptionConfig() {
    }

    public OptionConfig(OptionConfig option) {
        this.title = option.getTitle();
        this.name = option.getName();
        this.allowedValues = option.getAllowedValues();
        this.tooltip = option.getTooltip();
        this.editable = option.getEditable();
        this.visible = option.getVisible();
        this.required = option.getRequired();
        this.defaultValue = option.getDefaultValue();
        this.type = option.getType();
    }

    public OptionType getType() {
        return type;
    }

    @JsonProperty("type")
    public String getTypeName() {
        return type.valueOf();
    }

    protected void setType(OptionType type) {
        OptionConfig.this.type = type;
    }

    public String getTitle() {
        return title;
    }

    public String getName() {
        return name;
    }

    public OptionName getOptionName() {
        return OptionName.fromValue(name);
    }

    public String getTooltip() {
        return tooltip;
    }

    public List<String> getAllowedValues() {
        return allowedValues;
    }

    public Boolean getEditable() {
        return editable;
    }

    public Boolean getVisible() {
        return visible;
    }

    public Boolean getRequired() {
        return required;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public abstract class Builder<T extends OptionConfig, G extends OptionConfig.Builder> {
        protected Builder() {
        }

        public G setTitle(String title) {
            OptionConfig.this.title = title;
            return (G) this;
        }

        public G setName(OptionName name) {
            OptionConfig.this.name = name.toValue();
            return (G) this;
        }

        public G setName(String name) {
            OptionConfig.this.name = name;
            return (G) this;
        }

        public G setAllowedValues(List<String> allowedValues) {
            OptionConfig.this.allowedValues = allowedValues;
            return (G) this;
        }

        public G setTooltip(String tooltip) {
            OptionConfig.this.tooltip = tooltip;
            return (G) this;
        }

        public G setEditable(Boolean editable) {
            OptionConfig.this.editable = editable;
            return (G) this;
        }

        public G setVisible(Boolean visible) {
            OptionConfig.this.visible = visible;
            return (G) this;
        }

        public G setRequired(Boolean required) {
            OptionConfig.this.required = required;
            return (G) this;
        }

        public G setDefaultValue(String defaultValue) {
            OptionConfig.this.defaultValue = defaultValue;
            return (G) this;
        }

        public abstract T build();
    }

    public enum OptionType {
        COLOR_PICKER("colorpicker"),
        TEXT("text"),
        AGE("age"),
        FILE("file"),
        POSITION("position"),
        SELECT("select"),
        TEXT_AREA("textarea");

        private String typeName;

        OptionType(String typeName) {
            this.typeName = typeName;
        }

        public String valueOf() {
            return this.typeName;
        }
    }
}
