package ru.yandex.canvas.service.video.presets.configs.options;

import com.fasterxml.jackson.annotation.JsonProperty;

public class TextOptionConfig extends OptionConfig {

    @JsonProperty("limit")
    protected Integer limit = 0;

    public Integer getLimit() {
        return limit == null ? Integer.valueOf(0) : limit;
    }

    protected TextOptionConfig() {
    }

    protected TextOptionConfig(TextOptionConfig option) {
        super(option);
        this.limit = option.getLimit();
        setType(OptionType.TEXT);
    }

    public static Builder builder() {
        return new TextOptionConfig().new Builder();
    }

    public class Builder extends OptionConfig.Builder<TextOptionConfig, TextOptionConfig.Builder> {
        protected Builder() {
        }

        public TextOptionConfig.Builder setLimit(Integer limit) {
            TextOptionConfig.this.limit = limit;
            return this;
        }

        public TextOptionConfig build() {
            return new TextOptionConfig(TextOptionConfig.this);
        }

    }

}
