package ru.yandex.canvas.service.video.presets.elements;

import java.util.Map;

import ru.yandex.canvas.service.video.Geometry;
import ru.yandex.canvas.service.video.presets.PresetDescription;

import static ru.yandex.canvas.service.video.Geometry.SQUARE;
import static ru.yandex.canvas.service.video.Geometry.TALL;
import static ru.yandex.canvas.service.video.Geometry.UNIVERSAL;
import static ru.yandex.canvas.service.video.Geometry.WIDE;

public class AdditionElement extends PresetElement<ElementFilesOptions> {

    static final String DEFAULT_VIDEO = "new_0_0-077.mov"; //BANNERSTORAGE-5515
    static final Map<Geometry, String> DEFAULT_VIDEO_BY_GEOMETRY = Map.of(
            TALL, "default_tall.mov",
            SQUARE, "default_square.mov",
            WIDE, DEFAULT_VIDEO,
            UNIVERSAL, DEFAULT_VIDEO
    );

    public AdditionElement(PresetDescription description) {
        super(description);
        this.setType(PresetElementType.ADDITION);
        this.setAvailable(true);
        String videoId = DEFAULT_VIDEO;

        if (description != null //для вертикального и квадратного видео сделаем подложку в зависимости от геометрии
                && description.getGeometry() != WIDE) {
            videoId = DEFAULT_VIDEO_BY_GEOMETRY.getOrDefault(description.getGeometry(), DEFAULT_VIDEO);
        }
        this.setOptions(new ElementFilesOptions()
                .setVideoId(videoId));
    }

}
