package ru.yandex.canvas.service.video.presets.elements;

import ru.yandex.canvas.service.video.presets.PresetDescription;

public class BodyElement extends PresetElement<ElementTextOptions> {

    public BodyElement(PresetDescription description) {
        super(description);
        this.setType(PresetElementType.BODY);
        this.setAvailable(true);

        ElementTextOptions options = new ElementTextOptions()
                .setBackgroundColor(description.getBodyBackgroundColor())
                .setTextColor(description.getBodyTextColor());

        if (description.isBodyEditable()) {
            options
                    .setText("")
                    .setPlaceholder("body_placeholder");
        }

        this.setOptions(options);
    }

}
