package ru.yandex.canvas.service.video.presets.elements;

import ru.yandex.canvas.service.video.presets.PresetDescription;

import static ru.yandex.canvas.VideoConstants.GOOD_COLORS;

public class ButtonElement extends PresetElement<ElementTextOptions> {

    public ButtonElement(PresetDescription description) {
        super(description);
        this.setType(PresetElementType.BUTTON);
        this.setAvailable(true);

        ElementButtonOptions options = new ElementButtonOptions()
                .setColor(GOOD_COLORS.get(0))
                .setTextColor("#000000")
                .setBorderColor("");

        if (description.getButtonTextPresent()) {
            options
                    .setText("")
                    .setPlaceholder("button_text_placeholder");
        }

        this.setOptions(options);
    }

}
