package ru.yandex.canvas.service.video.presets.elements;

import ru.yandex.canvas.service.video.presets.PresetDescription;

public class DomainElement extends PresetElement<ElementTextOptions> {

    public DomainElement(PresetDescription description) {
        super(description);
        this.setType(PresetElementType.DOMAIN);
        this.setAvailable(true);

        ElementTextOptions options = new ElementTextOptions();

        if (description.getDomainColor() != null) {
            options.setTextColor(description.getDomainColor());
        }

        if (description.getDomainEditable()) {
            options
                    .setText("")
                    .setPlaceholder("domain_placeholder"); //TODO lazy_gettext

        }

        this.setOptions(options);
    }

}
