package ru.yandex.canvas.service.video.presets.elements;

import com.fasterxml.jackson.annotation.JsonProperty;

public class ElementTextOptions<T extends ElementTextOptions> extends BaseElementOptions {

    @JsonProperty("text_color")
    private String textColor;

    @JsonProperty("text")
    private String text;

    @JsonProperty("background_color")
    private String backgroundColor;

    @JsonProperty("placeholder")
    private String placeholder;

    public String getTextColor() {
        return textColor;
    }

    public T setTextColor(String textColor) {
        this.textColor = textColor;
        return (T) this;
    }

    public String getText() {
        return text;
    }

    public T setText(String text) {
        this.text = text;
        return (T) this;
    }

    public String getBackgroundColor() {
        return backgroundColor;
    }

    public T setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return (T) this;
    }

    public String getPlaceholder() {
        return placeholder;
    }

    public T setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        return (T) this;
    }
}
