package ru.yandex.canvas.service.video.presets.elements;

import ru.yandex.canvas.service.video.presets.PresetDescription;

public class LegalElement extends PresetElement<ElementTextOptions> {

    public LegalElement(PresetDescription description) {
        super(description);
        this.setType(PresetElementType.LEGAL);
        //Юридическую информацию необязательно заполнять по дефолту - соотносится с setIsHidden(true) в LegalConfig
        this.setAvailable(false);

        ElementTextOptions options = new ElementTextOptions()
                .setTextColor("#ffffff")
                .setText("")
                .setPlaceholder("opf_text_placeholder") //TODO lazy_gettext
                .setBackgroundColor("#000000");


        this.setOptions(options);
    }

}
