package ru.yandex.canvas.service.video.presets.elements;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.canvas.service.video.presets.PresetDescription;

public abstract class PresetElement<G extends BaseElementOptions> {

    @JsonProperty("type")
    protected PresetElementType type;

    @JsonProperty("available")
    protected Boolean available;

    @JsonProperty("options")
    protected BaseElementOptions options;

    public G getOptions() {
        return (G) options;
    }

    public void setOptions(G options) {
        this.options = options;
    }

    public PresetElement(PresetDescription description) {

    }

    public PresetElementType getType() {
        return type;
    }

    public PresetElement<G> setType(PresetElementType type) {
        this.type = type;
        return this;
    }

    public Boolean getAvailable() {
        return available;
    }

    public PresetElement<G> setAvailable(Boolean available) {
        this.available = available;
        return this;
    }
}
