package ru.yandex.canvas.service.video.presets.elements;

import com.fasterxml.jackson.annotation.JsonValue;

public enum PresetElementType {
    ADDITION(AdditionElementFactory.INSTANCE),
    TITLE(TitleElementFactory.INSTANCE),
    BODY(BodyElementFactory.INSTANCE),
    DOMAIN(DomainElementFactory.INSTANCE),
    BUTTON(ButtonElementFactory.INSTANCE),
    DISCLAIMER(DisclaimerElementFactory.INSTANCE),
    AGE(AgeElementFactory.INSTANCE),
    LEGAL(LegalElementFactory.INSTANCE),
    SUBTITLES(SubtitlesElementFactory.INSTANCE);

    private ElementFactory factory;

    PresetElementType(ElementFactory factory) {
        this.factory = factory;
    }

    public ElementFactory getFactory() {
        return factory;
    }

    @JsonValue
    public String getValue() {
        return name().toLowerCase();
    }

}
