package ru.yandex.canvas.service.video.presets.elements;

import ru.yandex.canvas.service.video.presets.PresetDescription;

public class SubtitlesElement extends PresetElement<ElementTextOptions> {

    public SubtitlesElement(PresetDescription description) {
        super(description);
        this.setType(PresetElementType.SUBTITLES);
        //Субтитры необязательно заполнять по дефолту - соотносится с setIsHidden(true) в SubtitlesConfig
        this.setAvailable(false);

        ElementTextOptions options = new ElementTextOptions()
                .setTextColor("#ffffff")
                .setText("")
                .setPlaceholder("subtitles-placeholder")
                .setBackgroundColor("#000000");

        this.setOptions(options);
    }
}
