package ru.yandex.canvas.service.video.presets.elements;

import ru.yandex.canvas.service.video.presets.PresetDescription;

public class TitleElement extends PresetElement<ElementTextOptions> {

    public TitleElement(PresetDescription description) {
        super(description);
        this.setType(PresetElementType.TITLE);
        this.setAvailable(true);

        ElementTextOptions options = new ElementTextOptions()
                .setTextColor("#ffffff")
                .setBackgroundColor(description.getTitleBackgoundColor());

        if (description.isBodyEditable()) {
            options
                    .setText("")
                    .setPlaceholder("title_placeholder"); //TODO lazy_gettext
        }

        this.setOptions(options);
    }

}
