package ru.yandex.canvas.utils;

import java.util.Comparator;

import javax.annotation.Nullable;

import ru.yandex.canvas.model.CreativeData;
import ru.yandex.canvas.model.Size;
import ru.yandex.canvas.model.elements.ElementType;

/**
 * Utils для адаптивных креативов
 */
public class AdaptiveUtils {

    /**
     * Возвращает размер самого большого (в плане площади) изображения в креативе.
     *
     * @param creativeData данные креатива
     * @return размеры {@link Size} самого большого изображения или null
     */
    @Nullable
    public static Size getMaxImageSize(CreativeData creativeData) {
        return creativeData.getMediaSets().values().stream()
                .flatMap(ms -> ms.getItems().stream())
                .filter(item -> ElementType.IMAGE.equalsIgnoreCase(item.getType()))
                .flatMap(item -> item.getItems().stream())
                .max(Comparator.comparing(subItem -> subItem.getWidth() * subItem.getHeight()))
                .map(mediaSetSubItem ->
                        new Size(mediaSetSubItem.getWidth(), mediaSetSubItem.getHeight()))
                .orElse(null);
    }

}
