#!/bin/bash

set -e

export PROFILE
JAVA_ADDITIONAL_OPTIONS=""

if [ "${PROFILE}" = "dev" ]; then
    JAVA_ADDITIONAL_OPTIONS="-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=38147"
fi

# -server - Set up server settings profile. default option for jvm on x64 but who knows how can the things change?
# -XX:+HeapDumpOnOutOfMemoryError - collect dump when OOME occures. You don't wanna try to reproduce it in production to know the things
# -XX:-OmitStackTraceInFastThrow - java eats exeption stacktraces happened on hot code. Turn this function off.
# -XX:+UnlockExperimentalVMOptions - for UseCGroupMemoryLimitForHeap
# -XX:+UseCGroupMemoryLimitForHeap - make java app able to understand num of cores and system memory size in cloud env
# -Djava.security.egd=file:/dev/./urandom - using urandom instead of random. Cuzzz fasta
# -Djava.net.preferIPv6Addresses=true - use ipv6 stack if possible
JAVA_OPTIONS="-server -showversion \
-XX:+HeapDumpOnOutOfMemoryError \
-XX:-OmitStackTraceInFastThrow ${JAVA_ADDITIONAL_OPTIONS} \
-XX:+UnlockExperimentalVMOptions \
-Djava.security.egd=file:/dev/./urandom \
-Djava.net.preferIPv4Stack=false \
-Djava.net.preferIPv6Addresses=true \
-Djava.library.path=yandex-direct-canvas-backend \
-Dspring.profiles.active=${PROFILE}"

echo "{\"message\": \"Starting service backend!\"}"
echo "{\"message\": \"Java options is: ${JAVA_OPTIONS}\"}"

exec ./run.sh ${JAVA_OPTIONS} ru.yandex.canvas.Application

