package ru.yandex.direct.common.admin;

import java.io.File;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.common.admin.engine.Action;
import ru.yandex.direct.common.admin.engine.ActionExecutor;
import ru.yandex.direct.config.DirectConfig;

/**
 * Удаляем файлик отключения alive с фс по запросу
 */
@SuppressWarnings("unused")
@Action("del_alive_force_down")
public class DeleteAliveDownFileExecutor implements ActionExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DeleteAliveDownFileExecutor.class);

    private final String aliveFileName;

    private final File aliveFIle;

    public DeleteAliveDownFileExecutor(DirectConfig directConfig) {
        DirectConfig healthInspectorConfig = directConfig.getBranch("health_checker");
        this.aliveFileName = healthInspectorConfig.getString("alive_file_name");
        this.aliveFIle = new File(aliveFileName);
    }

    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response) {
        if (aliveFIle.delete()) {
            logger.info("Alive force_down file deleted successfuly: " + aliveFileName);
        } else {
            logger.warn("Fail_to delete " + aliveFileName);
        }
    }

}
