package ru.yandex.direct.common.admin;


import java.io.File;
import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.common.admin.engine.Action;
import ru.yandex.direct.common.admin.engine.ActionExecutor;
import ru.yandex.direct.config.DirectConfig;


/**
 * Кладем файлик отключения alive с фс по запросу
 */
@SuppressWarnings("unused")
@Action("put_alive_force_down")
public class PutAliveDownFileExecutor implements ActionExecutor {
    private static final Logger logger = LoggerFactory.getLogger(PutAliveDownFileExecutor.class);

    private final String aliveFileName;
    private final File aliveFile;

    public PutAliveDownFileExecutor(DirectConfig directConfig) {
        DirectConfig healthInspectorConfig = directConfig.getBranch("health_checker");
        this.aliveFileName = healthInspectorConfig.getString("alive_file_name");
        this.aliveFile = new File(aliveFileName);
    }

    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            if (aliveFile.createNewFile()) {
                logger.info("Alive force_down file created: " + aliveFileName);
            } else {
                logger.warn("Force_down {} file already exists.", aliveFileName);
            }
        } catch (IOException e) {
            logger.error("Can't create force_down {} file. {}", aliveFileName, e.getMessage());
        }
    }

}
