package ru.yandex.direct.common.admin;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.common.admin.engine.Action;
import ru.yandex.direct.common.admin.engine.ActionExecutor;
import ru.yandex.direct.db.config.DbConfigFactory;

/**
 * Апдейт конфика базы, перечитывает конфиг из настроек
 */
@SuppressWarnings("unused")
@Action("show_db_config")
public class ShowDbConfigExecutor implements ActionExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ShowDbConfigExecutor.class);

    private final DbConfigFactory dbConfigFactory;

    public ShowDbConfigExecutor(DbConfigFactory dbConfigFactory) {
        this.dbConfigFactory = dbConfigFactory;
    }

    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.getWriter().write(dbConfigFactory.getCurrentConfig());
    }
}
