package ru.yandex.direct.common.admin;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.common.collect.ImmutableMap;

import ru.yandex.direct.common.admin.engine.Action;
import ru.yandex.direct.common.admin.engine.ActionExecutor;
import ru.yandex.direct.version.DirectVersion;

import static ru.yandex.direct.utils.JsonUtils.toJson;

/**
 * Информация о версии приложения
 */
@SuppressWarnings("unused")
@Action("version")
public class VersionExecutor implements ActionExecutor {
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.getWriter().write(toJson(ImmutableMap.of(
                "url", DirectVersion.getVcsVersion().getArcadiaSourceUrl(),
                "revision", DirectVersion.getVcsVersion().getProgramSvnRevision(),
                "version", DirectVersion.getVersion()
        )));
    }
}
