package ru.yandex.direct.common.alive

import java.io.File
import java.util.ArrayList
import org.slf4j.LoggerFactory


class AliveForceDownChecker(fileName: String) : HealthInspector {
    val aliveFile: File = File(fileName)
    override fun inspectHealth(): HealthStatus {
        val issuesList: MutableList<String> = ArrayList()
        if (aliveFile.isFile) {
            logger.info("Stop file {} exist", aliveFile.name)
            issuesList.add("stopfile-exists:" + aliveFile.name)
        }
        return HealthStatus(issuesList)
    }

    companion object {
        private val logger = LoggerFactory.getLogger(AliveForceDownChecker::class.java)
    }

}
