package ru.yandex.direct.common.alive;

import java.io.PrintWriter;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.common.base.Joiner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;
import org.springframework.web.servlet.FrameworkServlet;

import ru.yandex.direct.common.logging.LoggingConfigurationUtils;


/**
 * Проверяет, жизнеспособен ли сервис. Проверка делегируется в HealthInspector.
 */
public class AliveReporterServlet extends FrameworkServlet {
    public static final String ANSWER_OK = "ok";
    private static final Joiner JOINER = Joiner.on(", ");

    @Autowired
    private HealthInspectorBean inspector;

    @Override
    public void init(ServletConfig conf) throws ServletException {
        super.init(conf);
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext(this,
                conf.getServletContext());
    }

    @Override
    protected void doService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        LoggingConfigurationUtils.disableLogging(request);
        HealthStatus status = inspector.inspectHealth();
        try (PrintWriter writer = response.getWriter()) {
            if (status.isHealthy()) {
                writer.append(ANSWER_OK);
            } else {
                response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
                writer.append(JOINER.join(status.getInspectionInfo()));
            }
        }
    }
}
