package ru.yandex.direct.common.alive;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FsWritableStatusInspector implements HealthInspector {
    private static final Logger logger = LoggerFactory.getLogger(FsWritableStatusInspector.class);
    private final Random rnd;

    private Set<File> writableCheckPaths;

    FsWritableStatusInspector(Collection<File> writableCheckPaths) {
        this.writableCheckPaths = new HashSet<>(writableCheckPaths);
        this.rnd = new Random();
    }

    @Override
    public HealthStatus inspectHealth() {
        List<String> issuesList = new ArrayList<>();
        // File.createTempFile использует SecureRandom, который может ходить в /dev/random, что может занять много
        // времени. Этот код вызывается из ручки /alive, к которой обращаются достаточно часто, потому вместо
        // createTempFile используется более легковесный способ создания файла со случайным именем.
        //TODO: перейти с System.currentTimeMillis() на ProcessHandle.current().getPid() (Java 9 API)
        String fileName = "direct-fs-writable-check-" + System.currentTimeMillis() + "_" + rnd.nextLong() + ".tmp";
        for (File writableCheckPath : writableCheckPaths) {
            File tmpFile = new File(writableCheckPath, fileName);
            try {
                if (tmpFile.createNewFile()) {
                    tmpFile.delete();
                }
            } catch (IOException ex) {
                issuesList.add("fs:writable:" + tmpFile.getAbsolutePath());
                logger.error("can't create temporary file {} to check if fs is writable", tmpFile.getAbsolutePath(),
                        ex);
            }
        }
        return new HealthStatus(issuesList);
    }
}
