package ru.yandex.direct.common.alive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HealthStatus {
    private final boolean healthy;
    private final List<String> inspectionInfo;

    public HealthStatus(List<String> inspectionInfo) {
        this(inspectionInfo.isEmpty(), inspectionInfo);
    }

    private HealthStatus(boolean healthy, List<String> inspectionInfo) {
        this.healthy = healthy;
        this.inspectionInfo = new ArrayList<>(inspectionInfo);
    }

    public boolean isHealthy() {
        return healthy;
    }

    public List<String> getInspectionInfo() {
        return Collections.unmodifiableList(inspectionInfo);
    }

    public HealthStatus merge(HealthStatus with) {
        List<String> mergedDescription = new ArrayList<>(with.inspectionInfo.size() + inspectionInfo.size());
        mergedDescription.addAll(inspectionInfo);
        mergedDescription.addAll(with.inspectionInfo);
        return new HealthStatus(healthy && with.healthy, mergedDescription);
    }
}
