package ru.yandex.direct.common.configuration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.config.EssentialConfiguration;
import ru.yandex.direct.graphite.GraphiteAsyncClient;
import ru.yandex.direct.graphite.GraphiteClient;

/**
 * Клиент доступа к graphite
 */
@Configuration
@Import({EssentialConfiguration.class})
public class GraphiteConfiguration {
    public static final String GRAPHITE_CLIENT = "graphiteClient";
    public static final String GRAPHITE_ASYNC_CLIENT = "graphiteAsyncClient";

    private final DirectConfig directConfig;

    public GraphiteConfiguration(DirectConfig directConfig) {
        this.directConfig = directConfig;
    }

    @Bean(GRAPHITE_CLIENT)
    @Lazy
    GraphiteClient graphiteClient() {
        DirectConfig graphiteConfig = directConfig.getBranch("graphite");
        return new GraphiteClient(graphiteConfig.getString("host"), graphiteConfig.getInt("port"),
                graphiteConfig.getDuration("timeout"));
    }

    @Bean(GRAPHITE_ASYNC_CLIENT)
    @Lazy
    GraphiteAsyncClient graphiteAsyncClient(
            @Value("${graphite_metrics.enabled:true}") boolean graphiteMetricsEnabled,
            @Value("${graphite_client.enabled:false}") boolean graphiteClientEnabled
    ) {
        DirectConfig graphiteConfig = directConfig.getBranch("graphite");
        return new GraphiteAsyncClient(
                graphiteConfig.getInt("buffer_size"),
                graphiteClient(),
                graphiteMetricsEnabled && graphiteClientEnabled);
    }
}
