package ru.yandex.direct.common.configuration;

import javax.annotation.Nullable;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

import ru.yandex.direct.common.admin.engine.AdminServlet;
import ru.yandex.direct.common.jetty.JettyConfig;
import ru.yandex.direct.common.jetty.JettyLauncher;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.config.EssentialConfiguration;
import ru.yandex.direct.solomon.SolomonMonitoringServlet;

@Configuration
@Import({EssentialConfiguration.class})
public class MonitoringHttpServerConfiguration {
    public static final String MONITORING_HTTP_SERVER_BEAN_NAME = "monitoringHttpServer";

    @Nullable
    @Bean(MONITORING_HTTP_SERVER_BEAN_NAME)
    @Lazy(false)
    JettyLauncher monitoringHttpServer(DirectConfig conf) {
        if (conf.findBoolean("monitoring_jetty.enable").orElse(false)) {
            JettyConfig jettyConfig = new JettyConfig(conf.getBranch("monitoring_jetty"));
            var solomonMonitoringServlet = new SolomonMonitoringServlet();
            JettyLauncher jettyLauncher = JettyLauncher.server(jettyConfig)
                    .withServlet(solomonMonitoringServlet, "/monitoring")
                    .withServlet(adminServlet(), "/admin");
            if (conf.findBoolean("monitoring_jetty.enable_trace_log_functions_metrics").orElse(false)) {
                jettyLauncher.withServlet(solomonMonitoringServlet, "/trace-log-functions-metrics");
            }
            if (conf.findBoolean("monitoring_jetty.enable_frontend_timings_metrics").orElse(false)) {
                jettyLauncher.withServlet(solomonMonitoringServlet, "/frontend-timings-metrics");
            }
            if (conf.findBoolean("monitoring_jetty.enable_external_metrics").orElse(false)) {
                jettyLauncher.withServlet(solomonMonitoringServlet, "/external-metrics");
            }
            if (conf.findBoolean("monitoring_jetty.enable_common_metrics").orElse(false)) {
                jettyLauncher.withServlet(solomonMonitoringServlet, "/common-metrics");
            }
            if (conf.findBoolean("monitoring_jetty.enable_unified_agent_client_metrics").orElse(false)) {
                jettyLauncher.withServlet(solomonMonitoringServlet, "/unified-agent-client-metrics");
            }
            return jettyLauncher;
        } else {
            return null;
        }
    }

    @Bean
    AdminServlet adminServlet() {
        return new AdminServlet();
    }
}
