package ru.yandex.direct.common.configuration;

import java.util.Date;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

import ru.yandex.direct.traceinterception.configuration.TraceInterceptionConfiguration;
import ru.yandex.direct.traceinterception.entity.traceinterception.service.TraceInterceptionsService;
import ru.yandex.direct.tracing.TraceHelper;
import ru.yandex.direct.tracing.TraceLogger;

@Configuration
@Import({TraceInterceptionConfiguration.class})
public class TracingConfiguration {
    @Bean
    TaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setThreadNamePrefix("TracingBackgroundT-");
        scheduler.setDaemon(true);
        scheduler.setRemoveOnCancelPolicy(true);
        return scheduler;
    }

    @Bean
    TraceLogger traceLogger() {
        final TaskScheduler scheduler = taskScheduler();
        return new TraceLogger((command, period, unit) -> scheduler.scheduleWithFixedDelay(
                command,
                new Date(System.currentTimeMillis() + unit.toMillis(period)),
                unit.toMillis(period)
        ));
    }

    @Bean
    public TraceHelper traceHelper(@Value("${tracing.service_name}") String tracingServiceName,
                                   TraceLogger traceLogger,
                                   TraceInterceptionsService traceInterceptor) {
        return new TraceHelper(tracingServiceName, traceLogger, traceInterceptor);
    }
}
