package ru.yandex.direct.common.configuration;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.TaskScheduler;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.config.EssentialConfiguration;
import ru.yandex.direct.tvm.TvmIntegration;
import ru.yandex.direct.tvm.TvmIntegrationImpl;
import ru.yandex.direct.tvm.TvmIntegrationStub;

import static ru.yandex.direct.config.EssentialConfiguration.CONFIG_SCHEDULER_BEAN_NAME;

@Configuration
@Import({
        EssentialConfiguration.class,
})
public class TvmIntegrationConfiguration {
    public static final String TVM_INTEGRATION = "tvmIntegration";

    @Bean(name = TVM_INTEGRATION)
    public TvmIntegration tvmIntegration(
            DirectConfig directConfig,
            @Qualifier(CONFIG_SCHEDULER_BEAN_NAME) TaskScheduler liveConfigChangeTaskScheduler
    ) {
        boolean enabled = directConfig.findBoolean("tvm.enabled").orElse(false);
        if (enabled) {
            return TvmIntegrationImpl.create(directConfig, liveConfigChangeTaskScheduler);
        } else {
            return new TvmIntegrationStub();
        }
    }

}
