package ru.yandex.direct.common.db;

import java.time.LocalDateTime;

public final class PpcPropertyData<T> {
    private final T value;
    private final LocalDateTime lastChange;

    public PpcPropertyData(T value, LocalDateTime lastChange) {
        this.value = value;
        this.lastChange = lastChange;
    }

    /**
     * @return значение
     */
    public T getValue() {
        return value;
    }

    /**
     * @return время последнего изменения
     */
    public LocalDateTime getLastChange() {
        return lastChange;
    }
}
