package ru.yandex.direct.common.db;

import ru.yandex.direct.dbschema.ppcdict.Tables;

import static ru.yandex.direct.common.db.PpcPropertiesSupport.NAME_MAX_LENGTH;

/**
 * Класс-параметр, типизированный типом данных, значение которого содержится в столбце value
 * по ключу {@code name} в таблице {@link Tables#PPC_PROPERTIES}
 * <p>
 * Список определённых проперти в {@link ru.yandex.direct.common.db.PpcPropertyNames}
 */
public class PpcPropertyName<T> {
    private String name;
    private PpcPropertyType<T> type;

    public PpcPropertyName(String name, PpcPropertyType<T> type) {
        checkName(name);

        this.name = name;
        this.type = type;
    }

    private void checkName(String name) {
        if (name.length() > NAME_MAX_LENGTH) {
            throw new IllegalArgumentException("Property name '" + name + "'is too long");
        }
    }

    /**
     * @return значение ключа
     */
    public String getName() {
        return name;
    }

    /**
     * @return тип занчения по ключу {@code name}
     */
    public PpcPropertyType<T> getType() {
        return type;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }

        PpcPropertyName other = (PpcPropertyName) obj;

        return this.name.equals(other.name);
    }

    @Override
    public int hashCode() {
        return name.hashCode();
    }

    @Override
    public String toString() {
        return name;
    }
}
