//CHECKSTYLE:OFF
package ru.yandex.direct.common.db;
//CHECKSTYLE:ON

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;

import ru.yandex.direct.dbschema.ppcdict.Tables;

import static ru.yandex.direct.common.db.PpcPropertiesSupport.NAME_MAX_LENGTH;
import static ru.yandex.direct.common.db.PpcPropertyType.BOOLEAN;
import static ru.yandex.direct.common.db.PpcPropertyType.DOUBLE;
import static ru.yandex.direct.common.db.PpcPropertyType.INTEGER;
import static ru.yandex.direct.common.db.PpcPropertyType.INTEGER_TO_STRING_TO_DOUBLE_MAP;
import static ru.yandex.direct.common.db.PpcPropertyType.INT_LIST;
import static ru.yandex.direct.common.db.PpcPropertyType.LOCAL_DATE;
import static ru.yandex.direct.common.db.PpcPropertyType.LOCAL_DATE_TIME;
import static ru.yandex.direct.common.db.PpcPropertyType.LONG;
import static ru.yandex.direct.common.db.PpcPropertyType.LONG_LIST;
import static ru.yandex.direct.common.db.PpcPropertyType.LONG_SET;
import static ru.yandex.direct.common.db.PpcPropertyType.LONG_TO_LONG_MAP;
import static ru.yandex.direct.common.db.PpcPropertyType.SHARDS_SET;
import static ru.yandex.direct.common.db.PpcPropertyType.STRING;
import static ru.yandex.direct.common.db.PpcPropertyType.STRING_LIST;
import static ru.yandex.direct.common.db.PpcPropertyType.STRING_SET;
import static ru.yandex.direct.common.db.PpcPropertyType.STRING_TO_DOUBLE_MAP;
import static ru.yandex.direct.common.db.PpcPropertyType.STRING_TO_STRING_MAP;
import static ru.yandex.direct.common.db.PpcPropertyType.STRING_TO_STRING_MAP_JSON;

/**
 * Содержит константы-параметры PpcPropertyName
 */
public class PpcPropertyNames {
    public static final String FULL_LB_EXPORT_LAST_PROCESSED_CAMPAIGN_ID_PREFIX = "FULL_LB_EXPORT_LAST_PROCESSED_CID";
    public static final Set<Long> GBP_CLIENT_UID_ALLOWED_VALUE = Set.of(-1L);
    public static final Set<Long> DAAS_ALL_UID_ALLOWED_VALUE = Set.of(-1L);


    /**
     * Пропертя со статусом  выгрузки  данных по пейджам МОАТ
     */
    public static final PpcPropertyName<Map<String, String>> MOAT_PAGES_UPLOAD_STATUS =
            new PpcPropertyName<>("MOAT_PAGES_UPLOAD_STATUS", STRING_TO_STRING_MAP);


    /**
     * Пропертя со списком пакетов доступных соц клиентам
     */
    public static final PpcPropertyName<List<Long>> SOCIAL_ADVERTISING_PACKAGES =
            new PpcPropertyName<>("SOCIAL_ADVERTISING_PACKAGES", LONG_LIST);

    /**
     * Флаг для включения отправки групп через новый транспорт
     */
    public static final PpcPropertyName<Integer> ENABLE_ADGROUP_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("ENABLE_ADGROUP_TRANSPORT_NEW_MODERATION_JAVA", INTEGER);

    public static final PpcPropertyName<Integer> DISABLE_ADGROUP_TRANSPORT_OLD_MODERATION =
            new PpcPropertyName<>("DISABLE_ADGROUP_TRANSPORT_OLD_MODERATION_PERL", INTEGER);

    public static final PpcPropertyName<Boolean> RESTRICTED_ADGROUP_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("RESTRICTED_ADGROUP_TRANSPORT_NEW_MODERATION", BOOLEAN);

    /**
     * Флаги для включения отправки кампаний через новый транспорт
     */
    public static final PpcPropertyName<Integer> ENABLE_CAMPAIGN_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("ENABLE_CAMPAIGN_TRANSPORT_NEW_MODERATION_JAVA", INTEGER);

    public static final PpcPropertyName<Integer> DISABLE_CAMPAIGN_TRANSPORT_OLD_MODERATION =
            new PpcPropertyName<>("DISABLE_CAMPAIGN_TRANSPORT_OLD_MODERATION_PERL", INTEGER);

    public static final PpcPropertyName<Boolean> RESTRICTED_CAMPAIGN_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("RESTRICTED_CAMPAIGN_TRANSPORT_NEW_MODERATION", BOOLEAN);

    public static final PpcPropertyName<Integer> CAMPAIGN_TRANSPORT_NEW_MODERATION_MODIFY_STATUS =
            new PpcPropertyName<>("CAMPAIGN_TRANSPORT_NEW_MODERATION_MODIFY_STATUS", INTEGER);

    /**
     * Флаг для включения отправки callout через новый транспорт
     */
    public static final PpcPropertyName<Integer> ENABLE_CALLOUT_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("ENABLE_CALLOUT_TRANSPORT_NEW_MODERATION_JAVA", INTEGER);

    public static final PpcPropertyName<Integer> DISABLE_CALLOUT_TRANSPORT_OLD_MODERATION =
            new PpcPropertyName<>("DISABLE_CALLOUT_TRANSPORT_OLD_MODERATION_PERL", INTEGER);

    public static final PpcPropertyName<Boolean> RESTRICTED_CALLOUT_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("RESTRICTED_CALLOUT_TRANSPORT_NEW_MODERATION", BOOLEAN);

    /**
     * Флаг для включения отправки canvas баннера через новый транспорт
     */
    public static final PpcPropertyName<Integer> ENABLE_CANVAS_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("ENABLE_CANVAS_TRANSPORT_NEW_MODERATION_JAVA", INTEGER);

    public static final PpcPropertyName<Integer> DISABLE_CANVAS_TRANSPORT_OLD_MODERATION =
            new PpcPropertyName<>("DISABLE_CANVAS_TRANSPORT_OLD_MODERATION_PERL", INTEGER);

    public static final PpcPropertyName<Boolean> RESTRICTED_CANVAS_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("RESTRICTED_CANVAS_TRANSPORT_NEW_MODERATION", BOOLEAN);

    /**
     * Флаг для включения отправки cpc_video баннера через новый транспорт
     */
    public static final PpcPropertyName<Integer> ENABLE_CPC_VIDEO_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("ENABLE_CPC_VIDEO_TRANSPORT_NEW_MODERATION_JAVA", INTEGER);

    public static final PpcPropertyName<Integer> DISABLE_CPC_VIDEO_TRANSPORT_OLD_MODERATION =
            new PpcPropertyName<>("DISABLE_CPC_VIDEO_TRANSPORT_OLD_MODERATION_PERL", INTEGER);

    public static final PpcPropertyName<Boolean> RESTRICTED_CPC_VIDEO_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("RESTRICTED_CPC_VIDEO_TRANSPORT_NEW_MODERATION", BOOLEAN);

    /**
     * Флаг для включения отправки dynamic баннера через новый транспорт
     */
    public static final PpcPropertyName<Integer> ENABLE_DYNAMIC_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("ENABLE_DYNAMIC_TRANSPORT_NEW_MODERATION_JAVA", INTEGER);

    public static final PpcPropertyName<Integer> DISABLE_DYNAMIC_TRANSPORT_OLD_MODERATION =
            new PpcPropertyName<>("DISABLE_DYNAMIC_TRANSPORT_OLD_MODERATION_PERL", INTEGER);

    public static final PpcPropertyName<Boolean> RESTRICTED_DYNAMIC_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("RESTRICTED_DYNAMIC_TRANSPORT_NEW_MODERATION", BOOLEAN);

    /**
     * Флаг для включения отправки mobile_content баннера через новый транспорт
     */
    public static final PpcPropertyName<Integer> ENABLE_MOBILE_CONTENT_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("ENABLE_MOBILE_CONTENT_TRANSPORT_NEW_MODERATION_JAVA", INTEGER);

    public static final PpcPropertyName<Integer> DISABLE_MOBILE_CONTENT_TRANSPORT_OLD_MODERATION =
            new PpcPropertyName<>("DISABLE_MOBILE_CONTENT_TRANSPORT_OLD_MODERATION_PERL", INTEGER);

    public static final PpcPropertyName<Boolean> RESTRICTED_MOBILE_CONTENT_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("RESTRICTED_MOBILE_CONTENT_TRANSPORT_NEW_MODERATION", BOOLEAN);

    /**
     * Флаг для включения отправки новых полей расширенного геотаргетинга
     */
    public static final PpcPropertyName<Boolean> BS_TRANSPORT_SEND_ADVANCED_GEOTARGETING_DATA =
            new PpcPropertyName<>("BS_TRANSPORT_SEND_ADVANCED_GEOTARGETING_DATA", BOOLEAN);


    /**
     * Флаг для включения отправки text баннера через новый транспорт
     */
    public static final PpcPropertyName<Integer> ENABLE_TEXT_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("ENABLE_TEXT_TRANSPORT_NEW_MODERATION_JAVA", INTEGER);

    public static final PpcPropertyName<Integer> DISABLE_TEXT_TRANSPORT_OLD_MODERATION =
            new PpcPropertyName<>("DISABLE_TEXT_TRANSPORT_OLD_MODERATION_PERL", INTEGER);

    public static final PpcPropertyName<Boolean> RESTRICTED_TEXT_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("RESTRICTED_TEXT_TRANSPORT_NEW_MODERATION", BOOLEAN);

    /**
     * Флаг для включения отправки vcard через новый транспорт
     */

    public static final PpcPropertyName<Integer> ENABLE_VCARD_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("ENABLE_VCARD_TRANSPORT_NEW_MODERATION_JAVA", INTEGER);

    public static final PpcPropertyName<Integer> DISABLE_VCARD_TRANSPORT_OLD_MODERATION =
            new PpcPropertyName<>("DISABLE_VCARD_TRANSPORT_OLD_MODERATION_PERL", INTEGER);

    public static final PpcPropertyName<Boolean> RESTRICTED_VCARD_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("RESTRICTED_VCARD_TRANSPORT_NEW_MODERATION", BOOLEAN);

    /**
     * Флаг для включения отправки иконки mobile_content через новый транспорт
     */

    public static final PpcPropertyName<Integer> ENABLE_MOBILE_CONTENT_ICON_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("ENABLE_MOBILE_CONTENT_ICON_TRANSPORT_NEW_MODERATION_JAVA", INTEGER);

    public static final PpcPropertyName<Integer> DISABLE_MOBILE_CONTENT_ICON_TRANSPORT_OLD_MODERATION =
            new PpcPropertyName<>("DISABLE_MOBILE_CONTENT_ICON_TRANSPORT_OLD_MODERATION_PERL", INTEGER);

    public static final PpcPropertyName<Boolean> RESTRICTED_MOBILE_CONTENT_ICON_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("RESTRICTED_MOBILE_CONTENT_ICON_TRANSPORT_NEW_MODERATION", BOOLEAN);

    /**
     * Флаг для включения отправки video_addition через новый транспорт
     */
    public static final PpcPropertyName<Integer> ENABLE_VIDEO_ADDITION_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("ENABLE_VIDEO_ADDITION_TRANSPORT_NEW_MODERATION_JAVA", INTEGER);

    public static final PpcPropertyName<Integer> DISABLE_VIDEO_ADDITION_TRANSPORT_OLD_MODERATION =
            new PpcPropertyName<>("DISABLE_VIDEO_ADDITION_TRANSPORT_OLD_MODERATION_PERL", INTEGER);

    public static final PpcPropertyName<Boolean> RESTRICTED_VIDEO_ADDITION_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("RESTRICTED_VIDEO_ADDITION_TRANSPORT_NEW_MODERATION", BOOLEAN);

    /**
     * Флаг для включения отправки html5 баннера через новый транспорт
     */
    public static final PpcPropertyName<Integer> ENABLE_HTML5_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("ENABLE_HTML5_TRANSPORT_NEW_MODERATION_JAVA", INTEGER);

    public static final PpcPropertyName<Integer> DISABLE_HTML5_TRANSPORT_OLD_MODERATION =
            new PpcPropertyName<>("DISABLE_HTML5_TRANSPORT_OLD_MODERATION_PERL", INTEGER);

    public static final PpcPropertyName<Boolean> RESTRICTED_HTML5_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("RESTRICTED_HTML5_TRANSPORT_NEW_MODERATION", BOOLEAN);

    /**
     * Флаг для включения отправки ГО баннера через новый транспорт
     */
    public static final PpcPropertyName<Integer> ENABLE_AD_IMAGE_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("ENABLE_AD_IMAGE_TRANSPORT_NEW_MODERATION_JAVA", INTEGER);

    public static final PpcPropertyName<Integer> DISABLE_AD_IMAGE_TRANSPORT_OLD_MODERATION =
            new PpcPropertyName<>("DISABLE_AD_IMAGE_TRANSPORT_OLD_MODERATION_PERL", INTEGER);

    /**
     * Флаг для включения/выключения скрипта moderateExportMaster.pl в старом транспорте
     */
    public static final PpcPropertyName<Boolean> ENABLE_MODERATE_EXPORT_MASTER =
            new PpcPropertyName<>("ENABLE_MODERATE_EXPORT_MASTER", BOOLEAN);

    /**
     * Процент клиентов, для которых statusModerate на кампании НЕ апдейтится старым кодом в перле
     * т.е. при значении 0 statusModerate считается и обновляется целиком по-старому, в перле
     * а при значении 100 statusModerate в перле не обновляется
     * Парное проперти к {@link #AGGREGATED_CAMP_STATUS_MODERATE_JAVA}
     */
    public static final PpcPropertyName<Integer>
            AGGREGATED_CAMP_STATUS_MODERATE = new PpcPropertyName<>("AGGREGATED_CAMP_STATUS_MODERATE", INTEGER);

    /**
     * Процент клиентов, для которых statusModerate на кампании расчитывается через новый код в ess в java
     * При этом чтобы выключить расчёт в перле, нужно соответствующим образом установить парное
     * проперти {@link #AGGREGATED_CAMP_STATUS_MODERATE}
     */
    public static final PpcPropertyName<Integer> AGGREGATED_CAMP_STATUS_MODERATE_JAVA =
            new PpcPropertyName<>("AGGREGATED_CAMP_STATUS_MODERATE_JAVA", INTEGER);

    /**
     * Процент клиентов, для которых при вычислении statusModerate на кампании не учитывается
     * результат, посчитанный перловой ручкой (при расхождении результатов с новым кодом).
     * Т.е. при значении 0 всегда в приоритете будут значения, посчитанные перловой ручкой
     * А при значении 100 в приоритете будут значения, посчитанные джавой
     */
    public static final PpcPropertyName<Integer> AGGREGATED_CAMP_STATUS_MODERATE_JAVA_PREFER_NEW_CALCULATOR =
            new PpcPropertyName<>("AGGREGATED_CAMP_STATUS_MODERATE_JAVA_PREFER_NEW_CALCULATOR", INTEGER);

    /**
     * Флаг для включения отправки сайтлинков через новый транспорт
     */
    public static final PpcPropertyName<Integer> ENABLE_SITELINKS_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("ENABLE_SITELINKS_TRANSPORT_NEW_MODERATION_JAVA", INTEGER);

    public static final PpcPropertyName<Integer> DISABLE_SITELINKS_TRANSPORT_OLD_MODERATION =
            new PpcPropertyName<>("DISABLE_SITELINKS_TRANSPORT_OLD_MODERATION_PERL", INTEGER);

    /**
     * Флаг для включения отправки картинок новым транспортом
     */
    public static final PpcPropertyName<Integer> ENABLE_IMAGE_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("ENABLE_IMAGE_TRANSPORT_NEW_MODERATION_JAVA", INTEGER);

    public static final PpcPropertyName<Integer> DISABLE_IMAGE_TRANSPORT_OLD_MODERATION =
            new PpcPropertyName<>("DISABLE_IMAGE_TRANSPORT_OLD_MODERATION_PERL", INTEGER);

    /**
     * Флаг для включения отправки видимых урлов через новый транспорт
     */
    public static final PpcPropertyName<Integer> ENABLE_DISPLAYHREFS_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("ENABLE_DISPLAYHREFS_TRANSPORT_NEW_MODERATION_JAVA", INTEGER);

    public static final PpcPropertyName<Integer> DISABLE_DISPLAYHREFS_TRANSPORT_OLD_MODERATION =
            new PpcPropertyName<>("DISABLE_DISPLAYHREFS_TRANSPORT_OLD_MODERATION_PERL", INTEGER);

    /**
     * Флаг для включения отправки флагов баннеров через новый транспорт
     */
    public static final PpcPropertyName<Boolean> ENABLE_FLAGS_TRANSPORT_NEW_MODERATION =
            new PpcPropertyName<>("ENABLE_FLAGS_TRANSPORT_NEW_MODERATION", BOOLEAN);

    /**
     * Флаг для включения отправки событий об архивации баннеров через новый транспорт
     */
    public static final PpcPropertyName<Boolean> ENABLE_BANNER_ARCHIVING_TRANSPORT =
            new PpcPropertyName<>("ENABLE_BANNER_ARCHIVING_TRANSPORT", BOOLEAN);

    /**
     * Флаг для включения отправки событий об архивации баннеров, полученных из событий об архивации кампаний,
     * через новый транспорт
     */
    public static final PpcPropertyName<Boolean> ENABLE_BANNER_ARCHIVING_BY_CAMPAIGN_TRANSPORT =
            new PpcPropertyName<>("ENABLE_BANNER_ARCHIVING_BY_CAMPAIGN_TRANSPORT", BOOLEAN);

    /**
     * Флаг для включения остановки компаний конкурирующих с cpd компаниями.
     */
    public static final PpcPropertyName<Boolean> CPD_JOB_ENABLED =
            new PpcPropertyName<>("CPD_JOB_ENABLED", BOOLEAN);

    /**
     * Флаг для включения сохранения минус-регионов как флагов баннеров
     */
    public static final PpcPropertyName<Boolean> SAVE_MINUS_REGIONS_AS_BANNER_FLAGS =
            new PpcPropertyName<>("SAVE_MINUS_REGIONS_AS_BANNER_FLAGS", BOOLEAN);

    /**
     * Список идентификаров кампаний, для баннеров которых разрешено сохранение минус-регионов как флагов.
     * Нужно, чтоб проверить транспорт таких флагов в БК не включая функциональность на всех.
     */
    public static final PpcPropertyName<Set<Long>> SAVE_MINUS_REGIONS_AS_BANNER_FLAGS_ENABLED_CAMPAIGN_IDS =
            new PpcPropertyName<>("SAVE_MINUS_REGIONS_AS_BANNER_FLAGS_ENABLED_CAMPAIGN_IDS", LONG_SET);

    /**
     * Флаг для отключения валюты YND_FIXED из сервиса Dictionaries DIRECT-88415
     */
    public static final PpcPropertyName<Boolean>
            DISABLE_YND_FIXED_IN_DICTIONARIES = new PpcPropertyName<>("DISABLE_YND_FIXED_IN_DICTIONARIES", BOOLEAN);

    /**
     * Флаг для включения отправки турбоссылок в модерацию через новый транспорт в Java
     */
    public static final PpcPropertyName<Boolean>
            TURBOLANDINGS_NEW_TRANSPORT_ENABLED_JAVA = new PpcPropertyName<>(
            "turbolandings_new_transport_enabled_java", BOOLEAN);

    /**
     * Флаг для включения отправки турбоссылок в модерацию через новый транспорт в Java
     */
    public static final PpcPropertyName<Boolean>
            TURBOLANDINGS_NEW_TRANSPORT_ENABLED_PERL = new PpcPropertyName<>(
            "turbolandings_new_transport_disabled_perl", BOOLEAN);

    /**
     * Флаг для использования новых значений поля Rate для валют в сервисе Dictionaries DIRECT-89177
     */
    public static final PpcPropertyName<Boolean>
            USE_NEW_VALUES_FOR_RATE = new PpcPropertyName<>("USE_NEW_VALUES_FOR_RATE", BOOLEAN);

    /**
     * Флаг для запрета использования старыми версиями Android приложения сервиса Dictionaries DIRECT-89177
     */
    public static final PpcPropertyName<Boolean> CLIENTS_MUST_USE_NEW_VERSION_OF_ANDROID_APP =
            new PpcPropertyName<>("CLIENTS_MUST_USE_NEW_VERSION_OF_ANDROID_APP", BOOLEAN);

    public static final PpcPropertyName<Boolean>
            ADFOX_OUTPUT_ENABLED = new PpcPropertyName<>("adfox.output.enabled", BOOLEAN);

    public static final PpcPropertyName<Set<Long>>
            PREVIEW_ACCESS_TO_NEW_FEATURE_CLIENTS_IDS_MEMBERS_4_PPC_PROPERTY_NAME =
            new PpcPropertyName<>("PREVIEW_ACCESS_TO_NEW_FEATURE_CLIENTS_IDS_MEMBERS_4", LONG_SET);

    public static final PpcPropertyName<Boolean>
            ADVQ_SKIP_CAMP_MINUS_WORDS = new PpcPropertyName<>("ADVQ_SKIP_CAMP_MINUS_WORDS", BOOLEAN);

    // управление user-action-log writer-ом
    public static final PpcPropertyName<Integer> ALW_EVENT_BATCH_SIZE
            = new PpcPropertyName<>("ALW_EVENT_BATCH_SIZE", INTEGER);

    // на самом деле внутри лежит json массив чисел в формате [1, 3, 4]
    public static final PpcPropertyName<String>
            RECOMMENDATIONS_TRACER_ENABLED_TYPES =
            new PpcPropertyName<>("RECOMMENDATIONS_TRACER_ENABLED_TYPES", STRING);

    /**
     * кол-во дней на которые считается кеш
     */
    public static final PpcPropertyName<Integer>
            TURBO_WEB_SITE_RECOMMENDATIONS_DAYS_CACHE =
            new PpcPropertyName<>("TURBO_WEB_SITE_RECOMMENDATIONS_DAYS_CACHE", INTEGER);

    /**
     * отставание от текущей даты
     */
    public static final PpcPropertyName<Integer>
            TURBO_WEB_SITE_RECOMMENDATIONS_DAYS_DELAY =
            new PpcPropertyName<>("TURBO_WEB_SITE_RECOMMENDATIONS_DAYS_DELAY", INTEGER);

    /**
     * кол-во дней кеша для удаления (если вдруг будут менять TURBO_WEB_SITE_RECOMMENDATIONS_DAYS_CACHE)
     */
    public static final PpcPropertyName<Integer>
            TURBO_WEB_SITE_RECOMMENDATIONS_DAYS_CLEAR =
            new PpcPropertyName<>("TURBO_WEB_SITE_RECOMMENDATIONS_DAYS_CLEAR", INTEGER);

    public static final PpcPropertyName<Set<Integer>> BS_CLIENT_DATA_SKIP_BSSOAP_REQUEST = new PpcPropertyName<>(
            "BS_CLIENT_DATA_SKIP_BSSOAP_REQUEST", SHARDS_SET);
    public static final PpcPropertyName<Set<Integer>> BS_CLIENT_DATA_SKIP_BSSOAP_INTERNAL_ADS_REQUEST =
            new PpcPropertyName<>("BS_CLIENT_DATA_SKIP_BSSOAP_INTERNAL_ADS_REQUEST", SHARDS_SET);

    public static final PpcPropertyName<Boolean> BSEXPORT_WORKERS_NUM_CONTROLLED_MANUALLY =
            new PpcPropertyName<>("bsexport_workers_num_controlled_manually", BOOLEAN);

    /**
     * Рразрешена ли циклическая (начинать с начала по завершению) работа мастер-процесса реэкспорта
     */
    public static final PpcPropertyName<Boolean> FULL_LB_EXPORT_ALLOW_ROLLING_WORK =
            new PpcPropertyName<>("ALLOW_FULL_LB_EXPORT_ROLLING_WORK", PpcPropertyType.BOOLEAN);

    /**
     * Наибольшее возможное количество кампаний в очереди экспорта (таблице bs_export_queue) в БК
     * с взведенным флагом is_full_export.
     * Другими словами - ограничение на размер очереди ре-экспорта.
     */
    public static final PpcPropertyName<Integer> FULL_LB_EXPORT_MAX_CAMPAIGNS_IN_QUEUE =
            new PpcPropertyName<>("MAX_FULL_LB_EXPORT_CAMPAIGNS_IN_QUEUE", PpcPropertyType.INTEGER);

    /**
     * Ограничение на количество кампаний, добавляемых мастер-процессом в очередь ре-экспорта за один раз.
     */
    public static final PpcPropertyName<Integer> FULL_LB_EXPORT_MAX_CHUNK_PER_ITERATION =
            new PpcPropertyName<>("FULL_LB_EXPORT_MAX_CHUNK_PER_ITERATION", PpcPropertyType.INTEGER);

    /**
     * Количество кампаний в расчете на один воркер ре-экспорта, поддерживаемое в очереди ре-экспорта
     */
    public static final PpcPropertyName<Integer> FULL_LB_EXPORT_MAX_CHUNK_PER_WORKER =
            new PpcPropertyName<>("FULL_LB_EXPORT_CHUNK_PER_WORKER", PpcPropertyType.INTEGER);

    /**
     * Ограничение в транспорте БК максимальной ставки на уровне заданного дневного бюджета
     */
    public static final PpcPropertyName<Boolean> BS_BIDS_LIMITED_BY_DAY_BUDGET =
            new PpcPropertyName<>("bs_bids_limited_by_day_budget", BOOLEAN);

    /**
     * Делать ли пиксель MediaScope(TNS) разрешаемым по умолчанию или разрешаемым через админку
     * 1,                                           - разрешаемый через админку
     * 0, отсутствующее или любое другое значение   - разрешаемый автоматически
     */

    public static final PpcPropertyName<Boolean> ADFOX_INPUT_PROCESSING_ENABLED =
            new PpcPropertyName<>("adfox.input.enabled", BOOLEAN);

    public static final PpcPropertyName<Boolean> ENABLE_UPDATE_FREELANCER_RATINGS =
            new PpcPropertyName<>("enable_update_freelancer_ratings", BOOLEAN);

    public static final PpcPropertyName<Boolean> ENABLE_CLEAR_OLD_LIMITED_SUPPORTS_JOB =
            new PpcPropertyName<>("enable_clear_old_limited_supports_job", BOOLEAN);

    @Deprecated
    public static final PpcPropertyName<Integer> AUCTION_PROBABILITY_DAILY_BUDGET_NOTIFICATION_PERIOD_DAYS =
            new PpcPropertyName<>("AUCTIONPROBABILITY_DAILY_BUDGET_NOTIFICATION_PERIOD_DAYS", INTEGER);

    public static final PpcPropertyName<Integer> MIN_FREELANCER_FEEDBACKS_COUNT =
            new PpcPropertyName<>("min_freelancer_feedbacks_count", INTEGER);

    public static final PpcPropertyName<Boolean> ENABLE_SYNC_CAMP_DIALOGS_STATUS =
            new PpcPropertyName<>("enable_sync_camp_dialogs_status", BOOLEAN);

    public static final PpcPropertyName<Integer> OFFLINE_REPORT_JOB_MAX_ATTEMPTS =
            new PpcPropertyName<>("offline_report_job_max_attempts", INTEGER);

    public static final PpcPropertyName<Integer> OFFLINE_REPORT_JOB_GRAB_DURATION_MINUTES =
            new PpcPropertyName<>("offline_report_job_grab_duration_minutes", INTEGER);

    /**
     * Показывать новый телефон на морде direct.yandex.tld
     */
    public static final PpcPropertyName<Integer> ANOTHER_PHONE_FOR_MAIN_PAGE =
            new PpcPropertyName<>("another_phone_for_main_page", PpcPropertyType.INTEGER);

    /**
     * Месяц начала сбора статистики, с которого возможно формировать отчёты. В формате 201903.
     */
    public static final PpcPropertyName<String> OFFLINE_REPORT_MIN_MONTH_FROM =
            new PpcPropertyName<>("offline_report_min_month_from", STRING);

    /**
     * Максимальный возможный период для отчёта в месяцах. Разница между с и по.
     */
    public static final PpcPropertyName<Integer> OFFLINE_REPORT_MAX_REPORT_PERIOD_MONTH =
            new PpcPropertyName<>("offline_report_max_report_period_month", INTEGER);

    /**
     * Дата начала сбора статистики, с которой возможно формировать отчёты по агентским комиссиям.
     */
    public static final PpcPropertyName<LocalDate> AGENCY_KPI_OFFLINE_REPORT_MIN_DATE =
            new PpcPropertyName<>("agency_kpi_offline_report_min_date", LOCAL_DATE);

    /**
     * Максимально допустимая дата для формирования отчёта по агентским комиссиям.
     */
    public static final PpcPropertyName<LocalDate> AGENCY_KPI_OFFLINE_REPORT_MAX_DATE =
            new PpcPropertyName<>("agency_kpi_offline_report_max_date", LOCAL_DATE);

    /**
     * Id агентств с Premium условиями по агентским комиссиям.
     */
    public static final PpcPropertyName<Set<Long>> AGENCY_KPI_OFFLINE_REPORT_PREMIUM_AGENCY_IDS =
            new PpcPropertyName<>("agency_kpi_offline_report_premium_agency_ids", LONG_SET);

    /**
     * Id агентств с Aggregator условиями по агентским комиссиям.
     */
    public static final PpcPropertyName<Set<Long>> AGENCY_KPI_OFFLINE_REPORT_AGGREGATOR_AGENCY_IDS =
            new PpcPropertyName<>("agency_kpi_offline_report_aggregator_agency_ids", LONG_SET);

    public static final PpcPropertyName<Boolean> MOBILE_APPS_SYNC_JOB_ENABLED =
            new PpcPropertyName<>("mobile_apps_sync_job_enabled", BOOLEAN);

    public static final PpcPropertyName<Integer> BS_CAMPS_ONLY_CAMPS_LIMIT =
            new PpcPropertyName<>("BS_CAMPS_ONLY_CAMPS_LIMIT", INTEGER);

    public static final PpcPropertyName<Integer> BS_INVENTORY_TYPE_COEF_INBANNER_ENABLED =
            new PpcPropertyName<>("BS_INVENTORY_TYPE_COEF_INBANNER_ENABLED", INTEGER);

    /**
     * Включена ли джоба {@code RequestUpdateOffersPreviewJob}, запрашивающая у самовара обновление превью офферов
     * для еком-доменов
     */
    public static final PpcPropertyName<Boolean> UPDATE_OFFERS_PREVIEW_JOB_ENABLED =
            new PpcPropertyName<>("update_offers_preview_job_enabled", BOOLEAN);

    /**
     * Коэффициент сна для отправки офферных урлов на перепрокачку. Используется через
     * {@link ru.yandex.direct.common.util.RelaxedWorker}
     * совместно с {@link #UPDATE_OFFERS_PREVIEW_SENDING_CHUNK_SIZE} таким образом,
     * что время сна будет равно времени отправки чанка помноженному на данный коэффициент.
     * <p>
     * У обхода топика со стороны самовара квота 100rps, стремимся укладываться в тот же рейт.
     */
    public static final PpcPropertyName<Double> UPDATE_OFFERS_PREVIEW_SLEEP_COEF =
            new PpcPropertyName<>("update_offers_preview_sleep_coef", DOUBLE);

    /**
     * Размер чанка отправки офферных урлов на перепрокачку в LB самовара
     */
    public static final PpcPropertyName<Integer> UPDATE_OFFERS_PREVIEW_SENDING_CHUNK_SIZE =
            new PpcPropertyName<>("update_offers_preview_sending_chunk_size", INTEGER);

    /**
     * Время актуальности превью офферов для еком-доменов в часах
     */
    public static final PpcPropertyName<Long> OFFERS_PREVIEW_EXPIRATION_HOURS =
            new PpcPropertyName<>("offers_preview_expiration_hours", LONG);

    /**
     * Процент пользователей (uid), для которых редиректы проверяются в java
     */
    @Deprecated
    public static final PpcPropertyName<Integer> CHECK_REDIRECT_IN_JAVA_PERCENT =
            new PpcPropertyName<>("check_redirect_in_java_percent", INTEGER);

    /**
     * Пропускаем простукивание URL'а при его проверке
     */
    public static final PpcPropertyName<Boolean> SKIP_URL_CHECK =
            new PpcPropertyName<>("skip_url_check", BOOLEAN);

    /**
     * Получение домена с редиректами без whitelist. DIRECT-153570
     */
    public static final PpcPropertyName<Boolean> TRUST_REDIRECT_FROM_ANY_DOMAIN =
            new PpcPropertyName<>("trust_redirect_from_any_domain", BOOLEAN);

    /**
     * Коэффициент паузы после арховации/разархивации кампании в ppcCampQueue
     */
    public static final PpcPropertyName<Double> CAMP_ARC_QUEUE_SLEEP_COEF =
            new PpcPropertyName<>("camp_arc_queue_sleep_coef", DOUBLE);
    public static final PpcPropertyName<Double> ARC_CAMPAIGN_SLEEP_COEF =
            new PpcPropertyName<>("arc_campaign_sleep_coef", DOUBLE);

    /**
     * Отправлять или нет запрос в ручку турбо-апп
     */
    public static final PpcPropertyName<Boolean> USE_TURBO_APP_HANDLE =
            new PpcPropertyName<>("use_turbo_app_handle", BOOLEAN);

    /**
     * Обновлять ли турбо-аппы при просмотре баннера в гридах
     */
    public static final PpcPropertyName<Boolean> UPDATE_TURBO_APPS_ON_VIEW =
            new PpcPropertyName<>("update_turbo_apps_on_view", BOOLEAN);

    /**
     * Для джобы SupportChatSyncJob.
     * Хранит время модификации списка исключений фичи checked_support_chat на момент последней синхронизации.
     */
    public static final PpcPropertyName<LocalDateTime> CHECKED_SUPPORT_CHAT_FEATURE_LAST_SYNCED_MOD_TIME =
            new PpcPropertyName<>("checked_support_chat_feature_last_sync_time", PpcPropertyType.LOCAL_DATE_TIME);

    /**
     * Для джобы EnrichPlacementsRegionJob.
     * Хранит время, с которого будет искать обновленные блоки для выставления geoId.
     */
    public static final PpcPropertyName<LocalDateTime> ENRICH_PLACEMENTS_GEO_LAST_UPDATE_TIME =
            new PpcPropertyName<>("placements.enrich_geo.last_update_time", PpcPropertyType.LOCAL_DATE_TIME);

    /**
     * Для джобы EnrichPlacementsRegionJob.
     * Игнорировать выставленный ранее geoId и рассчитать заново.
     */
    public static final PpcPropertyName<Boolean> ENRICH_PLACEMENTS_GEO_IGNORE_OLD_GEO =
            new PpcPropertyName<>("placements.enrich_geo.ignore_old_geo", PpcPropertyType.BOOLEAN);

    /**
     * Для джобы EnrichPlacementsAddressJob.
     * Хранит время, с которого будет искать обновленные блоки для вычисления локализованных адресов.
     */
    public static final PpcPropertyName<LocalDateTime> ENRICH_PLACEMENTS_ADDRESS_LAST_UPDATE_TIME =
            new PpcPropertyName<>("placements.enrich_address_translations.last_update_time",
                    PpcPropertyType.LOCAL_DATE_TIME);

    /**
     * Для джобы UpdatePayForConversionPessimizedUsersJob
     * Хранит время последнего обновления таблицы в yt
     */
    public static final PpcPropertyName<LocalDateTime> PAY_FOR_CONVERSION_PESSIMIZED_USERS_LAST_UPDATE_TIME =
            new PpcPropertyName<>("bs.update.pay_for_conversion_pessimized_users.last_update_time",
                    PpcPropertyType.LOCAL_DATE_TIME);

    public static final PpcPropertyName<LocalDateTime> AGGREGATED_STATUS_RESYNC_QUEUE_LAST_UPDATE_TIME =
            new PpcPropertyName<>("aggregated_status_resync_queue.last_update_time",
                    PpcPropertyType.LOCAL_DATE_TIME);
    public static final PpcPropertyName<Boolean> AGGREGATED_STATUS_RESYNC_QUEUE_ENABLED =
            new PpcPropertyName<>("aggregated_status_resync_queue.enabled",
                    BOOLEAN);

    public static final PpcPropertyName<Boolean> AGGREGATED_STATUS_RESYNC_QUEUE_PREPARING_TABLES_ENABLED =
            new PpcPropertyName<>("aggregated_status_resync_queue.preparing_tables.enabled",
                    BOOLEAN);

    /**
     * Для расчета предупреждения о недостатке средств для оплаты конверсий
     * Минимальный остаток на счете необходимый для работы в режиме оплаты за конверсии
     * Предуреждение = campaignSumTotal < max (PAY_FOR_CONVERSION_AVG_CPA_WARNING_RATIO * Cpa,
     * * PAY_FOR_CONVERSION_MIN_RESERVED_SUM)
     */
    public static final PpcPropertyName<Integer> PAY_FOR_CONVERSION_MIN_RESERVED_SUM =
            new PpcPropertyName<>("direct.pay_for_conversion_min_reserved_sum",
                    INTEGER);

    /**
     * Для расчета предупреждения о недостатке средств для оплаты конверсий
     * Кратность цены конверсии при которой может вадаваться предупреждение
     * Предуреждение = campaignSumTotal < max (PAY_FOR_CONVERSION_AVG_CPA_WARNING_RATIO * Cpa,
     * PAY_FOR_CONVERSION_MIN_RESERVED_SUM)
     */
    public static final PpcPropertyName<Integer> PAY_FOR_CONVERSION_AVG_CPA_WARNING_RATIO =
            new PpcPropertyName<>("direct.pay_for_conversion_avg_cpa_warning_ratio",
                    INTEGER);

    /**
     * Для джобы UpdateTemplatePlaceJob.
     * Хранит время последнего обновления данных в MySQL таблице {@link Tables#TEMPLATE_PLACE}
     */
    public static final PpcPropertyName<Long> TEMPLATE_PLACE_LAST_UPDATE_UNIX_TIME =
            new PpcPropertyName<>("template_place.last_update_unix_time", LONG);

    /**
     * Для джобы UpdatePagePlaceJob.
     * Хранит время последнего обновления данных в MySQL таблице {@link Tables#PAGE_PLACE}
     */
    public static final PpcPropertyName<Long> PAGE_PLACE_LAST_UPDATE_UNIX_TIME =
            new PpcPropertyName<>("page_place.last_update_unix_time", LONG);

    /**
     * Для джобы UpdateTemplateResourceJob.
     * Хранит время последнего обновления данных в MySQL таблице {@link Tables#TEMPLATE_RESOURCE}
     */
    public static final PpcPropertyName<Long> TEMPLATE_RESOURCE_LAST_UPDATE_UNIX_TIME =
            new PpcPropertyName<>("template_resource.last_update_unix_time", LONG);

    /**
     * Для джобы UpdatePlacesJob.
     * Хранит время последнего обновления данных в MySQL таблице {@link Tables#INTERNAL_AD_PLACES}
     */
    public static final PpcPropertyName<Long> PLACES_LAST_UPDATE_UNIX_TIME =
            new PpcPropertyName<>("places.last_update_unix_time", LONG);

    /**
     * Для джобы UpdateBannersUnreachableUrlJob. Хранит флаг в зависимости от которого будут
     * останавливаться баннеры с недоступными ссылками (true - останавливаем, false - иначе)
     */
    public static final PpcPropertyName<Boolean> BANNERS_UNREACHABLE_URL_STOP_BANNERS_ENABLED =
            new PpcPropertyName<>("banners_unreachable_url_stop_banners_enabled", BOOLEAN);

    /**
     * Для джобы UpdateBannersUnreachableUrlJob. Хранит список id баннеров. Баннеры с этими id джоба не будет отключать.
     */
    public static final PpcPropertyName<Set<Long>> BANNERS_UNREACHABLE_URL_IDS_NOT_DISABLE =
            new PpcPropertyName<>("banners_unreachable_url_ids_not_disable", LONG_SET);

    /**
     * Для джобы UpdateBannersUnreachableUrlJob. Хранит список урлов. Если баннер содержит урлы только из этого списка,
     * то он не будет остановлен.
     */
    public static final PpcPropertyName<Set<String>> BANNERS_UNREACHABLE_URL_URLS_NOT_DISABLE =
            new PpcPropertyName<>("banners_unreachable_url_urls_not_disable", STRING_SET);

    /**
     * Для джобы UpdateBannersUnreachableUrlJob.
     * Хранит список ошибок, которые может выдать зора при проверке урла.
     * Если у урлов будут эти ошибки, то баннеры с такими урлами трогать не надо.
     */
    public static final PpcPropertyName<Set<String>> BANNERS_UNREACHABLE_URL_ERRORS_NOT_DISABLE =
            new PpcPropertyName<>("banners_unreachable_url_errors_not_disable", STRING_SET);

    /**
     * Для джобы ImportCryptaSegmentsJob.
     * Хранит дату последнего импорта данных в MySQL таблице {@link Tables#CRYPTA_GOALS}
     */
    public static final PpcPropertyName<LocalDate> CRYPTA_SEGMENTS_LAST_IMPORT_DATE =
            new PpcPropertyName<>("segments.last_import_date", LOCAL_DATE);

    public static final PpcPropertyName<Boolean> DK2_LIMITATION_ENABLED =
            new PpcPropertyName<>("dk2_limitation_enabled", BOOLEAN);

    public static final PpcPropertyName<Boolean> USE_NEW_DIRECT_SUBMISSIONS_URL =
            new PpcPropertyName<>("use_new_direct_submissions_url", BOOLEAN);

    /**
     * Автопринятие на модерации баннеров продвижения видео контента.
     * 1                            - автопринятие включено
     * 0 или отсутствие значения    - автопринятие выключено
     */
    public static final PpcPropertyName<Boolean> CONTENT_PROMOTION_AUTO_MODERATION =
            new PpcPropertyName<>("content_promotion_auto_moderation", PpcPropertyType.BOOLEAN);

    /**
     * Автопринятие на модерации баннеров геопродукта.
     * 1                            - автопринятие включено
     * 0 или отсутствие значения    - автопринятие выключено
     */
    public static final PpcPropertyName<Boolean> CPM_GEOPRODUCT_AUTO_MODERATION =
            new PpcPropertyName<>("cpm_geoproduct_auto_moderation", PpcPropertyType.BOOLEAN);

    /**
     * Содержит хеш-коды цветов для отображения cpm uac баннеров
     */
    public static final PpcPropertyName<List<String>> CPM_UAC_PROMO_COLORS =
            new PpcPropertyName<>("cpm_uac_promo_colors", STRING_LIST);

    /**
     * Автопринятие на модерации баннеров продвижения коллекций.
     * 1                            - автопринятие включено
     * 0 или отсутствие значения    - автопринятие выключено
     */
    public static final PpcPropertyName<Boolean> CONTENT_PROMOTION_COLLECTION_AUTO_MODERATION =
            new PpcPropertyName<>("content_promotion_collection_auto_moderation", PpcPropertyType.BOOLEAN);

    /**
     * Выполнять содержательные действия в джобе по обновлению продвигаемых коллекций.
     * 1                            - только джоба UpdateContentCollectionsJob полноценно работает
     * 0                            - только джоба ReceiveCollectionsChangesJob полноценно работает
     * отсутствие значения          - ни одна из джоб не работает
     */
    public static final PpcPropertyName<Boolean> ENABLE_CONTENT_PROMOTION_COLLECTIONS_JOB =
            new PpcPropertyName<>("enable_content_promotion_collections_job", PpcPropertyType.BOOLEAN);

    /**
     * Выполнять содержательные действия в джобе по обновлению заявки по кнопки покупки в директе
     * 1                            - джоба полноценно работает
     * 0 или отсутствие значения    - джоба после запуска приостанавливает работу
     */
    public static final PpcPropertyName<Boolean> ENABLE_DAAS_JOB =
            new PpcPropertyName<>("enable_daas_job", PpcPropertyType.BOOLEAN);

    /**
     * Принудительно включить полный экспорт биллинговых агрегатов во время следующего экспорта.
     * После выгрузки джоба самостоятельно сбросит этот флаг в 0.
     * <p>
     * См. джобу BillingAggregatesExportJob
     */
    public static final PpcPropertyName<Boolean> BILLING_AGGREGATES_FORCE_FULL_EXPORT_ONCE =
            new PpcPropertyName<>("billing_aggregates_force_full_export", PpcPropertyType.BOOLEAN);

    /**
     * Свойство, хранящее время последнего импорта данных по откруткам рекламодателей.
     * Используется скриптами ppcClientsDailySpentEstimate.pl и api5CalcUnitsLimit.pl,
     * а также джобой {@code clientsdailyspent.ImportEstimateFromYtJob}
     */
    public static final PpcPropertyName<String> CLIENTS_DAILY_SPENT_LAST_UPLOAD_TIME =
            new PpcPropertyName<>("ClientsDailySpentEstimate", STRING);

    /**
     * Для logic-processor'ов в ess
     * Нужно ли запускать logic-processor
     */

    public static final PpcPropertyName<Set<String>> DISABLED_ESS_LOGIC_PROCESSORS =
            new PpcPropertyName<>("disabled_ess_logic_processors", STRING_SET);

    /**
     * Названия классов отключенных rule в ess-router
     */
    public static final PpcPropertyName<Set<String>> DISABLED_ESS_RULES =
            new PpcPropertyName<>("disabled_ess_rules", STRING_SET);

    /**
     * Белый список объектов ess модерации.
     * Используется для удобного запуска ess модерации на бетах.
     */
    public static final PpcPropertyName<String> LIST_OF_OBJECTS_WITH_ENABLED_ESS_MODERATION =
            new PpcPropertyName<>("list_of_objects_with_enabled_ess_moderation", STRING);

    /**
     * Список категорий бизнеса
     */
    public static final PpcPropertyName<Set<String>> BUSINESS_CATEGORIES_SET =
            new PpcPropertyName<>("business_categories_set", STRING_SET);

    /**
     * Набор языков, которые разрешаем определять у объявлений, в формате ISO639-2B в нижнем регистре
     */
    public static final PpcPropertyName<Set<String>> RECOGNIZED_BANNER_LANGUAGES_SET =
            new PpcPropertyName<>("recognized_banner_languages_set", STRING_SET);

    /**
     * Проперти для джобы VideoGoalOutdoorUpdateJob
     * TODO: удалить как только избавимся от VideoGoalOutdoorUpdateJob
     */
    public static final PpcPropertyName<Boolean> VIDEOGOALS_OUTDOOR_UPDATE_ENABLED =
            new PpcPropertyName<>("videogoals.outdoor_update.enabled", BOOLEAN);
    public static final PpcPropertyName<LocalDate> VIDEOGOALS_OUTDOOR_UPDATE_READ_LOG_DATE_START =
            new PpcPropertyName<>("videogoals.outdoor_update.read_log_date_start", PpcPropertyType.LOCAL_DATE);
    public static final PpcPropertyName<LocalDate> VIDEOGOALS_OUTDOOR_UPDATE_READ_LOG_DATE_END =
            new PpcPropertyName<>("videogoals.outdoor_update.read_log_date_end", PpcPropertyType.LOCAL_DATE);

    /**
     * Включена ли джоба ClientAvatarsDeleteJob для удаления аватарок фрилансеров.
     */
    public static final PpcPropertyName<Boolean> CLIENTS_AVATARS_DELETION_ENABLED =
            new PpcPropertyName<>("clients_avatars_deletion_enabled", BOOLEAN);

    /**
     * Текущая ревизия кода приложения-ваншотилки.
     */
    public static final PpcPropertyName<String> ONESHOT_APP_CURRENT_REVISION =
            new PpcPropertyName<>("oneshot_app_current_revision", STRING);
    /**
     * Список нескольких последних ревизий приложения-ваншотилки.
     */
    public static final PpcPropertyName<List<String>> ONESHOT_APP_LAST_REVISIONS =
            new PpcPropertyName<>("oneshot_app_last_revisions", STRING_LIST);

    /**
     * На сколько процентов от времени выполнения итерации делать паузу
     */
    public static final PpcPropertyName<Map<String, Integer>> ONESHOT_RELAXED_PAUSE_PERCENT =
            new PpcPropertyName<>("oneshot_relaxed_pause_percent", PpcPropertyType.STRING_TO_INTEGER_MAP);


    /**
     * Проперти для изменения дефолтного значения ADD_METRICA_TAG в API
     */
    public static final PpcPropertyName<Boolean> DEFAULT_YES_FOR_ADD_METRICA_TAG =
            new PpcPropertyName<>("default_yes_for_add_metrica_tag", BOOLEAN);

    /**
     * Проперти для включения НДС в параметры, отдаваемые Campaigns.get
     */
    public static final PpcPropertyName<Boolean> RETURN_CAMPAIGN_SPEND_WITH_NDS_IN_API =
            new PpcPropertyName<>("return_campaign_spend_with_nds_in_api", BOOLEAN);

    /**
     * Включить/Выключить использование tvm в blackbox. Значения 1 или 0
     */
    public static final PpcPropertyName<Boolean> USE_BLACKBOX_TVM =
            new PpcPropertyName<>("use_blackbox_tvm", BOOLEAN);

    /**
     * Время последнего запуска джобы InvalidYandexServicesDomainsMonitoringJob
     */
    public static final PpcPropertyName<LocalDateTime> INVALID_YANDEX_SERVICES_DOMAINS_MONITORING_LAST_RUN_TIME =
            new PpcPropertyName<>("invalid_yandex_services_domains_monitoring_last_run_time",
                    PpcPropertyType.LOCAL_DATE_TIME);

    /**
     * Список сервисов Яндекса, для ссылок на которые (вида 'https://yandex.ru/service-name/...') мы генерируем
     * специальный сервисный домен 'service-domain.yandex.ru'.
     * Иногда у одного сервиса могут быть ссылки разного вида: например, для ссылок 'https://yandex.ru/maps/' и
     * 'https://yandex.ru/web-maps/' генерируется один и тот же сервисный домен - 'maps.yandex.ru'.
     * В свойстве хранится Map, ключами которого являются названия сервисов, а значениями - сервисные домены.
     */
    public static final PpcPropertyName<Map<String, String>> YANDEX_URL_TO_SERVICE_MAPPINGS =
            new PpcPropertyName<>("yandex_url_to_service_mappings", STRING_TO_STRING_MAP);

    /**
     * Список сервисов Яндекса, для ссылок на которые (вида 'https://yandex.ru/service-name/...') мы осознанно
     * не генерируем специальный сервисный домен, а оставляем 'yandex.ru' (в отличие от ситуаций, когда появляется
     * новый сервис, для которого мы не генерируем специальный домен просто потому, что ничего еще не знаем
     * про этот сервис).
     */
    public static final PpcPropertyName<Set<String>> YANDEX_SERVICES_WITHOUT_SPECIAL_DOMAIN =
            new PpcPropertyName<>("yandex_services_without_special_domain", PpcPropertyType.STRING_SET);

    private static final String ACTIVE_ORDERS_ORDER_STAT_BS_CHEVENT_LOG_TIMESTAMP =
            "active_orders_order_stat_bs_chevent_log_timestamp";

    /**
     * Количество батчей, на которое делит свой диапазон данных каждый воркер в джобе ActiveOrdersImportJob
     */
    public static final PpcPropertyName<Long> ACTIVE_ORDERS_BATCHES_COUNT =
            new PpcPropertyName<>("active_orders_batches_count", LONG);

    public static final PpcPropertyName<String> AUCTIONSTAT_PREPARED_CHEVENT_TIME =
            new PpcPropertyName<>("AUCTIONSTAT_PREPARED_CHEVENT_TIME", STRING);

    /**
     * Включает сохранение продвижения видеоконтента по новой схеме (через тип content_promotion)
     */
    public static final PpcPropertyName<Boolean> SAVE_CONTENT_PROMOTION_VIDEO_NEW_SCHEMA =
            new PpcPropertyName<>("save_content_promotion_video_new_schema", BOOLEAN);

    /**
     * Создавать общий счёт в addOrGet
     */
    public static final PpcPropertyName<Boolean> DO_CREATE_WALLET_IN_ADD_OR_GET =
            new PpcPropertyName<>("do_create_wallet_in_add_or_get", BOOLEAN);

    /**
     * Ходить из jobs напрямую в справочник
     */
    public static final PpcPropertyName<Boolean> USE_JOBS_ORGANIZATIONS_REQUESTS =
            new PpcPropertyName<>("use_jobs_organizations_requests", BOOLEAN);

    /**
     * список uid-ов, которому разрешаем GBP. -1 означает включение всем, отсутствие - никому
     */
    public static final PpcPropertyName<Set<Long>> GBP_CLIENT_UID =
            new PpcPropertyName<>("gbp_client_uid", LONG_SET);

    /**
     * список ClientID, которым разрешаем создавать клиентов с GBP. -1 означает включение всем, отсутствие - никому
     */
    public static final PpcPropertyName<Set<Long>> GBP_AGENCY_CLIENT_ID =
            new PpcPropertyName<>("gbp_agency_client_id", LONG_SET);

    /**
     * список uid-ов, которым отдаёт валидный статус в /daas/get_client_item_statuses/organizations.
     * -1 означает включение всем, отсутствие - никому
     * Используется в DaasIntapiController
     */
    public static final PpcPropertyName<Set<Long>> DAAS_ORGANIZATIONS_UIDS =
            new PpcPropertyName<>("daas_organizations_uids", LONG_SET);

    /**
     * список uid-ов, которым отдаёт валидный статус в /daas/get_client_item_statuses/collections.
     * -1 означает включение всем, отсутствие - никому
     * Используется в DaasIntapiController
     */
    public static final PpcPropertyName<Set<Long>> DAAS_COLLECTIONS_UIDS =
            new PpcPropertyName<>("daas_collections_uids", LONG_SET);

    public static final PpcPropertyName<Set<Long>> CIDS_TO_SKIP_IN_STATUSES_PROCESSOR =
            new PpcPropertyName<>("cids_to_skip_in_statuses_processor", LONG_SET);

    /**
     * Включает отправку в БК неявного ограничения максимальной ставки в CPA при ограничении недельного бюджета
     */
    public static final PpcPropertyName<Boolean> CALCULATE_IMPLICIT_CPA_MAX_BID_IN_TRANSPORT =
            new PpcPropertyName<>("calculate_implicit_cpa_max_bid_in_transport", BOOLEAN);

    /**
     * Включает отправку в Модерацию скопированных кампаний через ленивую переотправку
     */
    public static final PpcPropertyName<Boolean> REMODERATE_COPIED_CAMPAIGNS =
            new PpcPropertyName<>("remoderate_copied_campaigns", BOOLEAN);

    /**
     * Включает отправку в Модерацию всех измененных фраз (в том числе и при неизменной нормальной форме)
     */
    public static final PpcPropertyName<Boolean> MODERATE_EVERY_KEYWORD_CHANGE =
            new PpcPropertyName<>("moderate_every_keyword_change", BOOLEAN);

    /**
     * Позволяет переопределить: "воркер с параметрами из кронтаба" — "за кого нужно работать"
     */
    public static final PpcPropertyName<String> OLD_MODERATE_EXPORT_WORKERS_REMAPPING =
            new PpcPropertyName<>("moderate_export_perl_workers_remapping", STRING);

    /**
     * Включено ли автоматическое распределение воркеров
     */
    public static final PpcPropertyName<Boolean> OLD_MODERATE_EXPORT_AUTO_BALANCING_WORKERS =
            new PpcPropertyName<>("moderate_export_perl_auto_balancing_workers", BOOLEAN);

    /**
     * Неснижаемое число воркеров в шарде (не будут переназначены в другие шарды)
     */
    public static final PpcPropertyName<Long> OLD_MODERATE_EXPORT_MIN_WORKERS_TO_KEEP =
            new PpcPropertyName<>("moderate_export_perl_min_workers_to_keep", LONG);

    /**
     * Максимальное число воркеров для добавления в шард
     */
    public static final PpcPropertyName<Long> OLD_MODERATE_EXPORT_MAX_WORKERS_TO_ADD =
            new PpcPropertyName<>("moderate_export_perl_max_workers_to_add", LONG);
    /**
     * Включен ли новый шедулер
     */
    public static final PpcPropertyName<Boolean> IS_HOURGLASS_ENABLED = new PpcPropertyName<>("is_hourglass_enabled",
            BOOLEAN);

    private static final String AUCTIONSTAT_UPDATE_CHEVENT_LOG_TIMESTAMP =
            "auctionstat_update_chevent_log_timestamp";

    private static final String BS_AUCTION_STAT_TIME = "bsStatTime";

    private static final String MIN_BID_WITH_PROCESSED_LANGUAGE = "min_bid_with_processed_language";

    /**
     * Включена ли джоба FillBannersLanguageJob
     */
    public static final PpcPropertyName<Boolean> FILL_BANNERS_LANGUAGE_JOB_ENABLED =
            new PpcPropertyName<>("fill_banners_language_job_enabled", BOOLEAN);

    /**
     * Коэффициент для {@link ru.yandex.direct.common.util.RelaxedWorker}, использующийся в джобе FillBannersLanguageJob
     */
    public static final PpcPropertyName<Double> FILL_BANNERS_LANGUAGE_JOB_SLEEP_COEFFICIENT =
            new PpcPropertyName<>("fill_banners_language_job_sleep_coefficient", DOUBLE);

    private static final String CAMP_AGGREGATED_LASTCHANGE_HIGH_BOUNDARY = "camp_aggregated_lastchange_high_boundary";

    private static final String REMOVE_SPAM_FROM_MODERATION_EXPORT_QUEUE_LAST_TIME =
            "remove_spam_from_moderation_export_queue_last_time";

    public static final PpcPropertyName<String> MIN_PAY_AB_DISTRIBUTION = new PpcPropertyName<>("MIN_PAY_AB", STRING);

    public static final PpcPropertyName<Double> AUTOPAY_PAYMENT_SUM =
            new PpcPropertyName<>("AUTOPAY_PAYMENT_SUM", DOUBLE);

    public static final PpcPropertyName<Double> AUTOPAY_REMAINING_SUM =
            new PpcPropertyName<>("AUTOPAY_REMAINING_SUM", DOUBLE);

    public static final PpcPropertyName<Double> AUTOOVERDRAFT_SUGGEST_COEF =
            new PpcPropertyName<>("AUTOOVERDRAFT_SUGGEST_COEF", DOUBLE);

    public static final PpcPropertyName<String> PAYMENT_SUGGEST_BLOCK_AB =
            new PpcPropertyName<>("PAYMENT_SUGGEST_BLOCK_AB", STRING);

    /**
     * Период запоминания галки "включить автоплатеж" - DIRECT-116583
     */
    public static final PpcPropertyName<Integer> NEW_PAYMENT_WORKFLOW_AUTOPAY_SAVE_PERIOD =
            new PpcPropertyName<>("NEW_PAYMENT_WORKFLOW_AUTOPAY_SAVE_PERIOD", INTEGER);

    /**
     * Показывать ли изменения галочек автоприменения в пользовательских логах
     */
    public static final PpcPropertyName<Boolean> SHOW_AUTO_APPLY_CHANGES_IN_USER_LOGS =
            new PpcPropertyName<>("SHOW_AUTO_APPLY_CHANGES_IN_USER_LOGS", BOOLEAN);

    /**
     * Процент запросов к некоторым ручкам статистики БК, которые будут направлены в пре-продакшн хосты БК
     */
    public static final PpcPropertyName<Integer>
            EXPORT_PREPROD_USAGE_PCT_PROP_NAME = new PpcPropertyName<>("BS_EXPORT_PREPROD_USAGE_PCT", INTEGER);

    /**
     * На сколько процентов заказов выключена логика отправки данных двумя запросами
     */
    public static final PpcPropertyName<Integer> BS_EXPORT_SECOND_QUERY_DISABLE_PERCENT =
            new PpcPropertyName<>("BS_EXPORT_SECOND_QUERY_DISABLE_PERCENT", INTEGER);
    /**
     * На каких клиентоа выключена логика отправки данных двумя запросами
     */
    public static final PpcPropertyName<List<Long>> BS_EXPORT_SECOND_QUERY_DISABLE_CLIENT_IDS =
            new PpcPropertyName<>("BS_EXPORT_SECOND_QUERY_DISABLE_CLIENT_IDS", LONG_LIST);

    public static final PpcPropertyName<Map<String, Integer>> BS_EXPORT_SOAP_STRIP_KEYS_PERCENT = new PpcPropertyName<>(
            "BS_EXPORT_SOAP_STRIP_KEYS_PERCENT",
            PpcPropertyType.STRING_TO_INTEGER_MAP
    );

    public static final PpcPropertyName<Boolean> BS_EXPORT_HEAVY_SHAKE_ENABLED =
            new PpcPropertyName<>("BS_EXPORT_HEAVY_SHAKE_ENABLED", BOOLEAN);

    /**
     * Выключено ли логирование отправок ставок
     */
    public static final PpcPropertyName<Boolean> BS_EXPORT_ESS_BIDDABLE_SHOWS_CONDITIONS_LOG_DISABLED =
            new PpcPropertyName<>("BS_EXPORT_ESS_BIDDABLE_SHOWS_CONDITIONS_LOG_DISABLED", BOOLEAN);

    /**
     * Выключена ли отправка ставок, найденных по изменению retargeting_condition
     */
    public static final PpcPropertyName<Boolean> BS_EXPORT_ESS_BIDDABLE_SHOWS_CONDITIONS_RET_COND_IDS_IGNORED =
            new PpcPropertyName<>("BS_EXPORT_ESS_BIDDABLE_SHOWS_CONDITIONS_RET_COND_IDS_IGNORED", BOOLEAN);

    /**
     * Отправлять ли turbo.site в качестве заглушки для доменов турбостраниц
     */
    public static final PpcPropertyName<Boolean> SEND_TURBO_SITE_AS_DOMAIN_PLACEHOLDER =
            new PpcPropertyName<>("SEND_TURBO_SITE_AS_DOMAIN_PLACEHOLDER", BOOLEAN);

    /**
     * Включает использование нового поля в API5.Reports для идентификаторов условий показа
     */
    public static final PpcPropertyName<Boolean> USE_NEW_CRITERION_ID =
            new PpcPropertyName<>("use_new_criterion_id", BOOLEAN);

    /**
     * Включает отправку хеша счетчиков метрики в БК
     */
    public static final PpcPropertyName<Boolean> BS_EXPORT_METRIKA_COUNTERS_HASH_ENABLED =
            new PpcPropertyName<>("BS_EXPORT_METRIKA_COUNTERS_HASH_ENABLED", BOOLEAN);

    /**
     * отправлять ли запросы в сплитилку AB-тестов (uaas)
     */
    public static final PpcPropertyName<Boolean> UAAS_ENABLED = new PpcPropertyName<>("UAAS_ENABLED", BOOLEAN);
    public static final PpcPropertyName<Boolean> UAAS_CALC_WALLET_PROPS =
            new PpcPropertyName<>("UAAS_CALC_WALLET_PROPS", BOOLEAN);

    /**
     * Временный флаг: запускать или нет новые джобы сбора сегментов с оптимизацией памяти
     */
    public static final PpcPropertyName<Boolean> SEGMENT_JOBS_RUN_GREEDY_JOBS =
            new PpcPropertyName<>("segment_jobs_run_greedy_jobs", BOOLEAN);

    /**
     * Запускать или нет новые джобы сбора сегментов видевших ТГО рекламу
     */
    public static final PpcPropertyName<Boolean> SEGMENT_JOBS_RUN_TEXT_GREEDY_JOBS =
            new PpcPropertyName<>("segment_jobs_run_text_greedy_jobs", BOOLEAN);

    /**
     * Игнорировать пропущенные дни в логах. В этом режиме такие дни пропускаются
     * и автоматически уже не будут обработаны для тех сегментов, для которых были пропущены.
     */
    public static final PpcPropertyName<Boolean> SEGMENT_JOBS_IGNORE_MISSED_DAYS =
            new PpcPropertyName<>("segment_jobs_ignore_missed_days", BOOLEAN);

    /**
     * Дата, с которой нужно начать генерировать промежуточные таблицы в YT для сбора сегментов.
     * <p>
     * В обычном режиме, когда проперти не указана, джоба самостоятельно определяет,
     * до какой даты таблички уже сгенерированы, и начинает генерировать со следующего дня.
     * <p>
     * Проперти позволяет перегенерировать последние дни, а так же осуществить первый запуск джобы,
     * когда нет ни одной сгенерированной таблички.
     * <p>
     * Джоба удаляет проперти при завершении работы.
     */
    public static final PpcPropertyName<LocalDate> SEGMENT_JOBS_INTERMEDIATE_START_LOG_DATE =
            new PpcPropertyName<>("segment_jobs_intermediate_start_log_date", LOCAL_DATE);

    /**
     * Аналогично {@link #SEGMENT_JOBS_INTERMEDIATE_START_LOG_DATE}, но для cpm данных
     */
    public static final PpcPropertyName<LocalDate> SEGMENT_JOBS_CPM_INTERMEDIATE_START_LOG_DATE =
            new PpcPropertyName<>("segment_jobs_cpm_intermediate_start_log_date", LOCAL_DATE);

    /**
     * Запускать common-джобы генерации промежуточных таблиц в YT для сбора сегментов
     */
    public static final PpcPropertyName<Boolean> SEGMENT_JOBS_RUN_COMMON_INTERMEDIATE_JOBS =
            new PpcPropertyName<>("segment_jobs_run_common_intermediate_jobs", BOOLEAN);

    /**
     * Лимит uid-ов, которые джоба будет выбирать за один запуск из YT.
     */
    public static final PpcPropertyName<Long> SEGMENT_JOBS_DATA_LIMIT =
            new PpcPropertyName<>("segment_jobs_data_limit", LONG);

    /**
     * Сколько сегментов джоба будет обрабатывать за 1 запуск.
     */
    public static final PpcPropertyName<Integer> SEGMENT_JOBS_SEGMENTS_LIMIT =
            new PpcPropertyName<>("segment_jobs_segments_limit", INTEGER);

    public static final PpcPropertyName<Boolean> ALLOW_MASS_ADD_REMOVE_PERMALINKS_IN_SYNC_JOB =
            new PpcPropertyName<>("allow_mass_add_remove_permalinks_in_sync_job", BOOLEAN);

    public static final PpcPropertyName<Long> AUTO_PERMALINKS_LAST_TIME_UPDATED_MILLIS =
            new PpcPropertyName<>("auto_permalinks_last_time_updated_millis", LONG);

    public static final PpcPropertyName<Boolean> UPDATE_PERMALINKS_JOB_IN_JAVA_ENABLED =
            new PpcPropertyName<>("update_permalinks_job_in_java_enabled", BOOLEAN);

    /**
     * Проперти для автозаполнения полей (почта, страна) на welcome странице. Содержит список uid'ов с
     * включенной функциональностью; -1, если включено для всех.
     */
    public static final PpcPropertyName<Set<Long>> WELCOME_PAGE_AUTOCOMPLETE_ENABLED_FOR_UIDS =
            new PpcPropertyName<>("welcome_page_autocomplete_enabled_for_uids", LONG_SET);

    /**
     * Проперти для отключения сбора телефонов рекламодателей в отдельных странах.
     */
    public static final PpcPropertyName<Set<Long>> COLLECTING_VERIFIED_PHONES_DISABLED_FOR_COUNTRIES =
            new PpcPropertyName<>("collecting_verified_phones_disabled_for_countries", LONG_SET);

    /**
     * Значение максимального количества запросов в день в ручки подтверждения телефона (confirmAndBindPhoneSubmit и
     * confirmAndBindPhoneCommit).
     */
    public static final PpcPropertyName<Integer> PHONE_VERIFICATION_MAX_CALLS_COUNT_PER_DAY =
            new PpcPropertyName<>("phone_verification_max_calls_count_per_day", INTEGER);

    /**
     * Для переопределения значения {@code $MODERATE_TEXT_LIMITS_ADGROUPS }
     * https://a.yandex-team.ru/arc/trunk/arcadia/direct/perl/protected/Moderate/Settings.pm#L27
     */
    public static final PpcPropertyName<Integer> MODERATE_TEXT_LIMITS_ADGROUPS =
            new PpcPropertyName<>("moderate_text_limits_adgroups", INTEGER);

    /**
     * Значение для включения проксирования перлового метода Lang::Guess::analyze_text_lang в intapi метод
     * analyze_texts_lang. Должно быть в интервале [0, 100].
     */
    public static final PpcPropertyName<Integer>
            ENABLE_PROXY_FOR_ANALYZE_TEXT_LANG = new PpcPropertyName<>("enable_proxy_for_analyze_text_lang", INTEGER);

    /**
     * Список клиентов, для которых включен узбекский язык. Если множество содержит только значение -1, то проперти
     * включена для всех.
     */
    public static final PpcPropertyName<Set<Long>> CLIENTS_WITH_ENABLED_UZBEK_LANGUAGE =
            new PpcPropertyName<>("clients_with_enabled_uzbek_language", LONG_SET);

    /**
     * Список клиентов, для которых включен вьетнамский язык.
     */
    public static final PpcPropertyName<Set<Long>> CLIENTS_WITH_DEFAULT_VIE_LANGUAGE =
            new PpcPropertyName<>("clients_with_default_vie_language", LONG_SET);

    /**
     * Пороги для определения узбекского языка.
     */
    public static final PpcPropertyName<Double> CYRILLIC_UZBEK_TO_RUSSIAN_THRESHOLD =
            new PpcPropertyName<>("cyrillic_uzbek_to_russian_threshold", DOUBLE);
    public static final PpcPropertyName<Double> LATIN_UZBEK_TO_RUSSIAN_THRESHOLD =
            new PpcPropertyName<>("latin_uzbek_to_russian_threshold", DOUBLE);
    public static final PpcPropertyName<Double> UZBEK_TO_TURKISH_THRESHOLD =
            new PpcPropertyName<>("uzbek_to_turkish_threshold", DOUBLE);
    public static final PpcPropertyName<Double> UZBEK_TO_UNKNOWN_THRESHOLD =
            new PpcPropertyName<>("uzbek_to_unknown_threshold", DOUBLE);

    public static final PpcPropertyName<Boolean> DO_NOT_SEND_EXTRA_BANNER_IMAGE_FORMATS_TO_BS =
            new PpcPropertyName<>("DO_NOT_SEND_EXTRA_BANNER_IMAGE_FORMATS_TO_BS", BOOLEAN);

    private static final String LAST_CAMPAIGN_ID_WITH_RECALCULATED_STATUS = "last_campaign_id_with_recalculated_status";

    private static final String RECALCULATE_CAMPAIGNS_STATUS_JOB_ENABLED = "recalculate_campaigns_status_job_enabled";

    private static final String LAST_AB_PREPARED_DATA = "last_ab_prepared_data";

    private static final String COMMUNICATIONS_MODIFICATION_TIME_LAST_TABLE =
            "communications_modification_time_last_table";

    private static final String BANNER_RESOURCES_TABLE_TO_QUEUE_RESYNC_STATE =
            "banner_resources_table_to_queue_resync_state";
    private static final String AD_GROUPS_TABLE_TO_QUEUE_RESYNC_STATE =
            "ad_groups_table_to_queue_resync_state";

    private static final String AD_GROUPS_SHOW_CONDITION_TABLE_TO_QUEUE_RESYNC_STATE =
            "ad_groups_show_condition_table_to_queue_resync_state";

    private static final String CREATED_OBJECTS_STATS_LAST_COLLECT_TIME =
            "created_objects_stats_last_collect_time";

    private static final String DISABLE_FEEDS_IN_MBI_LAST_TIME =
            "disable_feeds_in_mbi_last_time";

    /**
     * Коэффициент для {@link ru.yandex.direct.common.util.RelaxedWorker}, использующийся в джобе
     * RecalculateCampaignsStatusJob
     */
    public static final PpcPropertyName<Double> RECALCULATE_CAMPAIGNS_STATUS_JOB_SLEEP_COEFFICIENT =
            new PpcPropertyName<>("recalculate_campaigns_status_job_sleep_coefficient", DOUBLE);

    public static final PpcPropertyName<Integer> RECALCULATE_CAMPAIGNS_STATUS_JOB_ITERATION_LIMIT =
            new PpcPropertyName<>("recalculate_campaigns_status_job_iteration_limit", INTEGER);

    public static final PpcPropertyName<String> RECALCULATE_CAMPAIGNS_STATUS_JOB_DEPTH =
            new PpcPropertyName<>("recalculate_campaigns_status_job_depth", STRING);


    /**
     * Параметры NotifyClientCashbackJob:
     * 1) Кластер с данными
     * 2) Директория с табличками с данными
     * 3) Время создания последней обработанной таблички
     * 4) Количество обработанных строчек в табличке
     * 5) Количество строчек обрабатываемых за итерацию
     */
    public static final PpcPropertyName<String> NOTIFY_CASHBACK_CLUSTER =
            new PpcPropertyName<>("notify_cashback_cluster", STRING);
    public static final PpcPropertyName<String> NOTIFY_CASHBACK_DIRECTORY =
            new PpcPropertyName<>("notify_cashback_directory", STRING);
    public static final PpcPropertyName<String> NOTIFY_CASHBACK_TABLE_CREATTION_TIME =
            new PpcPropertyName<>("notify_cashback_table_creation_time", STRING);
    public static final PpcPropertyName<Integer> NOTIFY_CASHBACK_ROW_NUMBER =
            new PpcPropertyName<>("notify_cashback_row_number", INTEGER);
    public static final PpcPropertyName<Integer> NOTIFY_CASHBACK_CHUNK_SIZE =
            new PpcPropertyName<>("notify_cashback_chunk_size", INTEGER);

    /**
     * Дата, за которую необходимо запустить расчет //home/direct/db эта дата будет использована для того, чтобы понять
     * с каким снепшотом mysql-sync'а работаем
     */
    public static final PpcPropertyName<LocalDate> HOME_DIRECT_DB_DATE =
            new PpcPropertyName<>("HOME_DIRECT_DB_DATE", LOCAL_DATE);

    /**
     * Только эти запросы будут запускаться для генерации //home/direct/db
     * <p>
     * Пример: [banners, bids_performance] (без суффикса .yql)
     */
    public static final PpcPropertyName<Set<String>> HOME_DIRECT_DB_INCLUDE =
            new PpcPropertyName<>("HOME_DIRECT_DB_INCLUDE", STRING_SET);

    /**
     * Эти запросы будут исключены из общего списка запросов при запуске генерации //home/direct/db
     * <p>
     * Пример: [banners, bids_performance] (без суффикса .yql)
     */
    public static final PpcPropertyName<Set<String>> HOME_DIRECT_DB_EXCLUDE =
            new PpcPropertyName<>("HOME_DIRECT_DB_EXCLUDE", STRING_SET);

    /**
     * Общий вычислительный пулл на все операции для //home/direct/db включая запрос сверки качества данных
     */
    public static final PpcPropertyName<String> HOME_DIRECT_DB_POOL =
            new PpcPropertyName<>("HOME_DIRECT_DB_POOL", STRING);

    /**
     * Флаг, по которому джобы для //home/direct/db будут выполняют всю работу или нет.
     * Если false - то джобы выполняет только простую работу (например, выводят что-то в лог),
     * если true - то всю. Это сделано, чтобы можно было зашедулить джобы на ТС и devtest,
     * при этом не растрачивая ресурсы зазря.
     */
    public static final PpcPropertyName<Boolean> HOME_DIRECT_DB_FULL_WORK =
            new PpcPropertyName<>("HOME_DIRECT_DB_FULL_WORK", BOOLEAN);

    /**
     * Имена таблиц, по которым будут запускаться проверки целостности данных, заливаемых m2yt-full
     * Содержат префикс базы, например ppc:campaigns, ppcdict:geo_translation
     */
    public static final PpcPropertyName<List<String>> YT_CHECKSUM_TABLES_INCLUDE =
            new PpcPropertyName<>("YT_CHECKSUM_TABLES_INCLUDE", STRING_LIST);

    /**
     * Имена таблиц, которые должны быть исключены из проверки целостности
     * Содержат префикс базы, например ppc:campaigns, ppcdict:geo_translation
     */
    public static final PpcPropertyName<List<String>> YT_CHECKSUM_TABLES_EXCLUDE =
            new PpcPropertyName<>("YT_CHECKSUM_TABLES_EXCLUDE", STRING_LIST);

    /**
     * Количество шардов реплики БД в продовом YT
     * Используется на тестовых средах для выгрузки directdb из реплики
     */
    public static final PpcPropertyName<Integer> YT_PROD_MYSQL_SHARDS_COUNT =
            new PpcPropertyName<>("YT_PROD_MYSQL_SHARDS_COUNT", INTEGER);

    /**
     * Путь к директории с данными в YT, куда нацелен проверяемый синхронизатор
     * И где будут ожидаться результаты репликации чанков
     * Пример значения "//home/direct/mysql-sync/v.15"
     */
    public static final PpcPropertyName<String> YT_CHECKSUM_DEST_PATH =
            new PpcPropertyName<>("YT_CHECKSUM_DEST_PATH", STRING);

    /**
     * Писать ли в трекер тикеты с сообщениями о найденных расхождениях
     */
    public static final PpcPropertyName<Boolean> YT_CHECKSUM_USE_TRACKER =
            new PpcPropertyName<>("YT_CHECKSUM_USE_TRACKER", PpcPropertyType.BOOLEAN);

    /**
     * Отдельные колонки, которые нужно не использовать при сверке данных
     * Пример значения "ppc:campaigns.strategy_data, ppc:camp_options.contactinfo"
     */
    public static final PpcPropertyName<List<String>> YT_CHECKSUM_COLUMNS_EXCLUDE =
            new PpcPropertyName<>("YT_CHECKSUM_COLUMNS_EXCLUDE", STRING_LIST);

    /**
     * Очередь в стартреке, куда создавать тикеты
     */
    public static final PpcPropertyName<String> YT_CHECKSUM_TRACKER_QUEUE =
            new PpcPropertyName<>("YT_CHECKSUM_TRACKER_QUEUE", STRING);

    /**
     * Автопринятие на модерации баннеров геопинов.
     * 1                            - автопринятие включено
     * 0 или отсутствие значения    - автопринятие выключено
     */
    public static final PpcPropertyName<Boolean> CPM_GEO_PIN_AUTO_MODERATION =
            new PpcPropertyName<>("cpm_geo_pin_auto_moderation", PpcPropertyType.BOOLEAN);

    /**
     * Calltracking: ID плейбека, который должен быть проигран клиенту Директа перед соединением
     */
    public static final PpcPropertyName<String> TELEPHONY_PLAYBACK_ID =
            new PpcPropertyName<>("telephony_playback_id", STRING);

    /**
     * Calltracking: отвязывать подменники у организаций без прав
     */
    public static final PpcPropertyName<Boolean> CALLTRACKING_UNLINK_PHONE_ENABLED =
            new PpcPropertyName<>("calltracking_unlink_phone_enabled", BOOLEAN);

    /**
     * Calltracking: Последний успешно прочитанный период watch-log
     */
    public static final PpcPropertyName<LocalDateTime> CALLTRACKING_PARSE_WATCH_LOG_LAST_READ_TIME =
            new PpcPropertyName<>("CALLTRACKING_PARSE_WATCH_LOG_LAST_READ_TIME", LOCAL_DATE_TIME);

    /**
     * Calltracking: Перекладывать данные о сторонних коллтрекингах на сайте из статических таблиц в динамическую
     */
    public static final PpcPropertyName<Boolean> CALLTRACKING_EXTERNAL_BY_DOMAIN_POPULATE_DYN_TABLE_JOB_ENABLED =
            new PpcPropertyName<>("CALLTRACKING_EXTERNAL_BY_DOMAIN_POPULATE_DYN_TABLE_JOB_ENABLED", BOOLEAN);

    /**
     * Calltracking: Последний успешно прочитанный период watch-log для получения сторонних коллтрекингов
     * на сайтах рекламодателей
     */
    public static final PpcPropertyName<LocalDateTime> CALLTRACKING_EXTERNAL_BY_DOMAIN_PARSE_WATCH_LOG_LAST_READ_TIME =
            new PpcPropertyName<>("CALLTRACKING_EXTERNAL_BY_DOMAIN_PARSE_WATCH_LOG_LAST_READ_TIME", LOCAL_DATE_TIME);

    /**
     * Calltracking: Время последнего успешного прочтения watch-log для данных о телефонных номерах,
     * для которых не сработала подмена на сайте
     */
    public static final PpcPropertyName<LocalDateTime>
            CALLTRACKING_PHONES_WITHOUT_REPLACEMENTS_PARSE_WATCH_LOG_LAST_READ_TIME =
            new PpcPropertyName<>(
                    "CALLTRACKING_PHONES_WITHOUT_REPLACEMENTS_PARSE_WATCH_LOG_LAST_READ_TIME",
                    LOCAL_DATE_TIME);

    /**
     * Calltracking: Перекладывать данные о кликах по номерам из статических таблиц в динамическую
     */
    public static final PpcPropertyName<Boolean> CALLTRACKING_NUMBER_CLICKS_POPULATE_DYN_TABLE_JOB_ENABLED =
            new PpcPropertyName<>("CALLTRACKING_NUMBER_CLICKS_POPULATE_DYN_TABLE_JOB_ENABLED", BOOLEAN);

    /**
     * Calltracking: Перекладывать данные о телефонных номерах,
     * для которых не сработала подмена на сайте, из статических таблиц в динамическую
     */
    public static final PpcPropertyName<Boolean> PHONES_WITHOUT_REPLACEMENTS_POPULATE_DYN_TABLE_JOB_ENABLED =
            new PpcPropertyName<>("PHONES_WITHOUT_REPLACEMENTS_POPULATE_DYN_TABLE_JOB_ENABLED", BOOLEAN);

    /**
     * Calltracking: размер батча с которым будут делаться запросы за списком номеров
     * для подменников в джобе TelephonySyncCalltrackingPhonesPoolJob
     */
    public static final PpcPropertyName<Integer> CALLTRACKING_SYNC_PHONES_POOL_BATCH_SIZE =
            new PpcPropertyName<>("calltracking_sync_phones_pool_batch_size", INTEGER);

    /**
     * Calltracking: количество дней сколько может не обновляться номер в calltracking_phones
     * прежде чем его удалит джоба TelephonySyncCalltrackingPhonesPoolJob
     */
    public static final PpcPropertyName<Integer> CALLTRACKING_SYNC_PHONES_POOL_DELETE_OLDER_THAN_DAYS =
            new PpcPropertyName<>("calltracking_sync_phones_pool_delete_older_than_days", INTEGER);

    /**
     * Дата и время последнего изменения в справочнике временных зон (GeoTimezones)
     */
    public static final PpcPropertyName<LocalDateTime> GEO_TIMEZONES_UPDATE_TIME =
            new PpcPropertyName<>("geo_timezones_update_time", LOCAL_DATE_TIME);

    /**
     * Дата и время последнего изменения в справочнике регионов (GeoRegions)
     */
    public static final PpcPropertyName<LocalDateTime> GEO_REGIONS_UPDATE_TIME =
            new PpcPropertyName<>("geo_regions_update_time", LOCAL_DATE_TIME);

    /**
     * Удаление старых партиций логов в джобе ClickHouseCleanerJob.
     */
    public static final PpcPropertyName<Boolean> PPCHOUSE_CLEANER_REAL_REMOVE =
            new PpcPropertyName<>("ppchouse_cleaner_real_remove", PpcPropertyType.BOOLEAN);

    public static final PpcPropertyName<Boolean> DISABLE_OLD_UC =
            new PpcPropertyName<>("disable_old_uc", PpcPropertyType.BOOLEAN);

    /**
     * При превышении какого количество пустых доменов в выгрузке для вычисления агентских комиссий стоит заводить тикет
     */
    public static final PpcPropertyName<Long> BILLING_ORDER_DOMAINS_COST_THRESHOLD =
            new PpcPropertyName<>("billing_order_domains_cost_threshold", LONG);

    /**
     * При превышении какого количество денег, по котороым вычисляются агентские комиссии стоит заводить тикет
     */
    public static final PpcPropertyName<Long> BILLING_ORDER_DOMAINS_COUNT_THRESHOLD =
            new PpcPropertyName<>("billing_order_domains_count_threshold", LONG);

    /**
     * Максимальное количество счётчиков метрики, для которого строим пресеты сегментов метрики
     */
    public static final PpcPropertyName<Integer> METRIKA_SEGMENT_PRESETS_COUNTERS_LIMIT =
            new PpcPropertyName<>("metrika_segment_presets_counters_limit", INTEGER);

    /**
     * Использовать страницу Яндекс.Паспорта для верификации пароля пользователя
     */
    public static final PpcPropertyName<Boolean> PASSPORT_VERIFICATION_PAGE_ENABLED =
            new PpcPropertyName<>("PASSPORT_VERIFICATION_PAGE_ENABLED", PpcPropertyType.BOOLEAN);

    /**
     * Номер последний обработанной строки из выгрузки редиректов для отрыва промокодов
     */
    public static final PpcPropertyName<Long> FRAUD_PROMO_REDIRECTS_LAST_ROW =
            new PpcPropertyName<>("fraud_promo_redirects_last_row", LONG);

    /**
     * Название последней обработанной джобой отправки писем таблицы с лимитами овердрафтов
     */
    public static final PpcPropertyName<String> OVERDRAFT_LIMIT_MAILER_LAST_TABLE_NAME =
            new PpcPropertyName<>("overdraft_limit_mailer_last_table_name", STRING);

    /**
     * Стоит ли учитывать проверку домена и клиента по данным Комдепа при вводе и зачислении промокода
     */
    public static final PpcPropertyName<Boolean> PROMOCODE_DOMAIN_CLIENT_CHECK_IS_ENABLED =
            new PpcPropertyName<>("promocode_domain_client_check_is_enabled", BOOLEAN);

    /**
     * ClientID агенств, которые используются в БК для Директ-Мониторинга. DIRECT-114748
     */
    public static final PpcPropertyName<Set<Long>> BS_AGENCY_IDS_FOR_DIRECT_MONITORING =
            new PpcPropertyName<>("bs_agency_ids_for_direct_monitoring", LONG_SET);

    /**
     * Включение обработки уменьшенных идентфикаторов джоб для сервисов API4.
     */
    public static final PpcPropertyName<Boolean> FIX_JOB_ID_IN_API4 =
            new PpcPropertyName<>("fix_job_id_in_api4", PpcPropertyType.BOOLEAN);

    /**
     * Кластер, из которого читать watch-log
     */
    public static final PpcPropertyName<String> PARSE_WATCH_LOG_CLUSTER =
            new PpcPropertyName<>("PARSE_WATCH_LOG_CLUSTER", STRING);

    /**
     * Последний успешно прочитанный период watch-log, используемый джобой ParseWatchLogsJob
     */
    public static final PpcPropertyName<LocalDateTime> PARSE_WATCH_LOG_LAST_READ_TIME =
            new PpcPropertyName<>("PARSE_WATCH_LOG_LAST_READ_TIME", LOCAL_DATE_TIME);

    public static final PpcPropertyName<Boolean> PARSE_WATCH_LOG_POPULATE_DYN_TABLE_JOB_ENABLED =
            new PpcPropertyName<>("PARSE_WATCH_LOG_POPULATE_DYN_TABLE_JOB_ENABLED", BOOLEAN);

    /**
     * Последний успешно прочитанный период watch-log, используемый джобой ParseWatchLogsWeakRestrictionsJob
     */
    public static final PpcPropertyName<LocalDateTime> PARSE_WATCH_LOG_WEAK_RESTRICTIONS_LAST_READ_TIME =
            new PpcPropertyName<>("PARSE_WATCH_LOG_WEAK_RESTRICTIONS_LAST_READ_TIME", LOCAL_DATE_TIME);

    public static final PpcPropertyName<Boolean> PARSE_WATCH_LOG_WEAK_RESTRICTIONS_POPULATE_DYN_TABLE_JOB_ENABLED =
            new PpcPropertyName<>("PARSE_WATCH_LOG_WEAK_RESTRICTIONS_POPULATE_DYN_TABLE_JOB_ENABLED", BOOLEAN);

    /**
     * Кластер, из которого читать hit-log
     */
    public static final PpcPropertyName<String> PARSE_HIT_LOG_CLUSTER =
            new PpcPropertyName<>("parse_hit_log_cluster", STRING);

    /**
     * Последний успешно прочитанный период hit-log, используемый джобой ParseHitLogsJob
     */
    public static final PpcPropertyName<LocalDateTime> PARSE_HIT_LOG_LAST_READ_TIME =
            new PpcPropertyName<>("parse_hit_log_last_read_time", LOCAL_DATE_TIME);

    public static final PpcPropertyName<Boolean> PARSE_HIT_LOG_POPULATE_DYN_TABLE_JOB_ENABLED =
            new PpcPropertyName<>("parse_hit_log_populate_dyn_table_job_enabled", BOOLEAN);

    /**
     * Список счетчиков Метрики, которые не нужно использовать при автозаполнении по урлу. В основном список содержит
     * различные метасчетчики, не предназначенные для использования обычными пользователями.
     */
    public static final PpcPropertyName<Set<Long>> METRIKA_COUNTER_IDS_EXCLUDED_FROM_AUTOCOMPLETE =
            new PpcPropertyName<>("metrika_counter_ids_excluded_from_autocomplete", LONG_SET);

    /**
     * Количество дней, в течение которых счетчик Метрики (из таблицы counter_by_domain)
     * считается актуальным -- его можно саджестить и использовать для автозаполнения.
     * Отсчет начинается с момента последнего появления счетчика в логах Метрики.
     */
    public static final PpcPropertyName<Integer> METRIKA_COUNTER_LIFETIME_IN_DAYS_FOR_AUTOCOMPLETE =
            new PpcPropertyName<>("metrika_counter_lifetime_in_days_for_autocomplete", INTEGER);

    /**
     * Нужно ли использовать новую таблицу счетчиков по домену
     * с ослабленными ограничениями на аудиторию (all_counters_by_domain) в саджесте
     */
    public static final PpcPropertyName<Boolean> METRIKA_COUNTER_USE_WEAK_RESTRICTIONS_FOR_SUGGESTION =
            new PpcPropertyName<>("metrika_counter_use_weak_restrictions_for_suggestion", BOOLEAN);

    /**
     * Количество дней, в течение которых счетчик Метрики (из таблицы all_counters_by_domain)
     * считается актуальным -- его можно саджестить и использовать для автозаполнения.
     * Отсчет начинается с момента последнего появления счетчика в логах Метрики.
     */
    public static final PpcPropertyName<Integer> METRIKA_COUNTER_WITH_WEAK_RESTRICTIONS_LIFETIME_IN_DAYS =
            new PpcPropertyName<>("metrika_counter_with_weak_restrictions_lifetime_in_days", INTEGER);

    /**
     * Включает синхронизацию фидов из Маркета.
     */
    public static final PpcPropertyName<Boolean> MARKET_FEEDS_SYNC_ENABLED =
            new PpcPropertyName<>("market_feeds_sync_enabled", BOOLEAN);

    /**
     * Сколько фидов выбирает {@code ppcFeedToBannerLand.pl} за запуск
     */
    public static final PpcPropertyName<Integer> BL_SELECT_CHUNK_SIZE =
            new PpcPropertyName<>("bl_select_chunk_size", INTEGER);

    /**
     * Сколько фидов отправляем в BL одновременно из {@code ppcFeedToBannerLand.pl}
     */
    public static final PpcPropertyName<Integer> BL_CHUNK_SIZE =
            new PpcPropertyName<>("bl_chunk_size", INTEGER);

    /**
     * После скольки ошибок больше не пытаться скачать ссылку на фид в {@code ppcFeedToBannerLand.pl}
     */
    public static final PpcPropertyName<Integer> BL_MAX_ERRORS_COUNT =
            new PpcPropertyName<>("bl_max_errors_count", INTEGER);

    /**
     * В {@code ppcFeedToBannerLand.pl} переобходим фиды со статусом Error через указанное количество дней
     */
    public static final PpcPropertyName<Integer> BL_RECHECK_INTERVAL_ERROR =
            new PpcPropertyName<>("bl_recheck_interval_error", INTEGER);

    /**
     * Свойство, хранящее время последнего импорта данных по клиентам, которые могут включить себе автоовердрафт.
     * Используется  джобой {@code autooverdraft.AutoOverdraftEmailSenderJob}
     */
    public static final PpcPropertyName<String> CLIENTS_CAN_ENABLE_AUTO_OVERDRAFT_LAST_UPLOAD_TIME =
            new PpcPropertyName<>("ClientsCanEnableAutoOverdraftEstimate", STRING);

    /**
     * В какую очередь БК перекладывать кампанию Дзена после создания
     */
    public static final PpcPropertyName<String> ZEN_BS_TRANSPORT_QUEUE_ON_CREATION =
            new PpcPropertyName<>("ZenBsTransportQueueOnCreation", STRING);

    /**
     * "Мягкий" таймаут в секундах для запросов в торги
     */
    public static final PpcPropertyName<Double> BS_AUCTION_SOFT_TIMEOUT_SECONDS =
            new PpcPropertyName<>("bs_auction_soft_timeout_seconds", DOUBLE);

    /**
     * Логировать повторные запросы в торги
     * Будет удалено в https://st.yandex-team.ru/DIRECT-124531
     */
    public static final PpcPropertyName<Boolean> BS_AUCTION_LOG_RETRY_REQUESTS =
            new PpcPropertyName<>("bs_auction_log_retry_requests", BOOLEAN);

    /**
     * Использовать отдельный клиент в торги для запросов из веба
     */
    public static final PpcPropertyName<Boolean> BS_AUCTION_USE_WEB_CLIENT =
            new PpcPropertyName<>("bs_auction_use_web_client", BOOLEAN);

    /**
     * Использовать пустую строку в качестве bids_phraseid_history при запросах в торги
     */
    public static final PpcPropertyName<Boolean> BS_AUCTION_IGNORE_PHRASEID_HISTORY =
            new PpcPropertyName<>("BS_AUCTION_IGNORE_PHRASEID_HISTORY", BOOLEAN);

    /**
     * Ограничение на кол-во запросов в минуту от приложения для api5-метода KeywordsResearch.hasSearchVolume
     */
    public static final PpcPropertyName<Integer> HAS_SEARCH_VOLUME_MAX_REQUESTS_BY_APPLICATION =
            new PpcPropertyName<>("has_search_volume_max_requests_by_application", INTEGER);

    /**
     * Флаг/фича для формы обратной связи https://st.yandex-team.ru/DIRECT-126681
     */
    public static final PpcPropertyName<Integer> CALLBACK_FORM_FOR_MAIN_PAGE =
            new PpcPropertyName<>("callback_form_for_main_page", PpcPropertyType.INTEGER);

    /**
     * Флаг/фича для чата на морде Директа https://st.yandex-team.ru/DIRECT-126682
     */
    public static final PpcPropertyName<Integer> SUPPORT_CHAT_FOR_MAIN_PAGE =
            new PpcPropertyName<>("support_chat_for_main_page", PpcPropertyType.INTEGER);

    /**
     * Какой процент новых пользователей с морды Директа нужно редиректить на лендинг из LPC,
     * По умолчанию 0.
     */
    public static final PpcPropertyName<Integer> MORDA_LANDING_PAGE_REDIRECT_PERCENT =
            new PpcPropertyName<>("morda_landing_page_redirect_percent", PpcPropertyType.INTEGER);

    /**
     * Какой процент новых пользователей с морды Директа нужно редиректить на лендинг из LPC,
     * По умолчанию false.
     */
    public static final PpcPropertyName<Boolean> MORDA_LANDING_PAGE_INTERNAL_REDIRECT =
            new PpcPropertyName<>("morda_landing_page_internal_redirect", BOOLEAN);

    /**
     * Какие шаблоны BannerStorage доступны для прайсовых кампаний.
     * По умолчанию [], что трактуется как без ограничений.
     */
    public static final PpcPropertyName<List<Long>> PRICE_PACKAGE_BS_TEMPLATE_WHITE_LIST =
            new PpcPropertyName<>("PRICE_PACKAGE_BS_TEMPLATE_WHITE_LIST", LONG_LIST);

    /**
     * Использовать только кластер seneca-sas при походе за статистикой в гридах
     */
    public static final PpcPropertyName<Boolean> USE_ONLY_SENECA_SAS_FOR_GRID_STATTISTIC =
            new PpcPropertyName<>("use_only_seneca_sas_for_grid_statistic", BOOLEAN);

    /**
     * Для получения статистики в гридах исползьовать YtCampaignStatSupport, выбирающий кластер в зависимости от
     * атрибута last_sync_time_bs-chevent-log
     */
    public static final PpcPropertyName<Boolean> USE_STAT_CLUSTER_CHOOSER_FOR_GRID_STATTISTIC =
            new PpcPropertyName<>("use_stat_cluster_chooser_for_grid_statistic", BOOLEAN);

    public static final PpcPropertyName<Boolean> CREATE_ORGANIZATION_METRIKA_COUNTER =
            new PpcPropertyName<>("create_organization_metrika_counter", PpcPropertyType.BOOLEAN);

    public static final PpcPropertyName<String> EXPORT_ADVQ_HITS_LAST_PROCESSED_WEEK_NUMBER =
            new PpcPropertyName<>("export_advq_hits_last_processed_week_number", STRING);

    /**
     * Настройки для расчётов рестарта автобюджета
     */
    public static final PpcPropertyName<Double> AUTOBUDGET_RESTART_AUTOBUDGET_AVG_BID_MARGIN =
            new PpcPropertyName<>("AUTOBUDGET_RESTART_AUTOBUDGET_AVG_BID_MARGIN", DOUBLE);
    public static final PpcPropertyName<Double> AUTOBUDGET_RESTART_AUTOBUDGET_AVG_CPM_MARGIN =
            new PpcPropertyName<>("AUTOBUDGET_RESTART_AUTOBUDGET_AVG_CPM_MARGIN", DOUBLE);
    public static final PpcPropertyName<Double> AUTOBUDGET_RESTART_AUTOBUDGET_AVG_CPA_MARGIN =
            new PpcPropertyName<>("AUTOBUDGET_RESTART_AUTOBUDGET_AVG_CPA_MARGIN", DOUBLE);
    public static final PpcPropertyName<Integer> AUTOBUDGET_RESTART_PAUSE_SECONDS_MARGIN =
            new PpcPropertyName<>("AUTOBUDGET_RESTART_PAUSE_SECONDS_MARGIN", INTEGER);
    public static final PpcPropertyName<Boolean> AUTOBUDGET_RESTART_SEND_TO_BS_ON_NEW_MONEY =
            new PpcPropertyName<>("AUTOBUDGET_RESTART_SEND_TO_BS_ON_NEW_MONEY", BOOLEAN);
    public static final PpcPropertyName<Boolean> CHECK_CASHBACK_ONLY_ON_NEW_MONEY =
            new PpcPropertyName<>("CHECK_CASHBACK_ONLY_ON_NEW_MONEY", BOOLEAN);
    public static final PpcPropertyName<Boolean> ACTIVE_ORDERS_RESEND_CHANGED_CAMPAIGNS =
            new PpcPropertyName<>("ACTIVE_ORDERS_RESEND_CHANGED_CAMPAIGNS", BOOLEAN);

    /**
     * Обработка сообщений от Телефонии об изменениях с номерами телефонов.
     */
    public static final PpcPropertyName<Boolean> TELEPHONY_SERVICE_NUMBER_ACTION_PROCESSING_ENABLED =
            new PpcPropertyName<>("telephony_service_number_action_processing_enabled", PpcPropertyType.BOOLEAN);

    /**
     * {@code true}, если нужно отрывать номера Телефонии, если баннеры не откручиваются.
     */
    public static final PpcPropertyName<Boolean> TELEPHONY_DETACHING_ENABLED =
            new PpcPropertyName<>("telephony_detaching_enabled", PpcPropertyType.BOOLEAN);

    /**
     * {@code true}, если нужно возвращать оторванные номера Телефонии, если баннеры вновь откручиваются.
     */
    public static final PpcPropertyName<Boolean> TELEPHONY_ATTACHING_ENABLED =
            new PpcPropertyName<>("telephony_attaching_enabled", PpcPropertyType.BOOLEAN);

    /**
     * {@code true}, если нужно высчитывать last_show_time и обновлять его у телефонов Телефонии
     * для коллтрекинга в ТГО и на сайте.
     */
    public static final PpcPropertyName<Boolean> TELEPHONY_CALC_LAST_SHOW_TIME_ENABLED =
            new PpcPropertyName<>("telephony_calc_last_show_time_enabled", PpcPropertyType.BOOLEAN);

    /**
     * Максимальное количество дней без откруток в БК, допустимое для привязки телефона Телефонии на баннере
     */
    public static final PpcPropertyName<Integer> MAX_DAYS_WITHOUT_SHOWS_FOR_ADV_TELEPHONY_PHONE =
            new PpcPropertyName<>("max_days_without_shows_for_adv_telephony_phone", INTEGER);

    /**
     * Максимальное количество дней без кликов и звонков, допустимое для привязки телефона Телефонии на сайте
     */
    public static final PpcPropertyName<Integer> MAX_DAYS_WITHOUT_ACTIONS_FOR_SITE_TELEPHONY_PHONE =
            new PpcPropertyName<>("max_days_without_actions_for_site_telephony_phone", INTEGER);

    /**
     * Момент последней успешной отработки джобы TelephonyCalcLastShowTimeJob
     */
    public static final PpcPropertyName<LocalDateTime> TELEPHONY_CALC_LAST_SHOW_TIME_JOB_LAST_TIME =
            new PpcPropertyName<>("telephony_calc_last_show_time_job_last_time", LOCAL_DATE_TIME);

    /**
     * Включено ли сохранение целей счетчиков кампании, при её обновлении в api
     */
    public static final PpcPropertyName<Boolean> SAVE_AVAILABLE_COUNTERS_GOALS_ON_CAMPAIGN_SAVING_IN_API =
            new PpcPropertyName<>("save_available_counters_goals_on_campaign_saving_in_api", BOOLEAN);

    /**
     * Использовать значения из camp_aggregated_lastchange в changes.checkCampaigns
     */
    public static final PpcPropertyName<Boolean> USE_CAMP_AGGREGATED_LASTCHANGE_PROPERTY =
            new PpcPropertyName<>("use_camp_aggregated_lastchange", BOOLEAN);

    /**
     * Число параллельно выполняемых запросов в api Метрики
     */
    public static final PpcPropertyName<Integer> NUMBER_OF_PARALLEL_REQUESTS_TO_METRIKA =
            new PpcPropertyName<>("number_of_parallel_requests_to_metrika", INTEGER);

    public static final PpcPropertyName<Boolean> SUPPRESS_METRIKA_ERRORS_IN_SHOW_STAT =
            new PpcPropertyName<>("suppress_metrika_errors_in_show_stat", BOOLEAN);

    /**
     * Флаг для выключения показа капчи по карме Паспорта
     */
    public static final PpcPropertyName<Boolean> DISABLE_KARMA_CAPTCHA =
            new PpcPropertyName<>("disable_karma_captcha", BOOLEAN);

    /**
     * Ограничение на число одновременных запросов.
     * Если значение > 0 — на каждый запрос будет взят семафор
     */
    public static final PpcPropertyName<Integer> DEFAULT_INLFY_REQUESTS_LIMIT =
            new PpcPropertyName<>("infly_requests_limit", INTEGER);

    /**
     * Показывать капчу при превышении числа одновременных запросов.
     */
    public static final PpcPropertyName<Boolean> INFLY_REQUESTS_SHOW_CAPTCHA =
            new PpcPropertyName<>("show_captcha_on_reached_requests_limit", BOOLEAN);

    /**
     * Флаг для выключения отпарвки писем и СМС о модерации кампаний
     */
    public static final PpcPropertyName<Boolean> DISABLE_MODERATION_NOTIFICATIONS =
            new PpcPropertyName<>("disable_moderation_notifications", BOOLEAN);

    /**
     * Флаг для выключения нового SQL-запроса для подсчета кампаний с активными баннерами
     */
    public static final PpcPropertyName<Boolean> ENABLE_NEW_CAMPS_HAS_ACTIVE_BANNERS_REQUEST =
            new PpcPropertyName<>("enable_new_camps_has_active_banners_request", BOOLEAN);

    /**
     * Максимальное число счетчиков в запросе /stat/v1/data?metrics=ym:s:productImpressions
     */
    public static final PpcPropertyName<Integer> MAX_COUNTERS_IN_PRODUCT_IMPRESSIONS =
            new PpcPropertyName<>("max_counters_in_product_impressions", INTEGER);

    public static final PpcPropertyName<Boolean> IS_NEW_REQWIZARD_ENABLED =
            new PpcPropertyName<>("IS_NEW_REQWIZARD_ENABLED", BOOLEAN);

    public static final PpcPropertyName<Integer> METRIKA_INTAPI_TIMEOUT_DURATION_SECONDS =
            new PpcPropertyName<>("metrika_intapi_timeout_duration_seconds", INTEGER);

    public static final PpcPropertyName<Integer> METRIKA_AUDIENCE_API_TIMEOUT_DURATION_SECONDS =
            new PpcPropertyName<>("metrika_audience_api_timeout_duration_seconds", INTEGER);

    public static final PpcPropertyName<Integer> METRIKA_API_TIMEOUT_DURATION_SECONDS =
            new PpcPropertyName<>("metrika_api_timeout_duration_seconds", INTEGER);

    /**
     * Список доменов запрещенных для подбора картинок
     */
    public static final PpcPropertyName<List<String>> DOMAIN_BLACKLIST_FOR_IMAGE_SEARCH =
            new PpcPropertyName<>("domain_blacklist_for_image_search", STRING_LIST);

    /**
     * Список доменов запрещенных для рекомендации быстрых ссылок
     */
    public static final PpcPropertyName<List<String>> DOMAIN_BLACKLIST_FOR_SITELINK_GENERATION =
            new PpcPropertyName<>("domain_blacklist_for_sitelink_generation", STRING_LIST);

    /**
     * Список доменов запрещенных для подбора текста по RCA
     */
    public static final PpcPropertyName<List<String>> DOMAIN_BLACKLIST_FOR_TEXT_RCA =
            new PpcPropertyName<>("domain_blacklist_for_text_rca", STRING_LIST);

    /**
     * Размер чанка для переотправки ресурсов баннера в БК
     */
    public static final PpcPropertyName<Long> RESYNC_BANNER_RESOURCES_CHUNK_SIZE =
            new PpcPropertyName<>("resync_banner_resources_chunk_size", LONG);

    /**
     * Время между итерациями при отправке ресурсов баннера в бк
     */
    public static final PpcPropertyName<Long> RESYNC_BANNER_RESOURCES_RELAX_TIME =
            new PpcPropertyName<>("resync_banner_resources_rerlax_time", LONG);

    /**
     * Размер чанка для переотправки кампании в БК
     */
    public static final PpcPropertyName<Long> RESYNC_CAMPAIGNS_CHUNK_SIZE =
            new PpcPropertyName<>("resync_campaigns_chunk_size", LONG);

    /**
     * Размер чанка для переотправки кц в справочник ключевых целей в /adv
     */
    public static final PpcPropertyName<Long> RESYNC_MEANINGFUL_GOALS_CHUNK_SIZE =
            new PpcPropertyName<>("resync_meaningful_goals_chunk_size", LONG);

    /**
     * Время между итерациями при отправке кампании в бк
     */
    public static final PpcPropertyName<Long> RESYNC_CAMPAIGNS_RELAX_TIME =
            new PpcPropertyName<>("resync_campaigns_relax_time", LONG);
    /**
     * Время между итерациями при отправке кц в справочник ключевых целей в /adv
     */
    public static final PpcPropertyName<Long> RESYNC_MEANINGFUL_GOALS_RELAX_TIME =
            new PpcPropertyName<>("resync_meaningful_goals_relax_time", LONG);

    /**
     * Размер чанка для переотправки стратегий в БК
     */
    public static final PpcPropertyName<Long> RESYNC_STRATEGIES_CHUNK_SIZE =
            new PpcPropertyName<>("resync_strategies_chunk_size", LONG);

    /**
     * Время между итерациями при отправке стратегий в БК
     */
    public static final PpcPropertyName<Long> RESYNC_STRATEGIES_RELAX_TIME =
            new PpcPropertyName<>("resync_strategies_relax_time", LONG);

    /**
     * Размер чанка для переотправки счетчиков метрики кампаний в бк
     */
    public static final PpcPropertyName<Long> RESYNC_METRIKA_COUNTERS_CHUNK_SIZE =
            new PpcPropertyName<>("resync_metrika_counters_chunk_size", LONG);

    /**
     * Время между итерациями при отправке счетчиков метрики кампаний в бк
     */
    public static final PpcPropertyName<Long> RESYNC_METRIKA_COUNTERS_RELAX_TIME =
            new PpcPropertyName<>("resync_metrika_counters_relax_time", LONG);

    public static final PpcPropertyName<Long> RESYNC_BIDDABLE_SHOW_CONDITIONS_CHUNK_SIZE =
            new PpcPropertyName<>("resync_biddable_show_conditions_chunk_size", LONG);
    public static final PpcPropertyName<Long> RESYNC_BIDDABLE_SHOW_CONDITIONS_RELAX_TIME =
            new PpcPropertyName<>("resync_biddable_show_conditions_relax_time", LONG);

    /**
     * Размер чанка для переотправки группы в БК
     */
    public static final PpcPropertyName<Long> RESYNC_AD_GROUPS_CHUNK_SIZE =
            new PpcPropertyName<>("resync_ad_groups_chunk_size", LONG);

    /**
     * Время между итерациями при отправке условий показа на группе в БК
     */
    public static final PpcPropertyName<Long> RESYNC_AD_GROUP_SHOW_CONDITIONS_RELAX_TIME =
            new PpcPropertyName<>("resync_ad_group_show_conditions_relax_time", LONG);

    /**
     * Размер чанка для переотправки условий показа на группе в БК
     */
    public static final PpcPropertyName<Long> RESYNC_AD_GROUP_SHOW_CONDITIONS_CHUNK_SIZE =
            new PpcPropertyName<>("resync_ad_group_show_conditions_chunk_size", LONG);

    /**
     * Время между итерациями при отправке группы в бк
     */
    public static final PpcPropertyName<Long> RESYNC_AD_GROUPS_RELAX_TIME =
            new PpcPropertyName<>("resync_ad_groups_relax_time", LONG);

    /**
     * Время между итерациями при удалении keywords из bids_base
     */
    public static final PpcPropertyName<Long> DELETE_KEYWORDS_FROM_BIDS_BASE_RELAX_TIME =
            new PpcPropertyName<>("delete_keywords_from_bids_base_relax_time", LONG);

    /**
     * Время между итерациями при удалении дублей баннеров ваншотом RemoveDuplicateBannersOneshot
     */
    public static final PpcPropertyName<Long> DELETE_DUPLICATE_BANNERS_AFTER_MIGRATION_TO_GRUT_RELAX_TIME =
            new PpcPropertyName<>("delete_duplicate_banners_after_migration_to_grut_relax_time", LONG);

    /**
     * Время между итерациями при добавлении в bids_phraseid_associate ваншотом
     */
    public static final PpcPropertyName<Long> INSERT_TO_BIDS_PHRASEID_ASSOCIATE_RELAX_TIME =
            new PpcPropertyName<>("insert_to_bids_phraseid_associate_relax_time", LONG);

    /**
     * Включение передачи хешей ассетов в транспорте БК
     */
    public static final PpcPropertyName<Boolean> SEND_ASSET_HASH_ENABLED =
            new PpcPropertyName<>("SEND_ASSET_HASH_ENABLED", BOOLEAN);

    /**
     * Включение передачи хешей ассетов в транспорте БК для всех типов UC/UAC кампаний, не только ТГО
     */
    public static final PpcPropertyName<Boolean> SEND_ASSET_HASH_INCLUDED_FOR_ALL_TYPES_ENABLED =
            new PpcPropertyName<>("SEND_ASSET_HASH_INCLUDED_FOR_ALL_TYPES_ENABLED", BOOLEAN);

    /**
     * Размер чанка id РМП кампаний для отправки в intapi ручку get-campaigns-asset-hashes
     */
    public static final PpcPropertyName<Integer> UAC_CAMPAIGNS_CHUNK_FOR_GETTING_ASSET_HASHES =
            new PpcPropertyName<>("UAC_CAMPAIGNS_CHUNK_FOR_GETTING_ASSET_HASHES", INTEGER);

    /**
     * Размер чанка id кампаний для отправки в intapi ручку get-campaigns-asset-hashes
     */
    public static final PpcPropertyName<Integer> CAMPAIGNS_CHUNK_FOR_GETTING_ASSET_HASHES =
            new PpcPropertyName<>("CAMPAIGNS_CHUNK_FOR_GETTING_ASSET_HASHES", INTEGER);

    /**
     * Размер чанка для ваншота по перепосылки ресурсов баннера из сортированной таблицы в очередь caesar
     */
    public static final PpcPropertyName<Integer> RESOURCES_SORTED_TABLE_TO_QUEUE_ONESHOT_CHUNK =
            new PpcPropertyName<>("oneshot_banner_resources_sorted_table_to_queue_chunk", INTEGER);
    /**
     * Размер чанка для ваншота по перепосылки групп из сортированной таблицы в очередь caesar
     */
    public static final PpcPropertyName<Integer> AD_GROUPS_SORTED_TABLE_TO_QUEUE_ONESHOT_CHUNK =
            new PpcPropertyName<>("oneshot_ad_groups_sorted_table_to_queue_chunk", INTEGER);
    /**
     * Размер чанка для ваншота по перепосылки условий показа из сортированной таблицы в очередь caesar
     */
    public static final PpcPropertyName<Integer> AD_GROUPS_SHOW_CONDITION_SORTED_TABLE_TO_QUEUE_ONESHOT_CHUNK =
            new PpcPropertyName<>("oneshot_ad_groups_show_condition_sorted_table_to_queue_chunk", INTEGER);

    /**
     * Размер чанка для джобы по перепосылки ресурсов баннера из сортированной таблицы в очередь caesar
     */
    public static final PpcPropertyName<Integer> BANNER_RESOURCES_SORTED_TABLE_TO_QUEUE_JOB_CHUNK =
            new PpcPropertyName<>("job_banner_resources_sorted_table_to_queue_chunk", INTEGER);
    /**
     * Длительность паузы для джобы по перепосылки ресурсов баннера из сортированной таблицы в очередь caesar
     */
    public static final PpcPropertyName<Integer> BANNER_RESOURCES_SORTED_TABLE_TO_QUEUE_JOB_RELAX_TIME =
            new PpcPropertyName<>("job_banner_resources_sorted_table_to_queue_relax_time", INTEGER);

    /**
     * Размер чанка для джобы по перепосылки групп из сортированной таблицы в очередь caesar
     */
    public static final PpcPropertyName<Integer> AD_GROUPS_SORTED_TABLE_TO_QUEUE_JOB_CHUNK =
            new PpcPropertyName<>("job_ad_groups_sorted_table_to_queue_chunk", INTEGER);

    /**
     * Длительность паузы для джобы по перепосылки групп из сортированной таблицы в очередь caesar
     */
    public static final PpcPropertyName<Integer> AD_GROUPS_SORTED_TABLE_TO_QUEUE_JOB_RELAX_TIME =
            new PpcPropertyName<>("job_ad_groups_sorted_table_to_queue_relax_time", INTEGER);


    /**
     * Размер чанка для джобы по перепосылки условий показа из сортированной таблицы в очередь caesar
     */
    public static final PpcPropertyName<Integer> AD_GROUPS_SHOW_CONDITION_TABLE_TO_QUEUE_JOB_CHUNK =
            new PpcPropertyName<>("job_ad_groups_show_condition_table_to_queue_chunk", INTEGER);

    /**
     * Длительность паузы для джобы по перепосылки условий показа из сортированной таблицы в очередь caesar
     */
    public static final PpcPropertyName<Integer> AD_GROUPS_SHOW_CONDITION_TABLE_TO_QUEUE_JOB_RELAX_TIME =
            new PpcPropertyName<>("job_ad_groups_show_condition_sorted_table_to_queue_relax_time", INTEGER);

    /**
     * Флаг для включения джобы импорта сегментов из Крипты для Custom Audience
     */
    public static final PpcPropertyName<Boolean> IMPORT_CRYPTA_SEGMENTS_FOR_CA_ENABLED =
            new PpcPropertyName<>("import_crypta_segmets_for_ca_enabled", BOOLEAN);

    /**
     * Флаг для включения джобы импорта данных по быстрым ссылкам
     */
    public static final PpcPropertyName<Boolean> IMPORT_SITELINKS_FROM_BNO_ENABLED =
            new PpcPropertyName<>("import_sitelinks_from_bno_enabled", BOOLEAN);

    /**
     * Список причин отклонения, по которым клиенты могут переотправлять баннеры на модерацию самостоятельно.
     **/
    public static final PpcPropertyName<Set<Long>> MODERATION_REASONS_ALLOWABLE_TO_REMODERATE_BY_CLIENT =
            new PpcPropertyName<>("moderation_reasons_allowable_to_remoderate_by_client", LONG_SET);

    /**
     * Использовать особые валидации для кампаний из uac и их элементов
     */
    public static final PpcPropertyName<Boolean> SPECIAL_VALIDATIONS_FOR_UAC =
            new PpcPropertyName<>("special_validations_for_uac", BOOLEAN);

    public static final PpcPropertyName<Boolean> IMPORT_CASHBACK_REWARDS_DETAILS_ENABLED =
            new PpcPropertyName<>("import_cashback_rewards_details_enabled", BOOLEAN);

    public static final PpcPropertyName<LocalDate> LAST_IMPORTED_CASHBACK_MONTH =
            new PpcPropertyName<>("last_imported_cashback_month", LOCAL_DATE);

    public static final PpcPropertyName<String> LAST_IMPORTED_CASHBACK_TABLE =
            new PpcPropertyName<>("last_imported_cashback_table", STRING);

    public static final PpcPropertyName<LocalDateTime> TRACE_LOG_CLICKHOUSE_MONITORING_DATE =
            new PpcPropertyName<>("trace_log_clickhouse_monitoring_date", PpcPropertyType.LOCAL_DATE_TIME);

    public static final PpcPropertyName<Integer> TRACE_LOG_MONITORING_LIMIT =
            new PpcPropertyName<>("trace_log_monitoring_limit", INTEGER);

    public static final PpcPropertyName<Integer> TRACE_LOG_LOGBROKER_MONITORING_LIMIT =
            new PpcPropertyName<>("trace_log_logbroker_monitoring_limit", INTEGER);

    public static final PpcPropertyName<Integer> TRACE_LOG_LOGBROKER_MONITORING_NOT_FULL_SIZE =
            new PpcPropertyName<>("trace_log_logbroker_monitoring_not_full_size", INTEGER);

    public static final PpcPropertyName<Integer> TRACE_LOG_MONITORING_SLEEP_TIME_MS =
            new PpcPropertyName<>("trace_log_monitoring_sleep_time_ms", INTEGER);

    public static final PpcPropertyName<List<String>> SUGGEST_REGION_SOURCES =
            new PpcPropertyName<>("suggest_region_sources", STRING_LIST);

    public static final PpcPropertyName<List<Integer>> SUGGEST_REGION_TYPES =
            new PpcPropertyName<>("suggest_region_types", INT_LIST);

    public static final PpcPropertyName<Map<String, Double>> SUGGEST_REGION_WEIGHT_MULTIPLIER_BY_SOURCE =
            new PpcPropertyName<>("suggest_region_weight_multiplier_by_source", STRING_TO_DOUBLE_MAP);

    public static final PpcPropertyName<Map<Integer, Map<String, Double>>>
            SUGGEST_REGION_WEIGHT_MULTIPLIER_BY_TYPE_AND_SOURCE = new PpcPropertyName<>(
            "suggest_region_weight_multiplier_by_type_and_source", INTEGER_TO_STRING_TO_DOUBLE_MAP);

    public static final PpcPropertyName<LocalDate> MISPRINT_FIXLIST_LAST_IMPORT_DATE =
            new PpcPropertyName<>("misprint_fixlist_last_import_date", LOCAL_DATE);

    public static final PpcPropertyName<Boolean> CORRECT_REGISTER_FOR_SUGGESTS =
            new PpcPropertyName<>("correct_register_for_suggests", BOOLEAN);

    public static final PpcPropertyName<String> PPC_MONEY_OUT_REMINDER_PROGRESS =
            new PpcPropertyName<>("ppcMoneyOutReminder_progress", STRING);

    /**
     * Размер чанка для удаления корректировок из конверсионных кампаний
     */
    public static final PpcPropertyName<Long> CLEAN_CONVERSION_BID_MODIFIERS_CHUNK_SIZE =
            new PpcPropertyName<>("clean_conversion_bid_modifiers_chunk_size", LONG);

    /**
     * Время между итерациями удаления корректировок из конверсионных кампаний
     */
    public static final PpcPropertyName<Long> CLEAN_CONVERSION_BID_MODIFIERS_RELAX_TIME =
            new PpcPropertyName<>("clean_conversion_bid_modifiers_relax_time", LONG);

    /*
     * Размер чанка для ваншота перекладывающего кампании в стратегии.
     * */
    public static final PpcPropertyName<Long> CAMPAIGN_TO_PACKAGE_STRATEGY_MIGRATION_CHUNK_SIZE =
            new PpcPropertyName<>("campaign_to_package_strategy_migration_chunk_size", LONG);

    /*
     * Время между итерациями ваншота перекладывающего кампании в стратегии в секундах.
     * */
    public static final PpcPropertyName<Long> CAMPAIGN_TO_PACKAGE_STRATEGY_MIGRATION_RELAX_TIME =
            new PpcPropertyName<>("campaign_to_package_strategy_migration_relax_time", LONG);

    /**
     * Максимальный возраст очереди копирования кампаний
     */
    public static final PpcPropertyName<Long> CAMP_OPERATIONS_QUEUE_COPY_AGE_LIMIT_HOURS =
            new PpcPropertyName<>("camp_operations_queue_copy_age_limit_hours", LONG);

    /**
     * Максимальный возраст очереди aggr_statuses_resync_queue
     */
    public static final PpcPropertyName<Long> AGGR_STATUSES_RESYNC_QUEUE_AGE_LIMIT_MINUTES =
            new PpcPropertyName<>("aggr_statuses_resync_queue.limit.minutes", LONG);

    /**
     * Использовать gozora вместо zora online
     */
    public static final PpcPropertyName<Boolean> USE_GO_ZORA = new PpcPropertyName<>("use_go_zora", BOOLEAN);

    /**
     * Нужно ли пересчитать агрегированные статусы универсальной кампании после ее создания/редактирования
     */
    public static final PpcPropertyName<Boolean> RECALCULATE_AGGREGATED_STATUSES_ON_SAVE_UC =
            new PpcPropertyName<>("recalculate_aggregated_statuses_on_save_uc", BOOLEAN);

    /**
     * Использовать в комплексной превалидации обновления uc новые баннеры вместо существующих
     */
    public static final PpcPropertyName<Boolean> USE_BANNERS_ADD_UAC_TGO_UPDATE_PREVALIDATION =
            new PpcPropertyName<>("use_banners_add_uac_tgo_update_prevalidation", BOOLEAN);

    /**
     * Нужно ли пересчитать агрегированные статусы универсальной кампании после смены статуса
     */
    public static final PpcPropertyName<Boolean> RECALCULATE_AGGREGATED_STATUSES_ON_UPDATE_STATUS_UC =
            new PpcPropertyName<>("recalculate_aggregated_statuses_on_update_status_uc", BOOLEAN);

    /**
     * Использовать intapi-ручку Метрики для получения количества конверсий целей счетчиков
     */
    public static final PpcPropertyName<Boolean> USE_INT_API_METRIKA_FOR_GOAL_CONVERSIONS_COUNT =
            new PpcPropertyName<>("use_int_api_metrika_for_goal_conversions_count", BOOLEAN);

    /**
     * Отключить пессимизацию обработки заданий в moderate_export_queue
     */
    public static final PpcPropertyName<Boolean> MODERATE_EXPORT_DISABLE_PESSIMIZATION =
            new PpcPropertyName<>("moderate_export_disable_pessimization", BOOLEAN);

    /**
     * Параметр max_subqueries для запроса за статистикой в БК на сенеках. Используется в ActiveOrderImportJob
     * see https://st.yandex-team.ru/YTADMINREQ-18749
     */
    public static final PpcPropertyName<Integer> ORDER_STAT_MAX_SUBQUERIES =
            new PpcPropertyName<>("order_stat_max_subqueries", INTEGER);

    /**
     * Кластеры, на которых не должен запускаться запрос для OrderStat
     */
    public static final PpcPropertyName<Set<String>> ORDER_STAT_DISABLED_CLUSTERS =
            new PpcPropertyName<>("order_stat_disabled_clusters", STRING_SET);

    /**
     * Конфигурация дополнительных воркеров, обрабатывающих очередь копирования кампаний
     * DIRECT-141900
     */
    public static final PpcPropertyName<Map<String, String>> CAMP_COPY_QUEUE_ADDITIONAL_WORKERS =
            new PpcPropertyName<>("camp_copy_queue_additional_workers", STRING_TO_STRING_MAP_JSON);

    /**
     * Ограничение на количество вердиктов, буферизуемых перед передачей в обработку
     */
    public static final PpcPropertyName<Integer> ESS_MODERATION_LOGBROKER_READER_ROWS_LIMIT =
            new PpcPropertyName<>("ess_moderation_logbroker_reader_rows_limit", INTEGER);

    /**
     * Задание разгрузочных коэффициентов для обработчиков очереди копирования кампаний
     * DIRECT-141900
     */
    public static final PpcPropertyName<Map<String, String>> CAMP_COPY_QUEUE_SLEEP_COEF =
            new PpcPropertyName<>("camp_copy_queue_sleep_coef", STRING_TO_STRING_MAP_JSON);

    /**
     * Маппинг кампаний в слоты SkAdNetwork. Временное решение для проверки механизмов в БК.
     * Подлежит выпиливанию после реализации https://st.yandex-team.ru/DIRECT-142444
     */
    public static final PpcPropertyName<Map<Long, Long>> DIRECT_CID_TO_SKADNETWORK_CAMPAIGN_ID =
            new PpcPropertyName<>("direct_cid_to_skadnetwork_campaign_id", LONG_TO_LONG_MAP);

    /**
     * Кол-во слотов SKAdNetwork (возможных SKAdNetworkCampaignID) на приложение
     */
    public static final PpcPropertyName<Integer> SKADNETWORK_APP_SLOTS_NUMBER =
            new PpcPropertyName<>("skadnetwork_app_slots_number", INTEGER);

    /**
     * Включить запись value кц, как строчки
     */
    public static final PpcPropertyName<Boolean> MEANINGFUL_GOAL_VALUE_SERIALIZE_AS_STRING =
            new PpcPropertyName<>("meaningful_goal_value_serialize_as_string", BOOLEAN);

    /**
     * Проперти для увеличения лимита длины текста баннера
     */
    public static final PpcPropertyName<Boolean> INCREASE_AD_TEXT_LIMITS =
            new PpcPropertyName<>("increase_ad_text_limits", BOOLEAN);
    /**
     * Проперти, которая включает выполнение MoneyOutReminderJob и отключает скрипт ppcMoneyOutReminder.pl
     * соответственно
     */
    public static final PpcPropertyName<Boolean> MONEY_OUT_REMINDER_JOB_ON =
            new PpcPropertyName<>("money_out_reminder_job_on", BOOLEAN);

    /**
     * Проперти для получения стастистики для UC из YT вместо БК
     */
    public static final PpcPropertyName<Boolean> USE_YT_STATISTICS_FOR_UC =
            new PpcPropertyName<>("use_yt_statistics_for_uc", BOOLEAN);

    /**
     * Для джобы UpdateConversionLevelForMetrikaGoalsJob
     * Хранит время последнего полного обновления conversion_level в metrika_goals из таблицы в yt (GoalQuality)
     */
    public static final PpcPropertyName<LocalDateTime> GOAL_QUALITY_CONVERSION_LEVEL_LAST_UPDATE_TIME =
            new PpcPropertyName<>("goal-quality-conversion-level-last-update-time",
                    PpcPropertyType.LOCAL_DATE_TIME);

    /**
     * Для джобы UpdateConversionLevelForMetrikaGoalsJob
     * Хранит текущее количество попыток полного обновления conversion_level из таблицы GoalQuality
     */
    public static final PpcPropertyName<Integer> ATTEMPT_NUMBER_FOR_FULL_UPDATE_CONVERSION_LEVEL =
            new PpcPropertyName<>("attempt-number-for-full-update-conversion-level",
                    INTEGER);

    /**
     * Для джобы UpdateConversionLevelForMetrikaGoalsJob
     * Максимальное количество записей для обновления за один запуск джобы
     */
    public static final PpcPropertyName<Long> CONVERSION_LEVEL_UPDATE_LIMIT =
            new PpcPropertyName<>("conversion_level_update_limit",
                    LONG);

    /**
     * Для джобы ClientsFeaturesChangesLogJob
     * Хранит идентификаторы фич, для которых не нужно писать комментарии в тикеты
     */
    public static final PpcPropertyName<List<Long>> CLIENTS_FEATURES_CHANGES_LOG_JOB_IGNORED_FEATURES_IDS =
            new PpcPropertyName<>("features_bin_logs_reader.clients_features_ignored_features_ids", LONG_LIST);

    /**
     * Для джобы SendEcomDomainToMBIJob
     * Определяет минимальное количество офферов, для отправки доменов из ppcdict.ecom_domains в MBI
     */
    public static final PpcPropertyName<Long> MIN_OFFERS_COUNT_BY_HOST_FOR_SEND_TO_MBI =
            new PpcPropertyName<>("min_offers_count_by_host_for_send_to_mbi", LONG);

    /**
     * Параллельная обработка при вычисление агрегированных статусов
     */
    public static final PpcPropertyName<Boolean> AGGREGATED_STATUS_PARALLEL =
            new PpcPropertyName<>("AGGREGATED_STATUS_PARALLEL", PpcPropertyType.BOOLEAN);

    public static final PpcPropertyName<Boolean> ENABLE_CALCULATION_LACK_OF_CONVERSION_AGGREGATED_STATUS =
            new PpcPropertyName<>("aggregated_status.enable_calculation_lack_of_conversion", PpcPropertyType.BOOLEAN);

    /**
     * Какое количество видео будет отправляться на переконвертацию за раз
     */
    public static final PpcPropertyName<Integer> CMS_VIDEO_RETRANSCODE_BATCH_SIZE =
            new PpcPropertyName<>("CMS_VIDEO_RETRANSCODE_BATCH_SIZE", INTEGER);

    /**
     * Через такое количество дней закешированные ответы на нерасшаренные запросы логвьюера могут быть удалены
     */
    public static final PpcPropertyName<Integer> DAYS_TO_LIVE_OF_RESPONSE_FOR_NOT_SHARED_LOGVIEWER_QUERY =
            new PpcPropertyName<>("days_to_live_of_response_for_not_shared_logviewer_query", INTEGER);

    /**
     * Через такое количество дней закешированные ответы на расшаренные запросы логвьюера могут быть удалены
     */
    public static final PpcPropertyName<Integer> DAYS_TO_LIVE_OF_RESPONSE_FOR_SHARED_LOGVIEWER_QUERY =
            new PpcPropertyName<>("days_to_live_of_response_for_shared_logviewer_query", INTEGER);

    /**
     * Отправлять уведомления active_orders_money_out через intapi-ручку (отправка через рассылятор)
     */
    public static final PpcPropertyName<Boolean> USE_INTAPI_FOR_ACTIVE_ORDERS_MONEY_OUT =
            new PpcPropertyName<>("use_intapi_for_active_orders_money_out", BOOLEAN);

    /**
     * Для внутреннего отчёта ess.sendcampaign.SendCampaignContentTool
     * Ограничение на количество отправленных объектов ESS, после превышения которого отчёт просит подождать
     */
    public static final String SEND_CAMPAIGNS_TO_ESS_TRANSPORT_OBJECTS_LIMIT_NAME =
            "send_campaigns_to_ess_transport_objects_limit";

    public static final PpcPropertyName<Integer> SEND_CAMPAIGNS_TO_ESS_TRANSPORT_OBJECTS_LIMIT =
            new PpcPropertyName<>(SEND_CAMPAIGNS_TO_ESS_TRANSPORT_OBJECTS_LIMIT_NAME, INTEGER);

    /**
     * Для внутреннего отчёта ess.sendcampaign.SendCampaignContentTool
     * Объект класса SendCampaignState, сериализованный в JSON. В нём записано количество объектов,
     * отправленное в последние N минут, и время начала этих самых N минут
     */
    public static final PpcPropertyName<String> SEND_CAMPAIGNS_TO_ESS_TRANSPORT_STATE =
            new PpcPropertyName<>("send_campaigns_to_ess_transport_state", STRING);


    /**
     * Для внутреннего отчёта ess.sendcampaign.Mysql2GrutResendTool
     * Ограничение на количество отправленных объектов ESS, после превышения которого отчёт просит подождать
     */
    public static final String MYSQL2GRUT_RESEND_OBJECTS_LIMIT_PROPERTY_NAME =
            "mysql2grut_resend_objects_limit";

    public static final PpcPropertyName<Integer> MYSQL2GRUT_RESEND_OBJECTS_LIMIT =
            new PpcPropertyName<>(MYSQL2GRUT_RESEND_OBJECTS_LIMIT_PROPERTY_NAME, INTEGER);

    /**
     * Для внутреннего отчёта ess.sendcampaign.Mysql2GrutResendTool
     * Объект класса SendCampaignState, сериализованный в JSON. В нём записано количество объектов,
     * отправленное в последние N минут, и время начала этих самых N минут
     */
    public static final PpcPropertyName<String> MYSQL2GRUT_RESEND_STATE =
            new PpcPropertyName<>("mysql2grut_resend_state", STRING);


    /**
     * JSON со списком клиентов, забаненных через ручку intapi
     * Используется для ограничения количества блокировок в сутки
     */
    public static final PpcPropertyName<String> BANNED_CLIENTS = new PpcPropertyName<>("banned_clients", STRING);

    /**
     * Если true то hasActiveBanners флаг для гридов будет считаться из агрегированного статуса кампании
     */
    public static final PpcPropertyName<Boolean> USE_CAMP_AGGR_STATUS_FOR_ACTIVE_BANNERS_FLAG =
            new PpcPropertyName<>("use_camp_aggr_status_for_active_banners_flag", BOOLEAN);
    public static final PpcPropertyName<Boolean> OPTIMIZE_CAMP_BANNERS_FLAGS =
            new PpcPropertyName<>("optimize_camp_banners_flags", BOOLEAN);

    /**
     * Максимальное кол-во баннеров в одной группе для UAC
     */
    public static final PpcPropertyName<Integer> MAX_BANNERS_IN_UAC_AD_GROUP =
            new PpcPropertyName<>("max_banners_in_uac_ad_group", INTEGER);

    /**
     * Максимальное кол-во баннеров в одной группе для UC(ТГО)
     */
    public static final PpcPropertyName<Integer> MAX_BANNERS_IN_UAC_TEXT_AD_GROUP =
            new PpcPropertyName<>("max_banners_in_uac_text_ad_group", INTEGER);

    /**
     * Смотрим статистику по ассетам не раньше заданной в проперти даты
     * Это дата миграции всех хешей ассетов в БК. До нее хеши уже были в БК но в не полном составе
     */
    public static final PpcPropertyName<Long> START_SEARCH_STATS_FROM_DATE_FOR_UAC =
            new PpcPropertyName<>("start_search_stats_from_date_for_uac", LONG);

    /**
     * Не восстанавливать удаленные ассеты в UAC TGO
     */
    public static final PpcPropertyName<Boolean> DO_NOT_RESTORE_REMOVED_ASSETS_IN_UAC_TGO =
            new PpcPropertyName<>("do_not_restore_removed_assets_in_uac_tgo", BOOLEAN);

    /**
     * Не показывать клиенту историю изменений баннеров в uac кампаниях
     */
    public static final PpcPropertyName<Boolean> FILTER_UAC_BANNERS_IN_ALW =
            new PpcPropertyName<>("filter_uac_banners_in_alw", BOOLEAN);

    /**
     * Меняем статус ассетов с rejected на created на выдачу фронту, если прошло меньше указанного здесь времени с
     * начала его создания (в секундах). Для временного костыля
     */
    public static final PpcPropertyName<Integer> CHANGE_REJECTED_ASSET_TO_CREATED_WITH_SECONDS_SHIFT =
            new PpcPropertyName<>("change_rejected_asset_to_created_with_seconds_shift", INTEGER);

    /**
     * Включение таргетирования по интересам в uac-кампаниях
     */
    public static final PpcPropertyName<Boolean> UAC_TARGET_INTERESTS_ENABLED =
            new PpcPropertyName<>("uac_target_interests_enabled", BOOLEAN);

    /**
     * Включение таргетирования по интересам в uac-кампаниях
     */
    public static final PpcPropertyName<Boolean> SYNC_UAC_PHRASES_TO_STORAGE =
            new PpcPropertyName<>("sync_uac_phrases_to_storage", BOOLEAN);

    /**
     * Менять текст уведомления при обработке события money_warning_wallet в EventLog в зависимости
     * от наличия параметра days_left
     */
    public static final PpcPropertyName<Boolean> CHANGE_NOTIFICATION_MESSAGES_FOR_DAYS_WARNING_WALLET =
            new PpcPropertyName<>("CHANGE_NOTIFICATION_MESSAGES_FOR_DAYS_WARNING_WALLET", BOOLEAN);

    /**
     * Для Смарта по сайту. Список доменов для которых нельзя заводить смарт по сайту
     */
    public static final PpcPropertyName<Set<String>> DOMAINS_NOT_ALLOWED_FOR_FEED_FROM_SITE =
            new PpcPropertyName<>("domains_not_allowed_for_feed_from_site", STRING_SET);

    /**
     * Список доменов, для которых не саджестим счетчики без доступа
     */
    public static final PpcPropertyName<Set<String>> DOMAINS_NOT_ALLOWED_FOR_UNAVAILABLE_COUNTERS =
            new PpcPropertyName<>("domains_not_allowed_for_unavailable_counters", STRING_SET);

    /**
     * Для Товарных кампаний. Список доменов, который мы считаем маркетплейсами
     */
    public static final PpcPropertyName<Set<String>> MARKETPLACE_DOMAINS =
            new PpcPropertyName<>("marketplace_domains", STRING_SET);

    /**
     * Должна ли джоба SetCampDayBudgetLimitStopTimeJob писать изменения в базу вместо perl,
     * или же только помечать прочитанное
     */
    public static final PpcPropertyName<Boolean> CAMP_DAY_BUDGET_LIMIT_STOP_TIME_JAVA_WRITING_ENABLED =
            new PpcPropertyName<>("campdaybudgetlimitstoptime_java_writing_enabled", BOOLEAN);

    /**
     * Запущена ли джоба PopulateSuggestConversionPriceDynTableJob, импортирующая статическую таблицу
     * с рекомендуемой ценой конверсии в динамическую.
     */
    public static final PpcPropertyName<Boolean> POPULATE_SUGGEST_CONVERSION_PRICE_DYN_TABLE_JOB_ENABLED =
            new PpcPropertyName<>("populate_suggest_conversion_price_dyn_table_job_enabled", BOOLEAN);

    /**
     * Использовать gozora при загрузке картинок по url для API сервиса Images
     */
    public static final PpcPropertyName<Boolean> USE_GOZORA_IN_PROCESS_IMAGES_QUEUE =
            new PpcPropertyName<>("use_gozora_in_process_images_queue", BOOLEAN);

    /**
     * Для джобы PopulateSuggestConversionPriceDynTableJob. Последняя успешная дата обновления таблицы
     * с рекомендуемой ценой конверсии.
     */
    public static final PpcPropertyName<LocalDate> LAST_SUCCESSFUL_SUGGEST_CONVERSION_PRICE_UPDATE_DATE =
            new PpcPropertyName<>("last_successful_suggest_conversion_price_update_date", LOCAL_DATE);

    /**
     * Показывать статистику по недоступным целям в МОЛ/МОК
     */
    public static final PpcPropertyName<Boolean> SHOW_STATS_BY_UNAVAILABLE_GOALS_IN_MOL =
            new PpcPropertyName<>("show_stats_by_unavailable_goals_in_mol", BOOLEAN);

    /**
     * Пропертя, показывающая, доступен ли GrUT для запросов. Нужна для переключение кабинетов с ydb на GrUT
     */
    public static final PpcPropertyName<Boolean> IS_GRUT_ENABLED =
            new PpcPropertyName<>("is_grut_enabled", BOOLEAN);

    /**
     * Свойства, включающие новую логику рестартра автобюджета CPA по кампаниям или на процент
     */
    public static final PpcPropertyName<Set<Long>> ENABLE_NEW_CPA_AUTOBUDGET_RESTART_LOGIC_ORDERIDS =
            new PpcPropertyName<>("ENABLE_NEW_CPA_AUTOBUDGET_RESTART_LOGIC_ORDERIDS", LONG_SET);

    public static final PpcPropertyName<Integer> ENABLE_NEW_CPA_AUTOBUDGET_RESTART_LOGIC_PERCENT =
            new PpcPropertyName<>("ENABLE_NEW_CPA_AUTOBUDGET_RESTART_LOGIC_PERCENT", INTEGER);

    /**
     * Пропертя, показывающая, использовать ли YP для резолвинга бэкендов GrUT'а. Нужна для переключения походов в GrUT
     * с балансера на YP
     */
    public static final PpcPropertyName<Boolean> IS_GRUT_BACKENDS_VIA_YP_ENABLED =
            new PpcPropertyName<>("is_grut_backends_via_yp_enabled", BOOLEAN);

    /**
     * Проперти для семплинга грутового трейса в егерь
     */
    public static final PpcPropertyName<Boolean> GRUT_TRACE_SAMPLING_ENABLED =
            new PpcPropertyName<>("grut_trace_sampling_enabled", BOOLEAN);

    /**
     * Обновлять кампании в репликаци в GRuT асинхронно
     */
    public static final PpcPropertyName<Boolean> GRUT_CAMP_REPL_ASYNC_UPDATE =
            new PpcPropertyName<>("grut_camp_repl_async_update", BOOLEAN);

    /**
     * Обновлять объекты в репликаци в GRuT асинхронно
     */
    public static final PpcPropertyName<Boolean> GRUT_REPL_ASYNC_UPDATE =
            new PpcPropertyName<>("grut_repl_async_update", BOOLEAN);

    /**
     * Включить ли в репликации кампаний расчет автобюджета
     */
    public static final PpcPropertyName<Integer> GRUT_CAMP_REPL_CALC_AUTOBUDGET_RESTART_PERCENT =
            new PpcPropertyName<>("grut_camp_repl_calc_autobudget_restart_percent", INTEGER);

    // <ESS over GrUT>

    /**
     * Проперти для чтения грутового вотчлога в ESS
     */
    public static final PpcPropertyName<Boolean> GRUT_READ_WATCHLOG_IN_ESS =
            new PpcPropertyName<>("grut_read_watchlog_in_ess", BOOLEAN);

    /**
     * Проперти для записи грутовых событий в ESS
     */
    public static final PpcPropertyName<Boolean> GRUT_WRITE_WATCHLOG_IN_ESS =
            new PpcPropertyName<>("grut_write_watchlog_in_ess", BOOLEAN);

    /**
     * Количество чтение вотчлога в ESS до коммита
     */
    public static final PpcPropertyName<Integer> GRUT_WATCHLOG_ITERATIONS_BEFORE_COMMIT =
            new PpcPropertyName<>("grut_watchlog_iterations_before_commit", INTEGER);

    /**
     * Время обработки вотчлога в ESS
     */
    public static final PpcPropertyName<Long> ESS_WATCHLOG_PROCESSING_TIMEOUT_SEC =
            new PpcPropertyName<>("ess_watchlog_processing_timeout_sec", LONG);

    /**
     * Проперти для включения процессоров обработки вотчлога
     */
    public static final PpcPropertyName<Boolean> WATCHLOGBROKER_BANNER_CANDIDATE_PROCESSOR_ENABLED =
            new PpcPropertyName<>("watchlogbroker_banner_candidate_processor_enabled", BOOLEAN);
    public static final PpcPropertyName<Boolean> WATCHLOGBROKER_CAMPAIGN_PROCESSOR_ENABLED =
            new PpcPropertyName<>("watchlogbroker_campaign_processor_enabled", BOOLEAN);

    /**
     * Использовать данные баннеров из грута для вычисления агрегированных статусов
     */
    public static final PpcPropertyName<Boolean> FETCH_DATA_FROM_GRUT_FOR_AGGR_STATUSES =
            new PpcPropertyName<>("fetch_data_from_grut_for_aggr_statuses", BOOLEAN);
    /**
     * Использовать данные баннеров из грута для вычисления camp_aggregated_lastchange
     */
    public static final PpcPropertyName<Boolean> FETCH_DATA_FROM_GRUT_FOR_CAMP_AGGREGATED_LASTCHANGE =
            new PpcPropertyName<>("fetch_data_from_grut_for_camp_aggregated_lastchange", BOOLEAN);
    /**
     * Обрабатывать вотчлог ивенты в UacUpdateStatusesProcessor
     */
    public static final PpcPropertyName<Boolean> PROCESS_WATCHLOG_IN_UAC_PROCESSOR =
            new PpcPropertyName<>("process_watchlog_in_uac_processor", BOOLEAN);
    /**
     * Использовать данные баннеров из грута для вычисления статусов ассет линков
     */
    public static final PpcPropertyName<Boolean> FETCH_DATA_FROM_GRUT_FOR_ASSET_LINK_STATUSES =
            new PpcPropertyName<>("fetch_data_from_grut_for_asset_link_statuses", BOOLEAN);

    // </ESS over GrUT>

    /**
     * Проперти для отключения репликации объектов в шардах
     */
    public static final PpcPropertyName<Set<Integer>> GRUT_SKIP_CAMPAIGNS_REPLICATION_SHARDS =
            new PpcPropertyName<>("grut_skip_campaigns_replication_shards", SHARDS_SET);

    public static final PpcPropertyName<Set<Integer>> GRUT_SKIP_ADGROUPS_REPLICATION_SHARDS =
            new PpcPropertyName<>("grut_skip_adgroups_replication_shards", SHARDS_SET);

    public static final PpcPropertyName<Set<Integer>> GRUT_SKIP_BIDDABLE_SHOW_CONDITION_REPLICATION_SHARDS =
            new PpcPropertyName<>("grut_skip_biddable_show_condition_replication_shards", SHARDS_SET);

    public static final PpcPropertyName<Set<Integer>> GRUT_SKIP_BID_MODIFIERS_REPLICATION_SHARDS =
            new PpcPropertyName<>("grut_skip_bid_modifiers_replication_shards", SHARDS_SET);

    public static final PpcPropertyName<Set<Integer>> GRUT_SKIP_VCARDS_REPLICATION_SHARDS =
            new PpcPropertyName<>("grut_skip_vcards_replication_shards", SHARDS_SET);

    public static final PpcPropertyName<Set<Integer>> GRUT_SKIP_CREATIVES_REPLICATION_SHARDS =
            new PpcPropertyName<>("grut_skip_creatives_replication_shards", SHARDS_SET);

    public static final PpcPropertyName<Set<Integer>> GRUT_SKIP_MINUS_PHRASES_REPLICATION_SHARDS =
            new PpcPropertyName<>("grut_skip_minus_phrases_replication_shards", SHARDS_SET);

    public static final PpcPropertyName<Set<Integer>> GRUT_SKIP_MOBILE_CONTENT_REPLICATION_SHARDS =
            new PpcPropertyName<>("grut_skip_mobile_content_replication_shards", SHARDS_SET);

    public static final PpcPropertyName<Set<Integer>> GRUT_SKIP_RETARGETING_CONDITION_REPLICATION_SHARDS =
            new PpcPropertyName<>("grut_skip_retargeting_condition_replication_shards", SHARDS_SET);

    public static final PpcPropertyName<Set<Integer>> GRUT_SKIP_BANNERS_REPLICATION_SHARDS =
            new PpcPropertyName<>("grut_skip_banners_replication_shards", SHARDS_SET);

    public static final PpcPropertyName<Set<Integer>> GRUT_SKIP_STRATEGIES_REPLICATION_SHARDS =
            new PpcPropertyName<>("grut_skip_strategies_replication_shards", SHARDS_SET);

    /**
     * Заполнять ли в группах id bids
     * Проперти нужна, чтобы иметь возможность залить все группы не дожидаясь заливки biddable_show_conditions
     */
    public static final PpcPropertyName<Boolean> GRUT_AD_GROUPS_FILL_BIDDABLE_SHOW_CONDITIONS =
            new PpcPropertyName<>("grut_ad_groups_fill_biddable_show_conditions", BOOLEAN);

    /**
     * Размер батч-запросов на вставку/обновление объектов в репликации
     */
    public static final PpcPropertyName<Integer> GRUT_REPLICATION_CREATE_OR_UPDATE_BATCH_SIZE =
            new PpcPropertyName<>("grut_replication_create_or_update_batch_size", INTEGER);

    /**
     * Размер батч-запросов на получение объектов в репликации
     */
    public static final PpcPropertyName<Integer> GRUT_REPLICATION_GET_BATCH_SIZE =
            new PpcPropertyName<>("grut_replication_get_batch_size", INTEGER);

    /**
     * Размер чанка для асинхронной загрузки (через ExecuterService) баннеров из базы
     */
    public static final PpcPropertyName<Integer> GRUT_REPLICATION_BANNERS_DB_LOAD_CHUNK_SIZE =
            new PpcPropertyName<>("grut_replication_banners_db_load_chunk_size", INTEGER);

    /**
     * Размер чанка для асинхронной загрузки (через ExecuterService) кампаний из базы
     */
    public static final PpcPropertyName<Integer> GRUT_REPLICATION_CAMPAIGNS_DB_LOAD_CHUNK_SIZE =
            new PpcPropertyName<>("grut_replication_campaigns_db_load_chunk_size", INTEGER);

    /**
     * Размер чанка для асинхронного расчета рестарта автобюджета (через ExecuterService)
     */
    public static final PpcPropertyName<Integer> GRUT_REPLICATION_CALC_AUTOBUDGET_RESTART_CHUNK_SIZE =
            new PpcPropertyName<>("grut_replication_calc_autobudget_restart_chunk_size", INTEGER);

    /**
     * Размер батч-запросов на удаление объектов в репликации
     */
    public static final PpcPropertyName<Integer> GRUT_REPLICATION_DELETE_BATCH_SIZE =
            new PpcPropertyName<>("grut_replication_delete_batch_size", INTEGER);


    /**
     * Пропускать ошибки при записи в GrUT:
     * Provided parent key ... is different from existing
     * Используется разблокировки репликации на тестингe.
     */
    public static final PpcPropertyName<Boolean> GRUT_SKIP_WRONG_PARENT_KEY_ERRORS =
            new PpcPropertyName<>("grut_skip_wrong_parent_key_errors", BOOLEAN);

    /**
     * Флаг, влкючающий дополнительное условие для отправки Rejected баннера в БК
     */
    public static final PpcPropertyName<Boolean> BS_TRANSPORT_STOP_REJECTED_BANNERS =
            new PpcPropertyName<>("bs_transport_stop_rejected_banners", BOOLEAN);

    /**
     * Флаг, меняющий отправку поля DAY_WEIGHT в транспорте в бк при отсутвии тайм таргетинга
     */
    public static final PpcPropertyName<Boolean> BS_TRANSPORT_CHANGE_DAY_WEIGHT =
            new PpcPropertyName<>("bs_transport_change_day_weight", BOOLEAN);

    /**
     * Флаг, включающий отправку в БК картиночного баннера в одном родительском баннере. Иначе
     * отправляется в двух - картиночном и бескартиночном)
     */
    public static final PpcPropertyName<Boolean> SINGLE_IMAGE_AD_TO_BS_ENABLED =
            new PpcPropertyName<>("SINGLE_IMAGE_AD_TO_BS_ENABLED", BOOLEAN);

    /**
     * Список id кампаний для которых будет включена отправка в БК картиночного баннера в одном
     * родительском баннере. Не работает без включения SINGLE_IMAGE_AD_TO_BS_ENABLED
     */
    public static final PpcPropertyName<Set<Long>> SINGLE_IMAGE_AD_TO_BS_FOR_CIDS =
            new PpcPropertyName<>("SINGLE_IMAGE_AD_TO_BS_FOR_CIDS", LONG_SET);

    /**
     * Флаг, включающий скрытие дублирующих полей баннерной картинки, при отправке баннера только в родительском,
     * вместо двух (картиночной и безкартиночной)
     */
    public static final PpcPropertyName<Boolean> HIDE_DOUBLE_IMAGE_FIELDS_TO_BS_ENABLED =
            new PpcPropertyName<>("HIDE_DOUBLE_IMAGE_FIELDS_TO_BS_ENABLED", BOOLEAN);

    /**
     * Таймаут в миллисекундах между итерациями переотправки в БК картиночных баннеров в
     * старом формате (в картиночном и бескартиночном виде). Используется в ваншоте
     */
    public static final PpcPropertyName<Long> SINGLE_IMAGE_AD_TO_BS_IN_OLD_SCHEME_SLEEP
            = new PpcPropertyName<>("SINGLE_IMAGE_AD_TO_BS_IN_OLD_SCHEME_SLEEP", LONG);

    /**
     * Нужно ли передавать ключевые фразы в сервис рекомендаций запросов.
     */
    public static final PpcPropertyName<Boolean> KEYWORD_RECOMMENDATION_SERVICE_USE_KEYWORDS =
            new PpcPropertyName<>("keyword_recommendation_service_use_keywords", BOOLEAN);

    /**
     * Нужно ли передавать минус фразы в сервис рекомендаций запросов.
     */
    public static final PpcPropertyName<Boolean> KEYWORD_RECOMMENDATION_SERVICE_USE_MINUS_WORDS =
            new PpcPropertyName<>("keyword_recommendation_service_use_minus_words", BOOLEAN);

    public static final PpcPropertyName<Integer> UC_UAC_CONVERTER_CHUNK_SIZE
            = new PpcPropertyName<>("uc_uac_converter_chunk_size", INTEGER);

    public static final PpcPropertyName<Integer> GRUT_UAC_CONVERTER_CHUNK_SIZE
            = new PpcPropertyName<>("grut_uac_converter_chunk_size", INTEGER);

    /**
     * Размер чанка для ваншота
     */
    public static final PpcPropertyName<Integer> UC_UPDATE_ADS_CHUNK_SIZE
            = new PpcPropertyName<>("uc_update_ads_chunk_size", INTEGER);

    public static final PpcPropertyName<Long> UC_UPDATE_CAMPAIGN_TARGET_STATUS_IDLE_TIME
            = new PpcPropertyName<>("UC_UPDATE_CAMPAIGN_TARGET_STATUS_IDLE_TIME", LONG);

    /**
     * Параметры для вызова Direct::Feature::get_abt_info из showDna (Perl)
     * см. также https://st.yandex-team.ru/DIRECT-152633
     */
    public static final PpcPropertyName<Double> SHOW_DNA_ABT_INFO_SOFT_TIMEOUT =
            new PpcPropertyName<>("SHOW_DNA_ABT_INFO_SOFT_TIMEOUT", DOUBLE);
    public static final PpcPropertyName<Integer> SHOW_DNA_ABT_INFO_NUM_ATTEMPTS =
            new PpcPropertyName<>("SHOW_DNA_ABT_INFO_NUM_ATTEMPTS", INTEGER);

    /**
     * Длительность периодов целей в шорткатах условий ретаргетинга
     */
    public static final PpcPropertyName<Integer> RETARGETING_CONDITION_CAMPAIGN_GOALS_SHORTCUT_GOAL_TIME_DAYS =
            new PpcPropertyName<>("retargeting_condition_campaign_goals_shortcut_goal_time_days", INTEGER);
    public static final PpcPropertyName<Integer> RETARGETING_CONDITION_CAMPAIGN_GOALS_LAL_SHORTCUT_GOAL_TIME_DAYS =
            new PpcPropertyName<>("retargeting_condition_campaign_goals_lal_shortcut_goal_time_days", INTEGER);

    /**
     * Валидация для смарта по сайту и в целом еком-сценариев.
     */
    public static final PpcPropertyName<Boolean> DO_VALIDATE_FEED_SITES_BY_ECOM_DOMAINS =
            new PpcPropertyName<>("do_validate_feed_sites_by_ecom_domains", BOOLEAN);

    public static final PpcPropertyName<Long> MIN_OFFERS_AMOUNT_ON_SITE_ALLOWED =
            new PpcPropertyName<>("min_offers_amount_on_site_allowed", LONG);

    public static final PpcPropertyName<Long> MAX_OFFERS_AMOUNT_ON_SITE_ALLOWED =
            new PpcPropertyName<>("max_offers_amount_on_site_allowed", LONG);

    /**
     * Для джобы ReceiveEcomDomainsPreviewsJob
     * Определяет количество повторов чтения из топика за один запуск джобы
     */
    public static final PpcPropertyName<Integer> PREVIEW_TOPIC_READS_COUNT =
            new PpcPropertyName<>("preview_topic_reads_count", INTEGER);

    /**
     * Для включения параллельного запроса фичей на оператора и клиента
     * см. https://st.yandex-team.ru/DIRECT-154159
     */
    public static final PpcPropertyName<Boolean> FEATURES_PARALLEL_REQUEST =
            new PpcPropertyName<>("FEATURES_PARALLEL_REQUEST", BOOLEAN);

    /**
     * Для батчевания грутовых запросов вида (list_contains(asset_ids, a) or list_contains(asset_ids, b) or ...)
     */
    public static final PpcPropertyName<Integer> GRUT_LIST_CONTAINS_BATCH_SIZE =
            new PpcPropertyName<>("grut_list_contains_batch_size", INTEGER);

    public static final PpcPropertyName<Integer> GRUT_CAMPAIGNS_BATCH_SIZE =
            new PpcPropertyName<>("grut_campaigns_batch_size", INTEGER);

    /**
     * Для включения параметра multisession=yes при походах в blackbox
     * см. https://st.yandex-team.ru/DIRECT-154164
     */
    public static final PpcPropertyName<Boolean> BLACKBOX_USE_MULTISESSION =
            new PpcPropertyName<>("BLACKBOX_USE_MULTISESSION", BOOLEAN);

    public static final PpcPropertyName<Integer> BS_EXPORT_FIX_ORDER_TYPE_PERCENT =
            new PpcPropertyName<>("BS_EXPORT_FIX_ORDER_TYPE_PERCENT", INTEGER);

    /**
     * Максимальное кол-во текстовых ассетов в кампании для UAC
     */
    public static final PpcPropertyName<Integer> MAX_TEXTS_IN_UAC =
            new PpcPropertyName<>("max_texts_in_uac", INTEGER);
    public static final PpcPropertyName<Integer> MAX_TITLES_IN_UAC =
            new PpcPropertyName<>("max_titles_in_uac", INTEGER);

    /**
     * Надо ли экспортировать RfOptions с фильтрацией кампаний внутренней рекламы
     */
    public static final PpcPropertyName<Boolean> BS_EXPORT_RF_OPTIONS_FILTER_INTERNAL_CAMPAIGN_ENABLED =
            new PpcPropertyName<>("BS_EXPORT_RF_OPTIONS_FILTER_INTERNAL_CAMPAIGN_ENABLED", BOOLEAN);

    /**
     * Фильтрация кампаний внутренней рекламы по id клиента для экспорта RfOptions
     */
    public static final PpcPropertyName<Set<Long>> BS_EXPORT_RF_OPTIONS_FILTER_BY_CLIENT_IDS =
            new PpcPropertyName<>("BS_EXPORT_RF_OPTIONS_FILTER_BY_CLIENT_IDS", LONG_SET);

    /**
     * Надо ли экспортировать RfOptions с фильтрацией групп внутренней рекламы
     */
    public static final PpcPropertyName<Boolean> BS_EXPORT_RF_OPTIONS_FILTER_INTERNAL_AD_GROUPS_ENABLED =
            new PpcPropertyName<>("BS_EXPORT_RF_OPTIONS_FILTER_INTERNAL_AD_GROUPS_ENABLED", BOOLEAN);
    /**
     * Фильтрация групп внутренней рекламы по id кампании для экспорта RfOptions
     */
    public static final PpcPropertyName<Set<Long>> BS_EXPORT_RF_OPTIONS_FILTER_BY_CAMPAIGN_IDS =
            new PpcPropertyName<>("BS_EXPORT_RF_OPTIONS_FILTER_BY_CAMPAIGN_IDS", LONG_SET);

    /**
     * Содержит множество placeId для которых не надо экспортировать старый RF
     */
    public static final PpcPropertyName<Set<Long>> BS_EXPORT_OLD_RF_DISABLED_PLACE_IDS =
            new PpcPropertyName<>("BS_EXPORT_OLD_RF_DISABLED_PLACE_IDS", LONG_SET);

    /**
     * Надо ли экспортировать старый RF с фильтрацией групп внутренней рекламы
     */
    public static final PpcPropertyName<Boolean> BS_EXPORT_OLD_RF_FILTER_INTERNAL_AD_GROUPS_ENABLED =
            new PpcPropertyName<>("BS_EXPORT_OLD_RF_FILTER_INTERNAL_AD_GROUPS_ENABLED", BOOLEAN);
    /**
     * Фильтрация групп внутренней рекламы по id кампании для экспорта старого RF
     */
    public static final PpcPropertyName<Set<Long>> BS_EXPORT_OLD_RF_FILTER_BY_CAMPAIGN_IDS =
            new PpcPropertyName<>("BS_EXPORT_OLD_RF_FILTER_BY_CAMPAIGN_IDS", LONG_SET);

    /**
     * Экспортировать баннерные ресурсы для картиночных копий баннеров
     */
    public static final PpcPropertyName<Boolean> BS_EXPORT_ASSETS_FOR_IMAGE_COPY_BANNER_ENABLED =
            new PpcPropertyName<>("BS_EXPORT_ASSETS_FOR_IMAGE_COPY_BANNER_ENABLED", BOOLEAN);
    /**
     * Id баннеров, для картиночных копий которых нужно экспортировать баннерные ресурсы
     */
    public static final PpcPropertyName<Set<Long>> BS_EXPORT_ASSETS_FOR_IMAGE_COPY_BANNER_BY_BIDS =
            new PpcPropertyName<>("BS_EXPORT_ASSETS_FOR_IMAGE_COPY_BANNER_BY_BIDS", LONG_SET);
    /**
     * Экспортировать баннерные ресурсы на событие добавления картинки
     */
    public static final PpcPropertyName<Boolean> BS_EXPORT_ASSETS_ON_IMAGE_ADDITION_ENABLED =
            new PpcPropertyName<>("BS_EXPORT_ASSETS_ON_IMAGE_ADDITION_ENABLED", BOOLEAN);
    /**
     * Id баннеров, для которых нужно экспортировать баннерные ресурсы на событие добавления картинки
     */
    public static final PpcPropertyName<Set<Long>> BS_EXPORT_ASSETS_ON_IMAGE_ADDITION_BY_BIDS =
            new PpcPropertyName<>("BS_EXPORT_ASSETS_ON_IMAGE_ADDITION_BY_BIDS", LONG_SET);

    /**
     * Процент кампаний, для баннеров которых не отправляется TargetFlat в БК
     */
    public static final PpcPropertyName<Integer> BS_EXPORT_TARGET_FLAT_DISABLED_PERCENT =
            new PpcPropertyName<>("BS_EXPORT_TARGET_FLAT_DISABLED_PERCENT", INTEGER);

    /**
     * Для включения нового дефолтного типа атрибуции last_yandex_direct_click_cross_device
     */
    public static final PpcPropertyName<Boolean> CROSS_DEVICE_DEFAULT_ATTRIBUTION_TYPE_ENABLED =
            new PpcPropertyName<>("CROSS_DEVICE_DEFAULT_ATTRIBUTION_TYPE_ENABLED", BOOLEAN);

    public static final PpcPropertyName<Boolean> ENABLE_ORIG_THUMB_IN_UAC =
            new PpcPropertyName<>("enable_orig_thumb_in_uac", BOOLEAN);


    /**
     * Попрог конверсий для трекерных ссылок для включения CRR стратегии
     */
    public static final PpcPropertyName<Long> CRR_TRACKER_CONVERSIONS_NUM_THRESHOLD =
            new PpcPropertyName<>("CRR_TRACKER_CONVERSIONS_NUM_THRESHOLD", LONG);
    /**
     * Попрог конверсий для мобильных приложений для включения CRR стратегии
     */
    public static final PpcPropertyName<Long> CRR_MOBILE_APP_CONVERSIONS_NUM_THRESHOLD =
            new PpcPropertyName<>("CRR_MOBILE_APP_CONVERSIONS_NUM_THRESHOLD", LONG);
    /**
     * За какой период считается количество конверсий для мобильного приложения и трекерной ссылки
     */
    public static final PpcPropertyName<Integer> CRR_CONVERSIONS_THRESHOLD_INTERVAL_IN_DAYS =
            new PpcPropertyName<>("CRR_CONVERSIONS_THRESHOLD_INTERVAL_IN_DAYS", INTEGER);

    /**
     * Переключение гео-дерева
     */
    public static final PpcPropertyName<Boolean> USE_NEXT_GEO_TREE =
            new PpcPropertyName<>("use_next_geo_tree", BOOLEAN);

    /**
     * Для ассетов без баннеров в uac выставлять статус не rejected, а moderating
     */
    public static final PpcPropertyName<Boolean> UAC_MODERATING_STATUS_FOR_ASSETS_WITHOUT_BANNERS =
            new PpcPropertyName<>("uac_moderating_status_for_assets_wuthout_banners", BOOLEAN);

    /**
     * Включить мониторинг падений джобы UpdateAdsJob и генерацию тикетов с пострадавшими кампаниями
     */
    public static final PpcPropertyName<Boolean> UAC_FAILED_JOBS_MONITORING_ENABLED =
            new PpcPropertyName<>("uac_failed_jobs_monitoring_enabled", BOOLEAN);

    /**
     * Время предыдущего запуска джобы по мониторингу упавших джоб UpdateAdsJob
     */
    public static final PpcPropertyName<LocalDateTime> UAC_FAILED_JOBS_MONITORING_LAST_TIME =
            new PpcPropertyName<>("uac_failed_jobs_monitoring_last_time", LOCAL_DATE_TIME);

    /**
     * Пользователь, на которого будут назначены тикеты с постарадавшими от падений UpdateAdsJob кампаниями
     */
    public static final PpcPropertyName<String> UAC_FAILED_JOBS_MONITORING_ASSIGNEE_LOGIN =
            new PpcPropertyName<>("uac_failed_jobs_monitoring_assignee_login", STRING);

    /**
     * Пользователь, на которого будут назначены тикеты с постарадавшими от падений UpdateAdsJob CPM кампаниями
     */
    public static final PpcPropertyName<String> CPM_UAC_FAILED_JOBS_MONITORING_ASSIGNEE_LOGIN =
            new PpcPropertyName<>("cpm_uac_failed_jobs_monitoring_assignee_login", STRING);

    /**
     * Пользователь, на которого будут назначены тикеты с постарадавшими от падений UpdateAdsJob e-com кампаниями
     */
    public static final PpcPropertyName<String> ECOM_UAC_FAILED_JOBS_MONITORING_ASSIGNEE_LOGIN =
            new PpcPropertyName<>("ecom_uac_failed_jobs_monitoring_assignee_login", STRING);

    /**
     * Пользователь, на которого будут назначены тикеты с постарадавшими от падений UpdateAdsJob РМП кампаниями
     */
    public static final PpcPropertyName<String> MOBILE_UAC_FAILED_JOBS_MONITORING_ASSIGNEE_LOGIN =
            new PpcPropertyName<>("mobile_uac_failed_jobs_monitoring_assignee_login", STRING);

    public static final PpcPropertyName<Boolean> USE_NEW_SELF_STATUS_CALCULATOR =
            new PpcPropertyName<>("use_new_self_status_calculator", BOOLEAN);

    /**
     * при проверке свежести кластера пропускать шарды (для добавления новых шардов в mysql-sync-states)
     */
    public static final PpcPropertyName<List<Integer>> ORDER_STAT_SKIP_SHARDS =
            new PpcPropertyName<>("order_stat_skip_shards", INT_LIST);

    /**
     * Для джобы EcomDomainStatusesMonitoringJob
     * Определяет количество дней, в рамках которых должно происходить обновление офферов в превью
     * джобой ReceiveEcomDomainsPreviewsJob. Еком домены, для которых оффера не обновлялись большее количество дней -
     * отображаются в мониторинге в Solomon'е
     */
    public static final PpcPropertyName<Long> DAYS_LIMIT_FOR_UPDATING_PREVIEW =
            new PpcPropertyName<>("days_limit_for_updating_preview", LONG);

    /**
     * Включена ли джоба MobileAppsAutoGoalsJob для автодобавления целей мобильных приложений
     */
    public static final PpcPropertyName<Boolean> MOBILE_APPS_AUTO_GOALS_JOB_ENABLED =
            new PpcPropertyName<>("MOBILE_APPS_AUTO_GOALS_JOB_ENABLED", BOOLEAN);

    /**
     * Размер чанка для ваншота репликации mysql -> GrUT
     */
    public static final PpcPropertyName<Long> MYSQL2GRUT_ONESHOT_CHUNK_SIZE =
            new PpcPropertyName<>("mysql2grut_oneshot_chunk_size", LONG);

    /**
     * Время между итерациями для ваншота репликации mysql -> GrUT
     */
    public static final PpcPropertyName<Long> MYSQL2GRUT_ONESHOT_RELAX_TIME_SEC =
            new PpcPropertyName<>("mysql2grut_oneshot_relax_time_sec", LONG);

    public static final PpcPropertyName<Long> MINUSGEO_FLAGS_ONESHOT_CHUNK_SIZE =
            new PpcPropertyName<>("minusgeo_flags_oneshot_chunk_size", LONG);

    public static final PpcPropertyName<Long> MINUSGEO_FLAGS_ONESHOT_RELAX_TIME_SEC =
            new PpcPropertyName<>("minusgeo_flags_oneshot_relax_time_sec", LONG);

    /**
     * Возможность использования видео некоторых форматов для создания креатива через АПИ до завершения его конвертации
     */
    public static final PpcPropertyName<Boolean> ENABLE_CREATE_EARLY_CREATIVE_IN_API =
            new PpcPropertyName<>("ENABLE_CREATE_EARLY_CREATIVE_IN_API", BOOLEAN);

    public static final PpcPropertyName<Boolean> IGNORE_AUTOBUDGET_RESTART =
            new PpcPropertyName<>("ignore_autobudget_restart", BOOLEAN);

    /**
     * Использовать новый адрес advq forecast https://st.yandex-team.ru/ADVQ-2228
     */
    public static final PpcPropertyName<Boolean> USE_CLOUD_ADVQ_FORECAST =
            new PpcPropertyName<>("USE_CLOUD_ADVQ_FORECAST", BOOLEAN);


    /**
     * Настройка погрешности для кратных картинок в процентах
     */
    public static final PpcPropertyName<Integer> INACCURACY_IN_PERCENTS_FOR_PROPORTIONALLY_LARGER_IMAGES =
            new PpcPropertyName<>("INACCURACY_IN_PERCENTS_FOR_PROPORTIONALLY_LARGER_IMAGES", INTEGER);

    /**
     * Настройка максимальной кратности картинок  https://st.yandex-team.ru/DIRECT-157814
     */
    public static final PpcPropertyName<Integer> MAX_RATIO_FOR_PROPORTIONALLY_LARGER_IMAGES =
            new PpcPropertyName<>("MAX_RATIO_FOR_PROPORTIONALLY_LARGER_IMAGES", INTEGER);

    /**
     * Время между итерациями при обновлении кампаний с совместным управлением ставками на раздельное
     */
    public static final PpcPropertyName<Long> FLAT_CPC_FROM_YT_MIGRATION_RELAX_TIME =
            new PpcPropertyName<>("FLAT_CPC_FROM_YT_MIGRATION_RELAX_TIME", LONG);
    /**
     * Флаг для включения/выключения добавления условия available=true по умолчанию в фильтры смарт-групп по сайту
     */
    public static final PpcPropertyName<Boolean> ADD_DEFAULT_SITE_FILTER_CONDITION_ENABLED =
            new PpcPropertyName<>("ADD_DEFAULT_SITE_FILTER_CONDITION_ENABLED", BOOLEAN);

    /**
     * Дата начала работы актуальных ограничений по бюджету брендлифта.
     */
    public static final PpcPropertyName<LocalDate> BRAND_SURVEY_BUDGET_DATE =
            new PpcPropertyName<>("brand_survey_budget_date", LOCAL_DATE);

    /**
     * Логгируем ли изменения ставок при применении ваншота мигрирования кампаний с совместного управления ставками
     * на раздельное
     */
    public static final PpcPropertyName<Boolean> FLAT_CPC_FROM_YT_MIGRATION_SHOULD_LOG_BIDS_CHANGES =
            new PpcPropertyName<>("FLAT_CPC_FROM_YT_MIGRATION_SHOULD_LOG_BIDS_CHANGES", BOOLEAN);

    /**
     * Брать данные для расчета рестарта автобюджета всегда из таблицы в camp_autobudget_restart, а не из GRuT
     * Это нужно для того, чтобы если в расчетах в GRuT произошла ошибка, можно было правильно их пересчитать
     */
    public static final PpcPropertyName<Boolean> GRUT_USE_MYSQL_TABLE_FOR_AUTOBUDGET_RESTART_REPLICATION =
            new PpcPropertyName<>("grut_use_mysql_table_for_autobudget_restart_replication", BOOLEAN);

    /**
     * Минимальное время создание ассета, которое надо анализировать на предмет уаления
     */
    public static final PpcPropertyName<LocalDateTime> DELETE_UAC_ASSET_MIN_LOOKUP_TIME =
            new PpcPropertyName<>("delete_uac_asset_min_lookup_time", LOCAL_DATE_TIME);

    /**
     * Количество дней на котороые надо сдвинутся от текущего, чтобы удалять ассеты
     */
    public static final PpcPropertyName<Long> DELETE_UAC_ASSET_CURRENT_DATE_OFFSET =
            new PpcPropertyName<>("delete_uac_asset_current_date_offset", LONG);

    /**
     * Количество секунд между итерациями удаления ассетов
     */
    public static final PpcPropertyName<Long> DELETE_UAC_ASSET_IDLE_TIME =
            new PpcPropertyName<>("delete_uac_asset_idle_time", LONG);

    /**
     * Количество допустимых итераций удаления за один запуск
     */
    public static final PpcPropertyName<Integer> DELETE_UAC_ASSET_ITERATION_LIMIT =
            new PpcPropertyName<>("delete_uac_asset_iteration_limit", INTEGER);

    /**
     * Количество допустимых удалений за один запуск
     */
    public static final PpcPropertyName<Long> DELETE_UAC_ASSET_TOTAL_DELETE_LIMIT =
            new PpcPropertyName<>("delete_uac_asset_total_delete_limit", LONG);

    /**
     * Процент запросов в ручку получения заявок, на который формировать ответ в двух форматах (proto и обычный)
     * и логировать различия
     */
    public static final PpcPropertyName<Integer> UAC_GET_CAMPAIGN_PROTO_RESPONSE_DIFF_PERCENT =
            new PpcPropertyName<>("uac_get_campaign_proto_response_diff_percent", INTEGER);

    /**
     * Не проверять в репликации кампаний наличие внешинх сущностей
     */
    public static final PpcPropertyName<Boolean> CAMPAIGN_REPLICATION_FILTER_WITHOUT_FOREIGN =
            new PpcPropertyName<>("campaign_replication_filter_without_foreign", BOOLEAN);

    /**
     * Не проверять в репликации кампаний наличие внешинх сущностей
     */
    public static final PpcPropertyName<Boolean> ADGROUP_REPLICATION_FILTER_WITHOUT_FOREIGN =
            new PpcPropertyName<>("adgroup_replication_filter_without_foreign", BOOLEAN);

    /**
     * Максимальное количество кампаний, которые можно прилинковать к пакетной стратегии
     */
    public static final PpcPropertyName<Integer> MAX_NUMBER_OF_CIDS_ABLE_TO_LINK_TO_PACKAGE_STRATEGY =
            new PpcPropertyName<>("MAX_NUMBER_OF_CIDS_ABLE_TO_LINK_TO_PACKAGE_STRATEGY", INTEGER);

    /**
     * Лимит на число удаляемых гипер гео и сегментов джобой DeleteUnusedHyperGeosJob
     */
    public static final PpcPropertyName<Integer> HYPER_GEO_IDS_TO_DELETE_LIMIT =
            new PpcPropertyName<>("hyper_geo_ids_to_delete_limit", INTEGER);
    /**
     * Id гео-сегментов, которые не нужно пытаться удалить.
     * Например, касается сегментов, на которые пользователи сами завязали lal-ы, и теперь их удалить из Аудиторий
     * не выйдет, хотя в Директе они больше не используются.
     */
    public static final PpcPropertyName<Set<Long>> HYPER_GEO_SEGMENT_IDS_TO_BYPASS_DELETING =
            new PpcPropertyName<>("hyper_geo_segment_ids_to_bypass_deleting", LONG_SET);

    /**
     * Флаг для включения/выключения отправки альтернативных сторов в БК
     */
    public static final PpcPropertyName<Boolean> ENABLE_ALTERNATIVE_APP_STORES =
            new PpcPropertyName<>("ENABLE_ALTERNATIVE_APP_STORES", BOOLEAN);

    /**
     * Таймстамп, до которого были обработаны изменения фичей
     */
    public static final PpcPropertyName<Long> FEATURES_SYNC_LAST_EVENT_ID =
            new PpcPropertyName<>("features_sync_last_event_id", LONG);

    /**
     * Множество фичей, состояние включенности которых не будет синхронизироваться из прода
     * (имеет значение только на непродовых средах)
     */
    public static final PpcPropertyName<Set<String>> FEATURES_SYNC_IGNORED_FEATURES =
            new PpcPropertyName<>("features_sync_ignored_features", STRING_SET);

    /**
     * Предельное число запросов, которые Директ может отослать в AppMetrica без риска превысить RPS limit
     */
    public static final PpcPropertyName<Long> APP_METRICA_REQUEST_LIMIT =
            new PpcPropertyName<>("app_metrica_request_limit", LONG);

    /**
     * Время простоя, чтобы не превышать RPS limit AppMetrica, ms
     */
    public static final PpcPropertyName<Long> APP_METRICA_REQUEST_IDLE_TIME =
            new PpcPropertyName<>("app_metrica_request_idle_time", LONG);

    /**
     * Размер обрабатываемого батча для ваншота миграции идентификаторов пакетных стратегий.
     */
    public static final PpcPropertyName<Integer> PACKAGE_STRATEGY_IDENTIFIERS_MIGRATION_BATCH_LIMIT =
            new PpcPropertyName<>("PACKAGE_STRATEGY_IDENTIFIERS_MIGRATION_BATCH_LIMIT", INTEGER);

    /**
     * Список рекламных клиентов бизнез юнитов.
     */
    public static final PpcPropertyName<List<Long>> BUSINESS_UNIT_CLIENT_IDS =
            new PpcPropertyName<>("business_unit_client_ids", LONG_LIST);

    /**
     * Флаг включенности отправки рестарта автобюджета в транспорте стратегий.
     */
    public static final PpcPropertyName<Boolean> PACKAGE_STRATEGY_AUTOBUDGET_RESTART_TRANSPORT_ENABLED =
            new PpcPropertyName<>("package_strategy_autobudget_restart_transport_enabled", BOOLEAN);

    /**
     * Размер батча миграции рестартов автобюджета
     */
    public static final PpcPropertyName<Long> PACKAGE_STRATEGY_AUTOBUDGET_RESTART_MIGRATION_BATCH_SIZE =
            new PpcPropertyName<>("package_strategy_autobudget_restart_migration_batch_size", LONG);

    /**
     * Время ожидания между итерациями миграции рестартов автобюджета
     */
    public static final PpcPropertyName<Integer> PACKAGE_STRATEGY_AUTOBUDGET_RESTART_MIGRATION_RELAX_TIME =
            new PpcPropertyName<>("package_strategy_autobudget_restart_migration_relax_time", INTEGER);


    /**
     * Флаг для включения/выключения отоброжаемых аттрибутов для мобильных баннеров
     */
    public static final PpcPropertyName<Boolean> SHOW_REFLECTED_ATTRS_FOR_ALL_MOBILE_BANNERS =
            new PpcPropertyName<>("show_reflected_attrs_for_all_mobile_banners", BOOLEAN);

    /**
     * Список клиентов для включения отоброжаемых аттрибутов для мобильных баннеров
     */
    public static final PpcPropertyName<List<Long>> SHOW_REFLECTED_ATTRS_FOR_ALL_MOBILE_BANNERS_FOR_CLIENTS =
            new PpcPropertyName<>("show_reflected_attrs_for_all_mobile_banners_for_clients", LONG_LIST);

    /**
     * Переключалка джоба/скрипт для отправки новых фидов в BmApi
     */
    public static final PpcPropertyName<Boolean> SEND_NEW_FEEDS_IN_BL_FROM_JOBS =
            new PpcPropertyName<>("send_new_feeds_in_bl_from_jobs", BOOLEAN);

    /**
     * Количество фидов отправляемых в BannerLand за одну итерацию
     */
    public static final PpcPropertyName<Integer> DEFAULT_FEED_TO_BANNERLAND_ITERATION_CAPACITY =
            new PpcPropertyName<>("default_feed_to_bannerland_iteration_capacity", INTEGER);

    /*
     * Процент кампаний, на группах которых в ESS-транспорте в БК не будут учитываться minus geo с баннеров
     * для вычисления поля showConditions
     *
     * По умолчанию 0
     */
    public static final PpcPropertyName<Integer> IGNORE_MINUS_GEO_IN_ADGROUP_CONDITIONS_CID_PERCENT =
            new PpcPropertyName<>("ignore_minus_geo_in_adgroup_conditions_cid_percent", INTEGER);

    /**
     * Выделенные айдишники кампаний, на группах которых в ESS-транспорте в БК не будут учитываться
     * minus geo с баннеров для вычисления поля showConditions
     * <p>
     * По умолчанию пустое множество
     */
    public static final PpcPropertyName<Set<Long>> IGNORE_MINUS_GEO_IN_ADGROUP_CONDITIONS_CIDS =
            new PpcPropertyName<>("ignore_minus_geo_in_adgroup_conditions_cids", LONG_SET);

    /**
     * На какую глубину (в месяцах) искать в пользовательских логах информацию о возможности автоприменения рекомендаций
     */
    public static final PpcPropertyName<Integer> MAX_TIME_DEPTH_FOR_AUTO_APPLY_HISTORY =
            new PpcPropertyName<>("MAX_TIME_DEPTH_FOR_AUTO_APPLY_HISTORY", INTEGER);

    /**
     * Список логинов, для которых действует очистка кампаний, просыпанных тестами
     */
    public static final PpcPropertyName<Set<String>> CLEAN_TESTING_CAMPAIGNS_LOGINS =
            new PpcPropertyName<>("clean_testing_campaigns_logins", STRING_SET);

    /**
     * Список тестовых кампаний, защищенных от автоматического удаления
     */
    public static final PpcPropertyName<Set<Long>> CLEAN_TESTING_CAMPAIGNS_CID_BLACKLIST =
            new PpcPropertyName<>("clean_testing_campaigns_cid_blacklist", LONG_SET);

    /**
     * Возраст кампаний для автоматического удаления
     */
    public static final PpcPropertyName<Long> CLEAN_TESTING_CAMPAIGNS_AGE_MINUTES =
            new PpcPropertyName<>("clean_testing_campaigns_age_minutes", LONG);

    /**
     * Обновлять в джобе MobileAppsIosSkadNetworkSlotsJob слоты в груте
     */
    public static final PpcPropertyName<Boolean> UPDATE_SKAD_NETWORK_SLOTS_IN_GRUT =
            new PpcPropertyName<>("update_skad_network_slots_in_grut", BOOLEAN);

    /**
     * Минимальное время между проверками телефона клиента (в часах)
     */
    public static final PpcPropertyName<Integer> MIN_PHONE_VERIFICATION_COOLDOWN_HOURS =
            new PpcPropertyName<>("min_phone_verification_cooldown_hours", INTEGER);

    /**
     * Обновлять в ручке обновления прайсовых пакетов поле auctionPriority в груте
     */
    public static final PpcPropertyName<Boolean> UPDATE_AUCTION_PRIORITY_IN_GRUT =
            new PpcPropertyName<>("update_auction_priority_in_grut", BOOLEAN);

    private PpcPropertyNames() {
    }

    private static <T> PpcPropertyName<T> shardedLowercase(String prefix, PpcPropertyType<T> type, int shard) {
        String name = String.format("%s_shard_%d", prefix, shard);
        return new PpcPropertyName<>(name, type);
    }

    private static <T> PpcPropertyName<T> shardedUppercase(String prefix, PpcPropertyType<T> type, int shard) {
        String name = String.format("%s_SHARD_%d", prefix, shard);
        return new PpcPropertyName<>(name, type);
    }

    private static <T> PpcPropertyName<T> parametrizedUppercase(String prefix, PpcPropertyType<T> type, String param) {
        String name = String.format("%s_PARAM_%s", prefix, param);
        return new PpcPropertyName<>(name, type);
    }

    public static PpcPropertyName<Integer> bsExportStdWorkersNum(int shard) {
        return shardedLowercase("bs_export_std_workers_num", INTEGER, shard);
    }

    public static PpcPropertyName<Integer> bsExportHeavyWorkersNum(int shard) {
        return shardedLowercase("bs_export_heavy_workers_num", INTEGER, shard);
    }

    public static PpcPropertyName<Integer> bsExportFullLbExportWorkersNum(int shard) {
        return shardedLowercase("bs_full_lb_export_workers_num", INTEGER, shard);
    }

    public static PpcPropertyName<Integer> bsExportBuggyWorkersNum(int shard) {
        return shardedLowercase("bs_export_buggy_workers_num", INTEGER, shard);
    }

    /**
     * id последней кампании, обработанной мастер-процессом ре-экспорта в шарде
     *
     * @param shard шард для которого требуется значение
     */
    public static PpcPropertyName<Long> fullLbExportLastProcessedCampaignId(int shard) {
        return shardedUppercase(FULL_LB_EXPORT_LAST_PROCESSED_CAMPAIGN_ID_PREFIX, LONG, shard);
    }

    /**
     * значение userAttribute last_sync_time_bs-chevent-log таблицы OrderStat, из которой последний раз происходила
     * загрузка данных
     *
     * @param workerNum - номер воркера, для которого требуется получить значение
     */
    public static PpcPropertyName<Long> activeOrdersOrderStatBsCheventLogTimestamp(String workerNum) {
        return parametrizedUppercase(ACTIVE_ORDERS_ORDER_STAT_BS_CHEVENT_LOG_TIMESTAMP, LONG, workerNum);
    }

    /**
     * знчение userAttribute last_sync_time_bs-chevent-log таблицы c подготовленными данными для импорта bs_auction_stat
     *
     * @param shard шард для которого требуется значение
     */
    public static PpcPropertyName<String> auctionstatUpdateCheventLogTimestamp(int shard) {
        return shardedUppercase(AUCTIONSTAT_UPDATE_CHEVENT_LOG_TIMESTAMP, STRING, shard);
    }

    /**
     * время последней загрузки данных в таблицу bs_auction_stat
     *
     * @param shard шард для которого требуется значение
     */
    public static PpcPropertyName<String> bsAuctionStatTime(int shard) {
        return shardedLowercase(BS_AUCTION_STAT_TIME, STRING, shard);
    }

    /**
     * Минимальный bid, обработанный джобой FillBannerLanguageJob.
     *
     * @param shard шард для которого требуется значение
     */
    public static PpcPropertyName<Long> minBidWithProcessedLanguage(int shard) {
        return shardedLowercase(MIN_BID_WITH_PROCESSED_LANGUAGE, LONG, shard);
    }

    /**
     * Максимальный last_change из таблицы camp_aggregated_lastchange
     * Знаечние используется в api
     *
     * @param shard шард для которого требуется значение
     */
    public static PpcPropertyName<LocalDateTime> campAggregatedLastchangeHighBoundary(int shard) {
        return shardedLowercase(CAMP_AGGREGATED_LASTCHANGE_HIGH_BOUNDARY, LOCAL_DATE_TIME, shard);
    }

    /**
     * Включен ли джоб RecalculateCampaignStatusesJob
     *
     * @param shard шард, для которого требуется значение
     */
    public static PpcPropertyName<Boolean> recalculateCampaignsStatusJobEnabled(int shard) {
        return shardedLowercase(RECALCULATE_CAMPAIGNS_STATUS_JOB_ENABLED, BOOLEAN, shard);
    }

    /**
     * Id последней кампании, обработанной джобой RecalculateStatusesJob.
     *
     * @param shard шард, для которого требуется значение
     */
    public static PpcPropertyName<Long> lastProcessedCampaignId(int shard) {
        return shardedLowercase(LAST_CAMPAIGN_ID_WITH_RECALCULATED_STATUS, LONG, shard);
    }

    /**
     * Дата послденего собранного лога для расчета AB метрик
     */
    public static PpcPropertyName<Long> lastAbPreparedDate(String param) {
        return parametrizedUppercase(LAST_AB_PREPARED_DATA, LONG, param);
    }

    /**
     * Modification time последней обработанной таблички с событиями
     */
    public static PpcPropertyName<String> lastSendedCommunicationEventsTableModificationTime(String param) {
        String prefix = COMMUNICATIONS_MODIFICATION_TIME_LAST_TABLE;
        if (param.length() + 15 + "_PARAM_".length() > NAME_MAX_LENGTH) {
            // если строка с параметрами слишком длинная для названия проперти, то используем hash от нее.
            // 15 - длина "communications_", чтобы не получить слишком короткий префикс и не получить коллизию.
            param = "hash_" + param.hashCode();
        } else if (prefix.length() + "_PARAM_".length() + param.length() > NAME_MAX_LENGTH) {
            // если можно уложиться в лимит, обрезав префикс, то делаем это.
            prefix = prefix.substring(0, NAME_MAX_LENGTH - param.length() - "_PARAM_".length());
        }
        return parametrizedUppercase(prefix, STRING, param);
    }

    /**
     * Максимальный LastChange, обработанный джобой RemoveSpamFromModerationExportQueueJob для шарда.
     *
     * @param shard шард для которого требуется значение
     */
    public static PpcPropertyName<LocalDateTime> removeSpamFromModerationExportQueueLastTime(int shard) {
        return shardedLowercase(REMOVE_SPAM_FROM_MODERATION_EXPORT_QUEUE_LAST_TIME, LOCAL_DATE_TIME, shard);
    }

    /**
     * Текущий стейт джобы для переотправки ресурсов баннера из таблицы в очередь, соответствующий параметру
     */
    public static PpcPropertyName<String> bannerResourcesTableToQueueResyncState(String param) {
        return parametrizedUppercase(BANNER_RESOURCES_TABLE_TO_QUEUE_RESYNC_STATE, STRING, param);
    }

    /**
     * Текущий стейт джобы для переотправки групп из таблицы в очередь, соответствующий параметру
     */
    public static PpcPropertyName<String> adGroupsTableToQueueResyncState(String param) {
        return parametrizedUppercase(AD_GROUPS_TABLE_TO_QUEUE_RESYNC_STATE, STRING, param);
    }

    /**
     * Текущий стейт джобы для переотправки условий показа из таблицы в очередь, соответствующий параметру
     */
    public static PpcPropertyName<String> adGroupsShowConditionTableToQueueResyncState(String param) {
        return parametrizedUppercase(AD_GROUPS_SHOW_CONDITION_TABLE_TO_QUEUE_RESYNC_STATE, STRING, param);
    }

    /**
     * Время, до которого собрана статистика по новым созданным объектам для конкретного шарда
     * джобой CreatedObjectsStatsCollectJob.
     *
     * @param shard шард для которого требуется значение
     */
    public static PpcPropertyName<LocalDateTime> createdObjectsStatsLastCollectTime(int shard) {
        return shardedLowercase(CREATED_OBJECTS_STATS_LAST_COLLECT_TIME, LOCAL_DATE_TIME, shard);
    }

    /**
     * Прогресс скрипта/джобы для отправки напоминаний об окончании средств на счёте.
     * Используется в ppcMoneyOutReminder.pl и MoneyOutReminderJob.
     *
     * @param shard шард, для которого требуется прогресс
     * @return строка вида "дата,cid"
     */
    public static PpcPropertyName<String> moneyOutReminderProgress(int shard) {
        String name = String.format("%s_%d", PPC_MONEY_OUT_REMINDER_PROGRESS, shard);
        return new PpcPropertyName<>(name, STRING);
    }

    /**
     * Время, предыдущего запуска джобы по выключению фидов в MBI DisableFeedsInMBIJob.
     *
     * @param shard шард для которого требуется значение
     */
    public static PpcPropertyName<LocalDateTime> disableFeedsInMBILastTime(int shard) {
        return shardedLowercase(DISABLE_FEEDS_IN_MBI_LAST_TIME, LOCAL_DATE_TIME, shard);
    }
}
