package ru.yandex.direct.common.enums;

import java.util.stream.Stream;

import javax.annotation.Nullable;

public enum YandexDomain {
    RU("yandex.ru"),
    TR("yandex.com.tr"),
    UA("yandex.ua"),
    KZ("yandex.kz"),
    BY("yandex.by"),
    COM("yandex.com");

    private final String yandexDomain;

    YandexDomain(String yandexDomain) {
        this.yandexDomain = yandexDomain;
    }

    public String getYandexDomain() {
        return yandexDomain;
    }

    @Nullable
    public static YandexDomain fromValue(String yandexDomain) {
        return Stream.of(values())
                .filter(d -> d.getYandexDomain().equals(yandexDomain))
                .findFirst()
                .orElse(null);
    }

    @Override
    public String toString() {
        return getYandexDomain();
    }
}
