package ru.yandex.direct.common.jackson.jaxbmodule;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.deser.WrapperHandlingDeserializer;
import com.fasterxml.jackson.dataformat.xml.deser.XmlBeanDeserializerModifier;

/**
 * Должен работать только совместно с {@link JacksonXmlModule}!
 * <p>
 * {@link XmlBeanDeserializerModifier} из {@link JacksonXmlModule} модифицирует {@link BeanDeserializerBase},
 * добавляя работу с unwrapped списками с помощью {@link WrapperHandlingDeserializer}. В нашем модификаторе,
 * мы уже выдаём десериализатор, который умеет это делать {@link IgnoreWhitespaceWrapperHandlingDeserializer},
 * но проблемы с двойной обработкой unwrapped списков не будет, т.к. {@link XmlBeanDeserializerModifier}
 * не должен дополнительно модифицировать десериализатор, если это не {@link BeanDeserializerBase}
 * <p>
 * Модификация нужна для случая, когда внутри тэга только пробельные символы, например,
 * {@code <SelectionCriteria>    </SelectionCriteria>}. Этот случай рассматривается как null элемент.
 * Присутствие здесь {@link WrapperHandlingDeserializer} нужно для обхода проблемы с перенастройкой парсера.
 * Подробнее в {@link IgnoreWhitespaceWrapperHandlingDeserializer}.
 */
class IgnoreWhitespacesBeanDeserializerModifier extends BeanDeserializerModifier {
    @Override
    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc,
                                                  JsonDeserializer<?> deserializer) {
        if (deserializer instanceof BeanDeserializerBase) {
            return new IgnoreWhitespaceWrapperHandlingDeserializer(
                    new WrapperHandlingDeserializer((BeanDeserializerBase) deserializer));
        } else {
            return super.modifyDeserializer(config, beanDesc, deserializer);
        }
    }
}
